/*
 * Decompiled with CFR 0.152.
 */
package xyz.gunanyi.currency.utils;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import xyz.gunanyi.currency.annotation.PdfGenerate;
import xyz.gunanyi.currency.entity.PdfEntity;

public class PdfTableGenerate {
    public static PdfPTable pdfPTableGenerate(PdfPTable pdfPTable, Object obj) {
        LinkedHashMap<String, PdfEntity> pdfEntityMap = new LinkedHashMap<String, PdfEntity>();
        Class<?> cls = obj.getClass();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                Field field = fields[i];
                field.setAccessible(true);
                String name = field.getName();
                Object value = field.get(obj);
                PdfGenerate annotation = field.getAnnotation(PdfGenerate.class);
                if (annotation == null) continue;
                PdfEntity pdfEntity = new PdfEntity();
                pdfEntity.setTitle(annotation.value());
                pdfEntity.setContent(value == "" || value == null ? "--" : value.toString());
                pdfEntity.setContentCell(annotation.contentCell());
                pdfEntity.setTitleCell(annotation.titleCell());
                pdfEntity.setTitleSize(annotation.titleSize());
                pdfEntity.setContentSize(annotation.contentSize());
                pdfEntityMap.put(annotation.value(), pdfEntity);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return PdfTableGenerate.getPdfPTable(pdfPTable, pdfEntityMap);
    }

    public static PdfPTable getPdfPTable(PdfPTable pdfPTable, Map<String, PdfEntity> pdfEntityMap) {
        for (String key : pdfEntityMap.keySet()) {
            PdfEntity pdfEntity = pdfEntityMap.get(key);
            pdfPTable.addCell(PdfTableGenerate.createCell(pdfEntity.getTitle(), pdfEntity.getTitleCell(), pdfEntity.getTitleSize()));
            pdfPTable.addCell(PdfTableGenerate.createCell(pdfEntity.getContent(), pdfEntity.getContentCell(), pdfEntity.getContentSize()));
        }
        return pdfPTable;
    }

    public static PdfPCell createCell(String value, int colSpan, int size) {
        BaseFont bf = null;
        try {
            bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false, (boolean)false, null, null);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Font fontChinese5 = new Font(bf, (float)size);
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        cell.setPhrase(new Phrase(value, fontChinese5));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        return cell;
    }
}

