package xyz.gunanyi.currency.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author: zbw
 * 用于生成pdf表格
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface PdfGenerate {

    /**
     * 表格标题
     * @return null
     */
    public String value() default "";


    /**
     * 标题宽度（单元格）
     * @return null
     */
    public int titleCell() default 1;

    /**
     * 内容宽度（单元格）
     * @return null
     */
    public int contentCell() default 1;

    /**
     * 标题字体大小
     * @return null
     */
    public int titleSize() default 12;

    /**
     * 内容字体大小
     * @return null
     */
    public int contentSize() default 12;
}
