package xyz.gunanyi.currency.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 曾博旺
 */
@Data
@TableName("sys_operation_log")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="operation_log对象", description="日志记录表")
public class SysOperationLog implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "id")
    private Integer id;
	/**功能模块*/
    @ApiModelProperty(value = "功能模块")
    private String operModul;
	/**操作类型*/
    @ApiModelProperty(value = "操作类型")
    private String operType;
	/**操作描述*/
    @ApiModelProperty(value = "操作描述")
    private String operDesc;
	/**请求参数*/
    @ApiModelProperty(value = "请求参数")
    private String operRequParam;
	/**返回参数*/
    @ApiModelProperty(value = "返回参数")
    private String operRespParam;
	/**操作人员id(暂时没用)*/
    @ApiModelProperty(value = "操作人员id(暂时没用)")
    private String operUserId;
	/**操作员姓名*/
    @ApiModelProperty(value = "操作员姓名")
    private String operUserName;
	/**操作方法*/
    @ApiModelProperty(value = "操作方法")
    private String operMethod;
	/**请求uri*/
    @ApiModelProperty(value = "请求uri")
    private String operUri;
	/**请求ip*/
    @ApiModelProperty(value = "请求ip")
    private String operIp;
	/**操作前数据*/
    @ApiModelProperty(value = "操作前数据")
    private String operData;
	/**操作版本号*/
    @ApiModelProperty(value = "操作版本号")
    private String operVer;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
	/**备注*/
    @ApiModelProperty(value = "备注")
    private String remarks;
    /**操作表*/
    @ApiModelProperty(value = "操作表")
    private String operationTable;
    /**浏览器*/
    @ApiModelProperty(value = "浏览器")
    private String browser;
    /**操作系统*/
    @ApiModelProperty(value = "操作系统")
    private String os;
    /**ip*/
    @ApiModelProperty(value = "ip")
    private String ipaddress;
}
