/*
 * Decompiled with CFR 0.152.
 */
package xyz.juandiii.name.resources;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import xyz.juandiii.name.models.CheckAvailabilityDomain;
import xyz.juandiii.name.models.CheckAvailabilityDomainResult;
import xyz.juandiii.name.models.CreateDomain;
import xyz.juandiii.name.models.Domain;
import xyz.juandiii.name.models.ListDomain;
import xyz.juandiii.name.models.OrderDomain;
import xyz.juandiii.name.models.SearchDomain;
import xyz.juandiii.name.utils.ResponseWrapper;

public class DomainAsyncResource {
    private final ResteasyWebTarget target;

    public DomainAsyncResource(ResteasyWebTarget resteasyWebTarget) {
        this.target = resteasyWebTarget;
    }

    public CompletionStage<ListDomain> getDomains() {
        return this.target.path("/domains").request(new String[]{"application/json"}).rx().get().thenApply(response -> new ResponseWrapper((Response)response).get(ListDomain.class));
    }

    public CompletionStage<Domain> getDomain(String domain) {
        return this.target.path(String.format("/domains/%s", domain)).request(new String[]{"application/json"}).rx().get().thenApply(response -> new ResponseWrapper((Response)response).get(Domain.class));
    }

    public CompletionStage<OrderDomain> createDomain(CreateDomain createDomain) {
        return this.target.path("/domains").request(new String[]{"application/json"}).rx().post(Entity.entity((Object)createDomain, (String)"application/json")).thenApply(response -> new ResponseWrapper((Response)response).get(OrderDomain.class));
    }

    public CompletionStage<CheckAvailabilityDomainResult> checkAvailability(String ... domains) {
        return this.target.path("/domains:checkAvailability").request(new String[]{"application/json"}).rx().post(Entity.entity((Object)new CheckAvailabilityDomain().setDomainNames(Set.of(domains)), (String)"application/json")).thenApply(response -> new ResponseWrapper((Response)response).get(CheckAvailabilityDomainResult.class));
    }

    public CompletionStage<CheckAvailabilityDomainResult> search(String keyword) {
        return this.target.path("/domains:search").request(new String[]{"application/json"}).rx().post(Entity.entity((Object)new SearchDomain().setKeyword(keyword), (String)"application/json")).thenApply(response -> new ResponseWrapper((Response)response).get(CheckAvailabilityDomainResult.class));
    }

    public CompletionStage<Domain> setNameServers(Domain domain) {
        return this.target.path(String.format("/domains/%s:setNameservers", domain.getDomainName())).request(new String[]{"application/json"}).rx().post(Entity.entity((Object)domain, (String)"application/json")).thenApply(response -> new ResponseWrapper((Response)response).get(Domain.class));
    }
}

