/*
 * Decompiled with CFR 0.152.
 */
package xyz.juandiii.name.resources;

import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import xyz.juandiii.name.models.CheckAvailabilityDomain;
import xyz.juandiii.name.models.CheckAvailabilityDomainResult;
import xyz.juandiii.name.models.CreateDomain;
import xyz.juandiii.name.models.Domain;
import xyz.juandiii.name.models.ListDomain;
import xyz.juandiii.name.models.OrderDomain;
import xyz.juandiii.name.models.SearchDomain;
import xyz.juandiii.name.utils.ResponseWrapper;

public class DomainResource {
    private final ResteasyWebTarget resteasyWebTarget;

    public DomainResource(ResteasyWebTarget resteasyWebTarget) {
        this.resteasyWebTarget = resteasyWebTarget;
    }

    public ListDomain getDomains() {
        Response response = this.resteasyWebTarget.path("/domains").request(new String[]{"application/json"}).get();
        return new ResponseWrapper(response).get(ListDomain.class);
    }

    public Domain getDomain(String domain) {
        Response response = this.resteasyWebTarget.path(String.format("/domains/%s", domain)).request(new String[]{"application/json"}).get();
        return new ResponseWrapper(response).get(Domain.class);
    }

    public OrderDomain createDomain(CreateDomain createDomain) {
        Response response = this.resteasyWebTarget.path("/domains").request(new String[]{"application/json"}).post(Entity.entity((Object)createDomain, (String)"application/json"));
        return new ResponseWrapper(response).get(OrderDomain.class);
    }

    public CheckAvailabilityDomainResult checkAvailability(String ... domains) {
        Response response = this.resteasyWebTarget.path("/domains:checkAvailability").request(new String[]{"application/json"}).post(Entity.entity((Object)new CheckAvailabilityDomain().setDomainNames(Set.of(domains)), (String)"application/json"));
        return new ResponseWrapper(response).get(CheckAvailabilityDomainResult.class);
    }

    public CheckAvailabilityDomainResult search(String keyword) {
        Response response = this.resteasyWebTarget.path("/domains:search").request(new String[]{"application/json"}).post(Entity.entity((Object)new SearchDomain().setKeyword(keyword), (String)"application/json"));
        return new ResponseWrapper(response).get(CheckAvailabilityDomainResult.class);
    }
}

