/*
 * Decompiled with CFR 0.152.
 */
package xyz.juandiii.name.utils;

import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import xyz.juandiii.name.exceptions.BadRequestException;
import xyz.juandiii.name.exceptions.InternalErrorException;
import xyz.juandiii.name.exceptions.NotFoundException;
import xyz.juandiii.name.models.ErrorDomain;
import xyz.juandiii.name.utils.JsonBConverter;

public class ResponseWrapper {
    private final Response response;

    public ResponseWrapper(Response response) {
        this.response = response;
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getResponse() {
        String output = (String)this.response.readEntity(String.class);
        if (this.getStatus() >= 200 && 299 >= this.getStatus()) {
            return output;
        }
        if (this.getStatus() == 404) {
            ErrorDomain errorDomain = JsonBConverter.fromJson(output, ErrorDomain.class);
            throw new NotFoundException(errorDomain.getMessage());
        }
        if (this.getStatus() >= 400 && 499 >= this.getStatus()) {
            ErrorDomain errorDomain = JsonBConverter.fromJson(output, ErrorDomain.class);
            throw new BadRequestException(errorDomain.getMessage());
        }
        if (this.getStatus() >= 500 && 599 >= this.getStatus()) {
            ErrorDomain errorDomain = JsonBConverter.fromJson(output, ErrorDomain.class);
            throw new BadRequestException(errorDomain.getMessage());
        }
        throw new InternalErrorException();
    }

    public <T> T get(Class<T> clazz) {
        try {
            String output = this.getResponse();
            return JsonBConverter.fromJson(output, clazz);
        }
        catch (ProcessingException ex) {
            return null;
        }
    }
}

