package chiseltest

object BuildInfo {
  private[this] val buildInfoProperties: java.util.Properties = new java.util.Properties()

  {
    val buildInfoInputStream = getClass
      .getResourceAsStream("BuildInfo.buildinfo.properties")

    if(buildInfoInputStream == null)
      throw new RuntimeException("Could not load resource BuildInfo.buildinfo.properties")
    else try {
      buildInfoProperties.load(buildInfoInputStream)
    } finally {
      buildInfoInputStream.close()
    }
  }

  val chiselVersion = buildInfoProperties.getProperty("chiselVersion")

  val name = buildInfoProperties.getProperty("name")

  val scalaVersion = buildInfoProperties.getProperty("scalaVersion")

  val version = buildInfoProperties.getProperty("version")
}