/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.coverage;

import firrtl2.Flow;
import firrtl2.Kind;
import firrtl2.PortKind$;
import firrtl2.PrimOps;
import firrtl2.RegKind$;
import firrtl2.SourceFlow$;
import firrtl2.UnknownFlow$;
import firrtl2.Utils;
import firrtl2.Utils$;
import firrtl2.annotations.IsModule;
import firrtl2.annotations.ReferenceTarget;
import firrtl2.bitWidth$;
import firrtl2.ir.AsyncResetType$;
import firrtl2.ir.BundleType;
import firrtl2.ir.ClockType$;
import firrtl2.ir.Connect;
import firrtl2.ir.DefRegister;
import firrtl2.ir.DoPrim;
import firrtl2.ir.Expression;
import firrtl2.ir.FirrtlNode;
import firrtl2.ir.Info;
import firrtl2.ir.IntWidth$;
import firrtl2.ir.Module;
import firrtl2.ir.Port;
import firrtl2.ir.PrimOp;
import firrtl2.ir.RefLikeExpression;
import firrtl2.ir.Reference;
import firrtl2.ir.Reference$;
import firrtl2.ir.ResetType$;
import firrtl2.ir.SIntType;
import firrtl2.ir.Statement;
import firrtl2.ir.SubAccess;
import firrtl2.ir.SubField;
import firrtl2.ir.SubIndex;
import firrtl2.ir.Type;
import firrtl2.ir.UIntType;
import firrtl2.ir.Width;
import firrtl2.logger.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class Builder$ {
    public static final Builder$ MODULE$ = new Builder$();

    public RefLikeExpression findClock(Module m) {
        Seq<RefLikeExpression> clocks = this.findClocks(m);
        Predef$.MODULE$.assert(clocks.length() == 1, (Function0 & Serializable)() -> new StringBuilder(73).append("[").append(m.name()).append("] This transformation only works if there is exactly one clock.\n").append("Found: ").append(clocks.map((Function1 & Serializable)x$1 -> ((FirrtlNode)x$1).serialize())).append("\n").toString());
        return (RefLikeExpression)clocks.head();
    }

    public Option<RefLikeExpression> findClock(Module mod, Logger logger) {
        Seq<RefLikeExpression> clocks;
        block1: {
            clocks = this.findClocks(mod);
            if (clocks.isEmpty()) {
                logger.warn((Function0 & Serializable)() -> new StringBuilder(43).append("WARN: [").append(mod.name()).append("] found no clock input, skipping ...").toString());
            }
            if (clocks.length() <= 1) break block1;
            logger.warn((Function0 & Serializable)() -> new StringBuilder(59).append("WARN: [").append(mod.name()).append("] found more than one clock, picking the first one: ").append(((IterableOnceOps)clocks.map((Function1 & Serializable)x$2 -> ((FirrtlNode)x$2).serialize())).mkString(", ")).toString());
        }
        return clocks.headOption();
    }

    public Seq<RefLikeExpression> findClocks(Module m) {
        boolean isAsyncQueue;
        Seq<RefLikeExpression> ports = this.flattenedPorts((Seq<Port>)m.ports());
        Seq clockIO = (Seq)ports.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Builder$.$anonfun$findClocks$1(x$3)));
        Seq clockInputs = (Seq)clockIO.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Builder$.$anonfun$findClocks$2(x$4)));
        String string = m.name();
        String string2 = "AsyncQueue";
        boolean bl = !(string == null ? string2 != null : !string.equals(string2)) || m.name().startsWith("AsyncQueue_") ? true : (isAsyncQueue = false);
        if (isAsyncQueue) {
            return (Seq)clockInputs.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Builder$.$anonfun$findClocks$3(x$5)));
        }
        return clockInputs;
    }

    public ReferenceTarget refToTarget(IsModule module, RefLikeExpression ref) {
        RefLikeExpression refLikeExpression = ref;
        if (refLikeExpression instanceof Reference) {
            Reference reference = (Reference)refLikeExpression;
            String name = reference.name();
            return module.ref(name);
        }
        if (refLikeExpression instanceof SubField) {
            SubField subField = (SubField)refLikeExpression;
            Expression expr = subField.expr();
            String name = subField.name();
            return this.refToTarget(module, (RefLikeExpression)expr).field(name);
        }
        if (refLikeExpression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)refLikeExpression;
            Expression expr = subIndex.expr();
            int value = subIndex.value();
            return this.refToTarget(module, (RefLikeExpression)expr).index(value);
        }
        throw new RuntimeException(new StringBuilder(34).append("Unsupported reference expression: ").append(refLikeExpression).toString());
    }

    private Seq<RefLikeExpression> flattenedPorts(Seq<Port> ports) {
        return (Seq)ports.flatMap((Function1 & Serializable)p -> MODULE$.expandRef((RefLikeExpression)new Reference(p.name(), p.tpe(), (Kind)PortKind$.MODULE$, Utils$.MODULE$.to_flow(p.direction()))));
    }

    private Seq<RefLikeExpression> expandRef(RefLikeExpression ref) {
        Type type = ((Expression)ref).tpe();
        if (type instanceof BundleType) {
            BundleType bundleType = (BundleType)type;
            Seq fields = bundleType.fields();
            return (Seq)new .colon.colon((Object)ref, (List)Nil$.MODULE$).$plus$plus((IterableOnce)fields.flatMap((Function1 & Serializable)f -> MODULE$.expandRef((RefLikeExpression)new SubField((Expression)ref, f.name(), f.tpe(), Utils$.MODULE$.times(f.flip(), ref.flow())))));
        }
        return new .colon.colon((Object)ref, (List)Nil$.MODULE$);
    }

    public Seq<RefLikeExpression> findResets(Module m) {
        Seq<RefLikeExpression> ports = this.flattenedPorts((Seq<Port>)m.ports());
        Seq inputs = (Seq)ports.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Builder$.$anonfun$findResets$1(x$6)));
        Seq ofResetType = (Seq)inputs.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Builder$.$anonfun$findResets$2(p)));
        Seq boolWithCorrectName = (Seq)inputs.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Builder$.$anonfun$findResets$3(p)));
        Seq resetInputs = (Seq)ofResetType.$plus$plus((IterableOnce)boolWithCorrectName);
        return resetInputs;
    }

    public Expression reduceAnd(Expression e) {
        return new DoPrim((PrimOp)PrimOps.Andr$.MODULE$, (Seq)new .colon.colon((Object)e, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$, (Type)Utils$.MODULE$.BoolType());
    }

    public Expression add(Expression a, Expression b) {
        Tuple2 tuple2 = new Tuple2((Object)this.getWidth(a.tpe()), (Object)this.getWidth(b.tpe()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInt aWidth = (BigInt)tuple2._1();
        BigInt bWidth = (BigInt)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)aWidth, (Object)bWidth);
        BigInt aWidth2 = (BigInt)tuple22._1();
        BigInt bWidth2 = (BigInt)tuple22._2();
        BigInt resultWidth = (BigInt)new .colon.colon((Object)aWidth2, (List)new .colon.colon((Object)bWidth2, (List)Nil$.MODULE$)).max((Ordering)Ordering.BigInt$.MODULE$);
        Tuple2 tuple23 = new Tuple2((Object)this.pad(a, resultWidth), (Object)this.pad(b, resultWidth));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Expression aPad = (Expression)tuple23._1();
        Expression bPad = (Expression)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)aPad, (Object)bPad);
        Expression aPad2 = (Expression)tuple24._1();
        Expression bPad2 = (Expression)tuple24._2();
        DoPrim res = new DoPrim((PrimOp)PrimOps.Add$.MODULE$, (Seq)new .colon.colon((Object)aPad2, (List)new .colon.colon((Object)bPad2, (List)Nil$.MODULE$)), (Seq)Nil$.MODULE$, this.withWidth(a.tpe(), resultWidth.$plus(BigInt$.MODULE$.int2bigInt(1))));
        return new DoPrim((PrimOp)PrimOps.Bits$.MODULE$, (Seq)new .colon.colon((Object)res, (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)resultWidth.$minus(BigInt$.MODULE$.int2bigInt(1)), (List)new .colon.colon((Object)BigInt$.MODULE$.int2bigInt(0), (List)Nil$.MODULE$)), this.withWidth(a.tpe(), resultWidth));
    }

    public Expression pad(Expression e, BigInt to) {
        BigInt from = this.getWidth(e.tpe());
        Predef$.MODULE$.require(to.$greater$eq((Object)from));
        BigInt bigInt = to;
        BigInt bigInt2 = from;
        if (!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null)) {
            return e;
        }
        return new DoPrim((PrimOp)PrimOps.Pad$.MODULE$, (Seq)new .colon.colon((Object)e, (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)to, (List)Nil$.MODULE$), this.withWidth(e.tpe(), to));
    }

    public Type withWidth(Type tpe, BigInt width) {
        Type type = tpe;
        if (type instanceof UIntType) {
            return new UIntType((Width)IntWidth$.MODULE$.apply(width));
        }
        if (type instanceof SIntType) {
            return new SIntType((Width)IntWidth$.MODULE$.apply(width));
        }
        throw new RuntimeException(new StringBuilder(28).append("Cannot change the width of ").append(type).append("!").toString());
    }

    public BigInt getWidth(Type tpe) {
        return bitWidth$.MODULE$.apply(tpe);
    }

    public Reference makeRegister(ListBuffer<Statement> stmts, Info info, String name, Type tpe, Expression clock, Expression next, Expression reset, Option<Expression> init) {
        if (this.isAsyncReset(reset)) {
            Expression initExpr = (Expression)init.getOrElse((Function0 & Serializable)() -> new Reference(name, tpe, (Kind)RegKind$.MODULE$, Reference$.MODULE$.apply$default$4()));
            DefRegister reg = new DefRegister(info, name, tpe, clock, reset, initExpr);
            stmts.append((Object)reg);
            stmts.append((Object)new Connect(info, (Expression)Reference$.MODULE$.apply(reg), next));
            return Reference$.MODULE$.apply(reg);
        }
        Reference ref = new Reference(name, tpe, (Kind)RegKind$.MODULE$, (Flow)UnknownFlow$.MODULE$);
        stmts.append((Object)new DefRegister(info, name, tpe, clock, (Expression)Utils.False$.MODULE$.apply(), (Expression)ref));
        Option<Expression> option = init;
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression value = (Expression)some.value();
            ListBuffer cfr_ignored_0 = (ListBuffer)stmts.append((Object)new Connect(info, (Expression)ref, Utils$.MODULE$.mux(reset, value, next)));
        } else if (None$.MODULE$.equals(option)) {
            ListBuffer cfr_ignored_1 = (ListBuffer)stmts.append((Object)new Connect(info, (Expression)ref, next));
        } else {
            throw new MatchError(option);
        }
        return ref;
    }

    public Expression makeRegister$default$7() {
        return Utils.False$.MODULE$.apply();
    }

    public Option<Expression> makeRegister$default$8() {
        return None$.MODULE$;
    }

    public boolean isAsyncReset(Expression reset) {
        Type type = reset.tpe();
        return AsyncResetType$.MODULE$.equals(type);
    }

    public Kind getKind(RefLikeExpression ref) {
        RefLikeExpression refLikeExpression;
        while (true) {
            if ((refLikeExpression = ref) instanceof Reference) {
                Reference reference = (Reference)refLikeExpression;
                Kind kind = reference.kind();
                return kind;
            }
            if (refLikeExpression instanceof SubField) {
                SubField subField = (SubField)refLikeExpression;
                Expression expr = subField.expr();
                ref = (RefLikeExpression)expr;
                continue;
            }
            if (refLikeExpression instanceof SubIndex) {
                SubIndex subIndex = (SubIndex)refLikeExpression;
                Expression expr = subIndex.expr();
                ref = (RefLikeExpression)expr;
                continue;
            }
            if (!(refLikeExpression instanceof SubAccess)) break;
            SubAccess subAccess = (SubAccess)refLikeExpression;
            Expression expr = subAccess.expr();
            ref = (RefLikeExpression)expr;
        }
        throw new MatchError((Object)refLikeExpression);
    }

    public static final /* synthetic */ boolean $anonfun$findClocks$1(RefLikeExpression x$3) {
        Type type = ((Expression)x$3).tpe();
        ClockType$ clockType$ = ClockType$.MODULE$;
        return !(type != null ? !type.equals(clockType$) : clockType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$findClocks$2(RefLikeExpression x$4) {
        Flow flow = x$4.flow();
        SourceFlow$ sourceFlow$ = SourceFlow$.MODULE$;
        return !(flow != null ? !flow.equals(sourceFlow$) : sourceFlow$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$findClocks$3(RefLikeExpression x$5) {
        String string = ((FirrtlNode)x$5).serialize();
        String string2 = "clock";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findResets$1(RefLikeExpression x$6) {
        Flow flow = x$6.flow();
        SourceFlow$ sourceFlow$ = SourceFlow$.MODULE$;
        return !(flow != null ? !flow.equals(sourceFlow$) : sourceFlow$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findResets$2(RefLikeExpression p) {
        Type type = ((Expression)p).tpe();
        AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
        if (type == null) {
            if (asyncResetType$ == null) return true;
        } else if (type.equals(asyncResetType$)) return true;
        Type type2 = ((Expression)p).tpe();
        ResetType$ resetType$ = ResetType$.MODULE$;
        if (type2 != null) {
            if (!type2.equals(resetType$)) return false;
            return true;
        }
        if (resetType$ == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$findResets$3(RefLikeExpression p) {
        Type type = ((Expression)p).tpe();
        UIntType uIntType = new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1)));
        return !(type != null ? !type.equals(uIntType) : uIntType != null) && ((FirrtlNode)p).serialize().endsWith("reset");
    }

    private Builder$() {
    }
}

