/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.formal.backends.smt;

import chiseltest.formal.backends.smt.ArrayValue;
import chiseltest.formal.backends.smt.SMTEvalCtx;
import firrtl2.backends.experimental.smt.ArrayConstant;
import firrtl2.backends.experimental.smt.ArrayEqual;
import firrtl2.backends.experimental.smt.ArrayExpr;
import firrtl2.backends.experimental.smt.ArrayIte;
import firrtl2.backends.experimental.smt.ArrayRead;
import firrtl2.backends.experimental.smt.ArrayStore;
import firrtl2.backends.experimental.smt.ArraySymbol;
import firrtl2.backends.experimental.smt.BVAnd;
import firrtl2.backends.experimental.smt.BVComparison;
import firrtl2.backends.experimental.smt.BVConcat;
import firrtl2.backends.experimental.smt.BVEqual;
import firrtl2.backends.experimental.smt.BVExpr;
import firrtl2.backends.experimental.smt.BVExtend;
import firrtl2.backends.experimental.smt.BVForall;
import firrtl2.backends.experimental.smt.BVFunctionCall;
import firrtl2.backends.experimental.smt.BVImplies;
import firrtl2.backends.experimental.smt.BVImplies$;
import firrtl2.backends.experimental.smt.BVIte;
import firrtl2.backends.experimental.smt.BVLiteral;
import firrtl2.backends.experimental.smt.BVNegate;
import firrtl2.backends.experimental.smt.BVNot;
import firrtl2.backends.experimental.smt.BVOp;
import firrtl2.backends.experimental.smt.BVOr;
import firrtl2.backends.experimental.smt.BVReduceAnd;
import firrtl2.backends.experimental.smt.BVReduceOr;
import firrtl2.backends.experimental.smt.BVReduceXor;
import firrtl2.backends.experimental.smt.BVSlice;
import firrtl2.backends.experimental.smt.BVSymbol;
import firrtl2.backends.experimental.smt.Compare$;
import firrtl2.backends.experimental.smt.Op$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SMTExprEval$ {
    public static final SMTExprEval$ MODULE$ = new SMTExprEval$();

    public BigInt eval(BVExpr expr, SMTEvalCtx ctx) {
        BVImplies bVImplies;
        Some some;
        BigInt bigInt;
        BVExpr bVExpr = expr;
        if (bVExpr instanceof BVLiteral) {
            BigInt value2;
            BVLiteral bVLiteral = (BVLiteral)bVExpr;
            bigInt = value2 = bVLiteral.value();
        } else if (bVExpr instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)bVExpr;
            String name = bVSymbol.name();
            bigInt = ctx.getBVSymbol(name);
        } else if (bVExpr instanceof BVExtend) {
            BVExtend bVExtend = (BVExtend)bVExpr;
            BVExpr e = bVExtend.e();
            int by = bVExtend.by();
            boolean signed = bVExtend.signed();
            bigInt = this.doBVExtend(this.eval(e, ctx), e.width(), by, signed);
        } else if (bVExpr instanceof BVSlice) {
            BVSlice bVSlice = (BVSlice)bVExpr;
            BVExpr e = bVSlice.e();
            int hi = bVSlice.hi();
            int lo = bVSlice.lo();
            bigInt = this.doBVSlice(this.eval(e, ctx), hi, lo);
        } else if (bVExpr instanceof BVNot) {
            BVNot bVNot = (BVNot)bVExpr;
            BVExpr e = bVNot.e();
            bigInt = this.doBVNot(this.eval(e, ctx), e.width());
        } else if (bVExpr instanceof BVNegate) {
            BVNegate bVNegate = (BVNegate)bVExpr;
            BVExpr e = bVNegate.e();
            bigInt = this.doBVNegate(this.eval(e, ctx), e.width());
        } else if (bVExpr instanceof BVImplies && !(some = BVImplies$.MODULE$.unapply(bVImplies = (BVImplies)bVExpr)).isEmpty()) {
            BVExpr a = (BVExpr)((Tuple2)some.get())._1();
            BVExpr b = (BVExpr)((Tuple2)some.get())._2();
            bigInt = this.doBVNot(this.eval(a, ctx), 1).$bar(this.eval(b, ctx));
        } else if (bVExpr instanceof BVEqual) {
            BVEqual bVEqual = (BVEqual)bVExpr;
            BVExpr a = bVEqual.a();
            BVExpr b = bVEqual.b();
            bigInt = this.doBVEqual(this.eval(a, ctx), this.eval(b, ctx));
        } else if (bVExpr instanceof BVComparison) {
            BVComparison bVComparison = (BVComparison)bVExpr;
            Enumeration.Value op = bVComparison.op();
            BVExpr a = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean signed = bVComparison.signed();
            bigInt = this.doBVCompare(op, this.eval(a, ctx), this.eval(b, ctx), a.width(), signed);
        } else if (bVExpr instanceof BVOp) {
            BVOp bVOp = (BVOp)bVExpr;
            Enumeration.Value op = bVOp.op();
            BVExpr a = bVOp.a();
            BVExpr b = bVOp.b();
            bigInt = this.doBVOp(op, this.eval(a, ctx), this.eval(b, ctx), a.width());
        } else if (bVExpr instanceof BVConcat) {
            BVConcat bVConcat = (BVConcat)bVExpr;
            BVExpr a = bVConcat.a();
            BVExpr b = bVConcat.b();
            bigInt = this.doBVConcat(this.eval(a, ctx), this.eval(b, ctx), b.width());
        } else if (bVExpr instanceof ArrayRead) {
            ArrayRead arrayRead = (ArrayRead)bVExpr;
            ArrayExpr array = arrayRead.array();
            BVExpr index = arrayRead.index();
            bigInt = this.evalArray(array, ctx).read(this.eval(index, ctx));
        } else if (bVExpr instanceof BVIte) {
            BVIte bVIte = (BVIte)bVExpr;
            BVExpr cond = bVIte.cond();
            BVExpr tru = bVIte.tru();
            BVExpr fals = bVIte.fals();
            BigInt c = this.eval(cond, ctx);
            Predef$.MODULE$.assert(BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)0)) || BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)1)));
            bigInt = BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)1)) ? this.eval(tru, ctx) : this.eval(fals, ctx);
        } else if (bVExpr instanceof ArrayEqual) {
            ArrayEqual arrayEqual = (ArrayEqual)bVExpr;
            ArrayExpr a = arrayEqual.a();
            ArrayExpr b = arrayEqual.b();
            bigInt = this.evalArray(a, ctx).$eq$eq(this.evalArray(b, ctx)) ? package$.MODULE$.BigInt().apply(1) : package$.MODULE$.BigInt().apply(0);
        } else if (bVExpr instanceof BVReduceOr) {
            BVReduceOr bVReduceOr = (BVReduceOr)bVExpr;
            BVExpr e = bVReduceOr.e();
            bigInt = this.bool(!BoxesRunTime.equalsNumObject((Number)this.eval(e, ctx), (Object)BoxesRunTime.boxToInteger((int)0)));
        } else if (bVExpr instanceof BVReduceAnd) {
            BVReduceAnd bVReduceAnd = (BVReduceAnd)bVExpr;
            BVExpr e = bVReduceAnd.e();
            BigInt mask = package$.MODULE$.BigInt().apply(1).$less$less(e.width()).$minus(BigInt$.MODULE$.int2bigInt(1));
            BigInt bigInt2 = this.eval(e, ctx);
            BigInt bigInt3 = mask;
            bigInt = this.bool(!(bigInt2 != null ? !bigInt2.equals(bigInt3) : bigInt3 != null));
        } else if (bVExpr instanceof BVReduceXor) {
            BVReduceXor bVReduceXor = (BVReduceXor)bVExpr;
            BVExpr e = bVReduceXor.e();
            BigInt r = this.eval(e, ctx);
            Predef$.MODULE$.assert(r.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)), (Function0 & Serializable)() -> "bit vectors should always be positive!");
            bigInt = this.bool(r.bitCount() % 2 == 1);
        } else if (bVExpr instanceof BVAnd) {
            BVAnd bVAnd = (BVAnd)bVExpr;
            List terms = bVAnd.terms();
            bigInt = this.bool(terms.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SMTExprEval$.$anonfun$eval$2(ctx, x$1))));
        } else if (bVExpr instanceof BVOr) {
            BVOr bVOr = (BVOr)bVExpr;
            List terms = bVOr.terms();
            bigInt = this.bool(terms.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SMTExprEval$.$anonfun$eval$3(ctx, x$2))));
        } else if (bVExpr instanceof BVForall) {
            BVForall bVForall = (BVForall)bVExpr;
            BVSymbol variable = bVForall.variable();
            BVExpr e = bVForall.e();
            BigInt maxValue = package$.MODULE$.BigInt().apply(1).$less$less(variable.width()).$minus(BigInt$.MODULE$.int2bigInt(1));
            if (maxValue.$greater((Object)BigInt$.MODULE$.int2bigInt(4096))) {
                throw new NotImplementedError(new StringBuilder(72).append("TODO: deal with forall of large ranges in witness simulator: ").append(variable).append(" has ").append(variable.width()).append(" bits!").toString());
            }
            boolean res = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), maxValue.toInt()).iterator().forall((Function1)(JFunction1.mcZI.sp & Serializable)value -> {
                ctx.startVariableScope(variable.name(), BigInt$.MODULE$.int2bigInt(value));
                boolean isTrue = BoxesRunTime.equalsNumObject((Number)MODULE$.eval(e, ctx), (Object)BoxesRunTime.boxToInteger((int)1));
                ctx.endVariableScope(variable.name());
                return isTrue;
            });
            bigInt = res ? package$.MODULE$.BigInt().apply(1) : package$.MODULE$.BigInt().apply(0);
        } else {
            if (bVExpr instanceof BVFunctionCall) {
                throw new NotImplementedError("function call");
            }
            throw new MatchError((Object)bVExpr);
        }
        BigInt value3 = bigInt;
        return value3;
    }

    public ArrayValue evalArray(ArrayExpr expr, SMTEvalCtx ctx) {
        ArrayExpr arrayExpr;
        while (true) {
            if ((arrayExpr = expr) instanceof ArraySymbol) {
                ArraySymbol arraySymbol = (ArraySymbol)arrayExpr;
                return ctx.getArraySymbol(arraySymbol.name());
            }
            if (arrayExpr instanceof ArrayConstant) {
                ArrayConstant arrayConstant = (ArrayConstant)arrayExpr;
                BVExpr e = arrayConstant.e();
                int indexWidth = arrayConstant.indexWidth();
                return ctx.constArray(indexWidth, this.eval(e, ctx));
            }
            if (arrayExpr instanceof ArrayStore) {
                ArrayStore arrayStore = (ArrayStore)arrayExpr;
                ArrayExpr array = arrayStore.array();
                BVExpr index = arrayStore.index();
                BVExpr data = arrayStore.data();
                return this.evalArray(array, ctx).write((Option<BigInt>)new Some((Object)this.eval(index, ctx)), this.eval(data, ctx));
            }
            if (!(arrayExpr instanceof ArrayIte)) break;
            ArrayIte arrayIte = (ArrayIte)arrayExpr;
            BVExpr cond = arrayIte.cond();
            ArrayExpr tru = arrayIte.tru();
            ArrayExpr fals = arrayIte.fals();
            BigInt c = this.eval(cond, ctx);
            Predef$.MODULE$.assert(BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)0)) || BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)1)));
            if (BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)1))) {
                expr = tru;
                continue;
            }
            expr = fals;
        }
        throw new RuntimeException(new StringBuilder(29).append("Unsupported array expression ").append(arrayExpr).toString());
    }

    private BigInt doBVExtend(BigInt e, int width, int by, boolean signed) {
        if (signed && this.isNegative(e, width)) {
            return this.mask(by).$less$less(width).$bar(e);
        }
        return e;
    }

    private BigInt doBVSlice(BigInt e, int hi, int lo) {
        return e.$greater$greater(lo).$amp(this.mask(hi - lo + 1));
    }

    private BigInt doBVNot(BigInt e, int width) {
        return this.flipBits(e, width);
    }

    private BigInt doBVNegate(BigInt e, int width) {
        return this.sub(BigInt$.MODULE$.int2bigInt(0), e, width);
    }

    private BigInt doBVEqual(BigInt a, BigInt b) {
        BigInt bigInt = a;
        BigInt bigInt2 = b;
        return this.bool(!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null));
    }

    private BigInt doBVCompare(Enumeration.Value op, BigInt a, BigInt b, int width, boolean signed) {
        block9: {
            Tuple2.mcZZ.sp sp2;
            while (true) {
                BigInt bigInt = a;
                BigInt bigInt2 = b;
                if (!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null)) {
                    Enumeration.Value value = op;
                    Enumeration.Value value2 = Compare$.MODULE$.GreaterEqual();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        return this.bool(true);
                    }
                }
                if (!signed) break block9;
                sp2 = new Tuple2.mcZZ.sp(this.isPositive(a, width), this.isPositive(b, width));
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl2 = sp2._2$mcZ$sp();
                    if (bl && bl2) {
                        signed = false;
                        --width;
                        continue;
                    }
                }
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (bl && !bl3) {
                        return this.bool(false);
                    }
                }
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl4 = sp2._2$mcZ$sp();
                    if (!bl && bl4) {
                        return this.bool(true);
                    }
                }
                if (sp2 == null) break;
                boolean bl = sp2._1$mcZ$sp();
                boolean bl5 = sp2._2$mcZ$sp();
                if (bl || bl5) break;
                BigInt bigInt3 = this.doBVNegate(b, width);
                BigInt bigInt4 = this.doBVNegate(a, width);
                signed = false;
                --width;
                b = bigInt4;
                a = bigInt3;
            }
            throw new MatchError((Object)sp2);
        }
        return this.bool(a.$greater((Object)b));
    }

    private BigInt doBVOp(Enumeration.Value op, BigInt a, BigInt b, int width) {
        Enumeration.Value value = op;
        Enumeration.Value value2 = Op$.MODULE$.Xor();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return a.$up(b);
        }
        Enumeration.Value value4 = Op$.MODULE$.ShiftLeft();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return a.$less$less(b.toInt()).$amp(this.mask(width));
        }
        Enumeration.Value value6 = Op$.MODULE$.ArithmeticShiftRight();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            int by = b.toInt();
            if (this.isPositive(a, width)) {
                return a.$greater$greater(by);
            }
            if (by >= width) {
                return this.mask(width);
            }
            BigInt msb = this.mask(by).$less$less(width - by);
            return a.$greater$greater(by).$bar(msb);
        }
        Enumeration.Value value8 = Op$.MODULE$.ShiftRight();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return a.$greater$greater(b.toInt());
        }
        Enumeration.Value value10 = Op$.MODULE$.Add();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return a.$plus(b).$amp(this.mask(width));
        }
        Enumeration.Value value12 = Op$.MODULE$.Mul();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return a.$times(b).$amp(this.mask(width));
        }
        Enumeration.Value value14 = Op$.MODULE$.Sub();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            return this.sub(a, b, width);
        }
        Enumeration.Value value16 = Op$.MODULE$.UnsignedDiv();
        Enumeration.Value value17 = value;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            if (BoxesRunTime.equalsNumObject((Number)b, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return this.mask(width);
            }
            return a.$div(b).$amp(this.mask(width));
        }
        Enumeration.Value value18 = Op$.MODULE$.UnsignedRem();
        Enumeration.Value value19 = value;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            if (BoxesRunTime.equalsNumObject((Number)b, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return a;
            }
            return a.$percent(b).$amp(this.mask(width));
        }
        Enumeration.Value value20 = Op$.MODULE$.SignedDiv();
        Enumeration.Value value21 = value;
        if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
            if (BoxesRunTime.equalsNumObject((Number)b, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return this.mask(width);
            }
            BigInt aValue = this.bigIntValue(a, width);
            BigInt bValue = this.bigIntValue(b, width);
            return this.bvSignedValue(aValue.$div(bValue), width);
        }
        Enumeration.Value value22 = Op$.MODULE$.SignedRem();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            if (BoxesRunTime.equalsNumObject((Number)b, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return a;
            }
            BigInt aValue = this.bigIntValue(a, width);
            BigInt bValue = this.bigIntValue(b, width);
            return this.bvSignedValue(aValue.$percent(bValue), width);
        }
        Enumeration.Value value24 = Op$.MODULE$.SignedMod();
        Enumeration.Value value25 = value;
        if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
            if (BoxesRunTime.equalsNumObject((Number)b, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return a;
            }
            BigInt aValue = this.bigIntValue(a, width);
            BigInt bValue = this.bigIntValue(b, width);
            BigInt remValue = aValue.$percent(bValue);
            if (this.isPositive(a, width) == this.isPositive(b, width) || BoxesRunTime.equalsNumObject((Number)remValue, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return this.bvSignedValue(remValue, width);
            }
            return this.bvSignedValue(remValue.$plus(bValue), width);
        }
        throw new NotImplementedError(value.toString());
    }

    private BigInt doBVConcat(BigInt a, BigInt b, int bWidth) {
        return a.$less$less(bWidth).$bar(b);
    }

    private BigInt sub(BigInt a, BigInt b, int width) {
        return a.$plus(this.flipBits(b, width)).$plus(BigInt$.MODULE$.int2bigInt(1)).$amp(this.mask(width));
    }

    private BigInt mask(int width) {
        return package$.MODULE$.BigInt().apply(1).$less$less(width).$minus(BigInt$.MODULE$.int2bigInt(1));
    }

    private boolean isPositive(BigInt value, int w) {
        BigInt bigInt = value.$amp(this.mask(w - 1));
        BigInt bigInt2 = value;
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
    }

    private boolean isNegative(BigInt value, int w) {
        return !this.isPositive(value, w);
    }

    private BigInt flipBits(BigInt value, int w) {
        return value.unary_$tilde().$amp(this.mask(w));
    }

    private BigInt bool(boolean b) {
        if (b) {
            return package$.MODULE$.BigInt().apply(1);
        }
        return package$.MODULE$.BigInt().apply(0);
    }

    private BigInt abs(BigInt value, int w) {
        if (this.isPositive(value, w)) {
            return value;
        }
        return this.flipBits(value.$amp(this.mask(w - 1)), w - 1).$plus(BigInt$.MODULE$.int2bigInt(1));
    }

    private BigInt bigIntValue(BigInt value, int w) {
        if (this.isPositive(value, w)) {
            return value;
        }
        return this.abs(value, w).unary_$minus();
    }

    private BigInt bvSignedValue(BigInt value, int w) {
        if (value.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return value.$amp(this.mask(w));
        }
        return package$.MODULE$.BigInt().apply(1).$less$less(w - 1).$bar(this.flipBits(value.unary_$minus().$amp(this.mask(w - 1)), w - 1).$plus(BigInt$.MODULE$.int2bigInt(1)));
    }

    public static final /* synthetic */ boolean $anonfun$eval$2(SMTEvalCtx ctx$1, BVExpr x$1) {
        return !BoxesRunTime.equalsNumObject((Number)MODULE$.eval(x$1, ctx$1), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$eval$3(SMTEvalCtx ctx$1, BVExpr x$2) {
        return !BoxesRunTime.equalsNumObject((Number)MODULE$.eval(x$2, ctx$1), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    private SMTExprEval$() {
    }
}

