/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.internal;

import chisel3.Module;
import chisel3.internal.plugin.package$;
import chisel3.testers.BasicTester;
import chiseltest.ChiselAssertionError;
import chiseltest.StopException;
import chiseltest.TimeoutException;
import chiseltest.internal.TesterUtils$;
import chiseltest.simulator.SimulatorContext;
import chiseltest.simulator.StepInterrupted;
import chiseltest.simulator.StepOk$;
import chiseltest.simulator.StepResult;
import firrtl.AnnotationSeq;
import firrtl2.CircuitState;
import firrtl2.annotations.Annotation;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt$;

public final class HardwareTesterBackend$ {
    public static final HardwareTesterBackend$ MODULE$ = new HardwareTesterBackend$();
    private static final int StepSize = 1000;
    private static volatile boolean bitmap$init$0 = true;

    public <T extends Module> Seq<Annotation> run(Function0<T> dutGen, Seq<Annotation> annos, int timeout, boolean expectFail, AnnotationSeq chiselAnnos) {
        Predef$.MODULE$.require(timeout >= 0, (Function0 & Serializable)() -> new StringBuilder(65).append("Negative timeout ").append(timeout).append(" is not supported! Use 0 to disable the timeout.").toString());
        Tuple4<SimulatorContext, Seq<Annotation>, T, CircuitState> tuple4 = TesterUtils$.MODULE$.createTester(this.addFinishToBasicTester(dutGen), TesterUtils$.MODULE$.addDefaultSimulator(annos), chiselAnnos);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        SimulatorContext tester = (SimulatorContext)tuple4._1();
        Seq covAnnos = (Seq)tuple4._2();
        Tuple2 tuple2 = new Tuple2((Object)tester, (Object)covAnnos);
        SimulatorContext tester2 = (SimulatorContext)tuple2._1();
        Seq covAnnos2 = (Seq)tuple2._2();
        tester2.poke("reset", BigInt$.MODULE$.int2bigInt(1));
        tester2.step(1);
        tester2.poke("reset", BigInt$.MODULE$.int2bigInt(0));
        if (timeout > 0) {
            this.runWithTimeout(tester2, timeout, expectFail);
        } else {
            this.runWithoutTimeout(tester2, expectFail);
        }
        return TesterUtils$.MODULE$.finish(tester2, (Seq<Annotation>)covAnnos2);
    }

    public <T extends Module> AnnotationSeq run$default$5() {
        return firrtl.package$.MODULE$.seqToAnnoSeq((Seq)Nil$.MODULE$);
    }

    private int StepSize() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: HardwareTesterBackend.scala: 43");
        }
        return StepSize;
    }

    private void runWithoutTimeout(SimulatorContext tester, boolean expectFail) {
        boolean done = false;
        while (!done) {
            StepResult stepResult = tester.step(this.StepSize());
            if (StepOk$.MODULE$.equals(stepResult)) {
                continue;
            }
            if (stepResult instanceof StepInterrupted) {
                StepInterrupted stepInterrupted = (StepInterrupted)stepResult;
                done = true;
                this.checkInterrupted(tester, stepInterrupted, expectFail);
                continue;
            }
            throw new MatchError((Object)stepResult);
        }
    }

    private void runWithTimeout(SimulatorContext tester, int timeout, boolean expectFail) {
        Predef$.MODULE$.require(timeout > 0);
        String kind = expectFail ? "assertion failure" : "stop";
        StepResult stepResult = tester.step(timeout);
        if (StepOk$.MODULE$.equals(stepResult)) {
            tester.finish();
            throw new TimeoutException(new StringBuilder(40).append("Expected a ").append(kind).append(" but timed out after ").append(timeout).append(" cycles.").toString());
        }
        if (stepResult instanceof StepInterrupted) {
            StepInterrupted stepInterrupted = (StepInterrupted)stepResult;
            this.checkInterrupted(tester, stepInterrupted, expectFail);
            return;
        }
        throw new MatchError((Object)stepResult);
    }

    private void checkInterrupted(SimulatorContext tester, StepInterrupted i, boolean expectFail) {
        if (i.isFailure() != expectFail) {
            tester.finish();
            if (expectFail) {
                throw new StopException(new StringBuilder(76).append("Expected an assertion failure, but encountered a stop instead ").append("after ").append(i.after()).append(" cycles.").toString(), i.after());
            }
            throw new ChiselAssertionError(new StringBuilder(43).append("Unexpected assertion failure after ").append(i.after()).append(" cycles.").toString(), i.after());
        }
    }

    private <T extends Module> Function0<T> addFinishToBasicTester(Function0<T> dutGen) {
        return (Function0 & Serializable)() -> {
            Module tester;
            block0: {
                tester = (Module)package$.MODULE$.autoNameRecursively("tester", dutGen);
                Module module = tester;
                if (!(module instanceof BasicTester)) break block0;
                BasicTester basicTester = (BasicTester)module;
                basicTester.finish();
            }
            return tester;
        };
    }

    private HardwareTesterBackend$() {
    }
}

