/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.simulator;

import chiseltest.internal.CachingAnnotation$;
import chiseltest.simulator.CachingDebugAnnotation$;
import chiseltest.simulator.Compiler$;
import chiseltest.simulator.SimulatorContext;
import firrtl2.BuildInfo$;
import firrtl2.CircuitState;
import firrtl2.annotations.Annotation;
import firrtl2.annotations.JsonProtocol$;
import firrtl2.ir.Circuit;
import firrtl2.ir.StructuralHash$;
import geny.Writable$;
import java.io.Serializable;
import java.security.MessageDigest;
import os.Path;
import os.PathChunk;
import os.ReadablePath;
import os.RelPath$;
import os.Source;
import os.Source$;
import os.read$;
import os.write;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;
import scala.util.Try$;

public final class Caching$ {
    public static final Caching$ MODULE$ = new Caching$();
    private static final String VersionNumber = "1";
    private static volatile boolean bitmap$init$0 = true;

    private String VersionNumber() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: Caching.scala: 20");
        }
        return VersionNumber;
    }

    public SimulatorContext cacheSimulationBin(String simName, CircuitState state, Function1<CircuitState, SimulatorContext> makeBin, Function1<CircuitState, SimulatorContext> reuseBin) {
        if (!this.shouldCache(state)) {
            return (SimulatorContext)makeBin.apply((Object)state);
        }
        boolean debug = state.annotations().contains((Object)CachingDebugAnnotation$.MODULE$);
        Path targetDir = Compiler$.MODULE$.requireTargetDir((Seq<Annotation>)state.annotations());
        String newHash = this.hashAll(simName, state);
        Option<String> oldHash = this.loadHash(targetDir);
        if (debug) {
            Predef$.MODULE$.println((Object)new StringBuilder(62).append("targetDir: ").append(targetDir).append("; oldHash: ").append(oldHash).append("; newHash: ").append(newHash).append("; oldHash.contains(newHash): ").append(oldHash.contains((Object)newHash)).toString());
        }
        if (oldHash.contains((Object)newHash)) {
            if (debug) {
                Predef$.MODULE$.println((Object)new StringBuilder(32).append("Re-using compiled simulation in ").append(targetDir).toString());
            }
            return (SimulatorContext)reuseBin.apply((Object)state);
        }
        SimulatorContext ctx = (SimulatorContext)makeBin.apply((Object)state);
        this.saveHash(targetDir, newHash);
        return ctx;
    }

    public boolean shouldCache(CircuitState state) {
        return state.annotations().contains((Object)CachingAnnotation$.MODULE$);
    }

    private void saveHash(Path targetDir, String value) {
        write.over$.MODULE$.apply(targetDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"caching.hash"})))), (Source)Source$.MODULE$.WritableSource((Object)new StringBuilder(1).append(value).append("\n").toString(), (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write.over$.MODULE$.apply$default$3(), write.over$.MODULE$.apply$default$4(), write.over$.MODULE$.apply$default$5(), write.over$.MODULE$.apply$default$6());
    }

    private Option<String> loadHash(Path targetDir) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> read$.MODULE$.apply((ReadablePath)targetDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"caching.hash"})))))).toOption().map((Function1 & Serializable)x$1 -> x$1.trim());
    }

    private String hashAll(String simName, CircuitState state) {
        Seq values = (Seq)((IterableOps)new .colon.colon((Object)this.VersionNumber(), (List)new .colon.colon((Object)simName, (List)new .colon.colon((Object)this.firrtlVersionString(), (List)Nil$.MODULE$))).$plus$plus(this.systemVersionStrings())).$plus$plus((IterableOnce)new .colon.colon((Object)this.circuitHash(state.circuit()), (List)new .colon.colon((Object)this.annotationHash((Seq<Annotation>)state.annotations()), (List)Nil$.MODULE$)));
        return this.hashStrings((Seq<String>)values);
    }

    private String circuitHash(Circuit circuit) {
        Seq values = (Seq)((IterableOps)((IterableOps)circuit.modules().sortBy((Function1 & Serializable)x$2 -> x$2.name(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$3 -> StructuralHash$.MODULE$.sha256WithSignificantPortNames(x$3, StructuralHash$.MODULE$.sha256WithSignificantPortNames$default$2()))).map((Function1 & Serializable)x$4 -> x$4.toHashString());
        return this.hashStrings((Seq<String>)values);
    }

    private String firrtlVersionString() {
        return BuildInfo$.MODULE$.toString();
    }

    private Seq<String> systemVersionStrings() {
        return new .colon.colon((Object)System.getProperty("java.version"), (List)new .colon.colon((Object)Properties$.MODULE$.versionNumberString(), (List)Nil$.MODULE$));
    }

    private String annotationHash(Seq<Annotation> annos) {
        Seq relevant = (Seq)annos.filterNot((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Caching$.MODULE$.ignoreAnno(a)));
        Seq values = (Seq)((SeqOps)relevant.map((Function1 & Serializable)a -> JsonProtocol$.MODULE$.serialize((Seq)new .colon.colon(a, (List)Nil$.MODULE$)))).sorted((Ordering)Ordering.String$.MODULE$);
        return this.hashStrings((Seq<String>)values);
    }

    private boolean ignoreAnno(Annotation a) {
        return false;
    }

    private String hashStrings(Seq<String> values) {
        MessageDigest inst = MessageDigest.getInstance("SHA-256");
        values.foreach((Function1 & Serializable)v -> {
            Caching$.$anonfun$hashStrings$1(inst, v);
            return BoxedUnit.UNIT;
        });
        byte[] bytes = inst.digest();
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)b -> StringOps$.MODULE$.format$extension("%02x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)b))})), ClassTag$.MODULE$.apply(String.class))).mkString("");
    }

    public static final /* synthetic */ void $anonfun$hashStrings$1(MessageDigest inst$1, String v) {
        inst$1.update(v.getBytes("UTF-8"));
        inst$1.update((byte)0);
    }

    private Caching$() {
    }
}

