/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.simulator;

import chiseltest.simulator.BlackBox$;
import chiseltest.simulator.Compiler$;
import chiseltest.simulator.CopyVpiFiles$;
import chiseltest.simulator.GetModuleNames$;
import chiseltest.simulator.PlusArgsAnnotation;
import chiseltest.simulator.Simulator;
import chiseltest.simulator.Simulator$;
import chiseltest.simulator.SimulatorContext;
import chiseltest.simulator.SimulatorDebugAnnotation$;
import chiseltest.simulator.TopmoduleInfo;
import chiseltest.simulator.TopmoduleInfo$;
import chiseltest.simulator.Utils$;
import chiseltest.simulator.WriteFstAnnotation$;
import chiseltest.simulator.WriteLxtAnnotation;
import chiseltest.simulator.WriteVcdAnnotation$;
import chiseltest.simulator.WriteWaveformAnnotation;
import chiseltest.simulator.ipc.IPCSimulatorContext;
import chiseltest.simulator.ipc.VpiVerilogHarnessGenerator$;
import firrtl2.CircuitState;
import firrtl2.annotations.Annotation;
import firrtl2.logger.LazyLogging;
import firrtl2.logger.Logger;
import firrtl2.options.Dependency$;
import firrtl2.stage.RunFirrtlTransformAnnotation$;
import firrtl2.transforms.formal.RemoveVerificationStatements;
import geny.Writable$;
import java.io.Serializable;
import os.CommandResult;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.Pipe$;
import os.ProcessInput;
import os.ProcessOutput;
import os.RelPath;
import os.RelPath$;
import os.SegmentedPath;
import os.Shellable;
import os.Shellable$;
import os.Source;
import os.Source$;
import os.exists$;
import os.makeDir$;
import os.package$;
import os.proc;
import os.remove;
import os.write;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class IcarusSimulator$
implements Simulator,
LazyLogging {
    public static final IcarusSimulator$ MODULE$ = new IcarusSimulator$();
    private static Tuple2<Object, Object> version;
    private static Logger logger;
    private static volatile boolean bitmap$0;
    private static volatile boolean bitmap$init$0;

    static {
        Simulator.$init$(MODULE$);
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    public Logger getLogger() {
        return LazyLogging.getLogger$((LazyLogging)this);
    }

    @Override
    public boolean supportsCoverage() {
        return Simulator.supportsCoverage$(this);
    }

    @Override
    public boolean supportsLiveCoverage() {
        return Simulator.supportsLiveCoverage$(this);
    }

    public Logger logger() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: IcarusSimulator.scala: 16");
        }
        return logger;
    }

    public void firrtl2$logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
        bitmap$init$0 = true;
    }

    @Override
    public String name() {
        return "iverilog";
    }

    @Override
    public boolean isAvailable() {
        boolean x$11;
        long x$10;
        boolean x$9;
        boolean x$8;
        long x$7;
        boolean x$6;
        ProcessOutput x$5;
        ProcessOutput x$4;
        ProcessInput x$3;
        Map x$2;
        Path x$1;
        proc qual$1 = new proc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.StringShellable("which"), Shellable$.MODULE$.StringShellable("iverilog")}));
        boolean binaryFound = qual$1.call(x$1 = qual$1.call$default$1(), x$2 = qual$1.call$default$2(), x$3 = qual$1.call$default$3(), x$4 = qual$1.call$default$4(), x$5 = qual$1.call$default$5(), x$6 = qual$1.call$default$6(), x$7 = qual$1.call$default$7(), x$8 = qual$1.call$default$8(), x$9 = qual$1.call$default$9(), x$10 = qual$1.call$default$10(), x$11 = qual$1.call$default$11()).exitCode() == 0;
        return binaryFound;
    }

    @Override
    public Seq<WriteWaveformAnnotation> waveformFormats() {
        return new .colon.colon((Object)WriteVcdAnnotation$.MODULE$, (List)new .colon.colon((Object)WriteFstAnnotation$.MODULE$, (List)new .colon.colon((Object)new WriteLxtAnnotation(1), (List)new .colon.colon((Object)new WriteLxtAnnotation(2), (List)Nil$.MODULE$))));
    }

    public void findVersions() {
        if (this.isAvailable()) {
            Tuple2<Object, Object> tuple2 = this.version();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int maj = tuple2._1$mcI$sp();
            int min = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(maj, min);
            int maj2 = sp2._1$mcI$sp();
            int min2 = sp2._2$mcI$sp();
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("Found Icarus Verilog ").append(maj2).append(".").append(min2).toString());
            return;
        }
    }

    private Tuple2<Object, Object> version$lzycompute() {
        IcarusSimulator$ icarusSimulator$ = this;
        synchronized (icarusSimulator$) {
            if (!bitmap$0) {
                Object object;
                boolean x$11;
                long x$10;
                boolean x$9;
                long x$8;
                boolean x$7;
                ProcessOutput x$6;
                ProcessInput x$5;
                Map x$4;
                proc qual$1 = new proc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.StringShellable("iverilog"), Shellable$.MODULE$.StringShellable("-v")}));
                boolean x$1 = false;
                Pipe$ x$22 = Pipe$.MODULE$;
                Path x$3 = qual$1.call$default$1();
                String[] split = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(qual$1.call(x$3, x$4 = qual$1.call$default$2(), x$5 = qual$1.call$default$3(), x$6 = qual$1.call$default$4(), (ProcessOutput)x$22, x$7 = qual$1.call$default$6(), x$8 = qual$1.call$default$7(), false, x$9 = qual$1.call$default$9(), x$10 = qual$1.call$default$10(), x$11 = qual$1.call$default$11()).out().trim()), ' ');
                Predef$.MODULE$.assert(split.length > 1 && Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])split), 3)).sameElements((IterableOnce)new .colon.colon((Object)"Icarus", (List)new .colon.colon((Object)"Verilog", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)))), (Function0 & Serializable)() -> new StringBuilder(39).append("Unknown icarus verilog version string: ").append(Predef$.MODULE$.wrapRefArray((Object[])split).mkString(" ")).toString());
                int[] nArray = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(split[3]), '.')), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))), (ClassTag)ClassTag$.MODULE$.Int());
                if (nArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)nArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                    throw new MatchError((Object)nArray);
                }
                int maj = BoxesRunTime.unboxToInt((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                int min = BoxesRunTime.unboxToInt((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(maj, min);
                int maj2 = sp2._1$mcI$sp();
                int min2 = sp2._2$mcI$sp();
                version = new Tuple2.mcII.sp(maj2, min2);
                bitmap$0 = true;
            }
        }
        return version;
    }

    private Tuple2<Object, Object> version() {
        if (!bitmap$0) {
            return this.version$lzycompute();
        }
        return version;
    }

    private int majorVersion() {
        return this.version()._1$mcI$sp();
    }

    private int minorVersion() {
        return this.version()._2$mcI$sp();
    }

    private String[] getSimulatorArgs(CircuitState state) {
        return (String[])((IterableOnceOps)((IterableOps)state.annotations().view().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof PlusArgsAnnotation) {
                    PlusArgsAnnotation plusArgsAnnotation = (PlusArgsAnnotation)A1;
                    Seq<String> args = plusArgsAnnotation.plusArgs();
                    return (B1)args;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                return annotation instanceof PlusArgsAnnotation;
            }
        })).flatten(Predef$.MODULE$.$conforms())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public SimulatorContext createContext(CircuitState state) {
        Seq seq;
        Path targetDir = Compiler$.MODULE$.requireTargetDir((Seq<Annotation>)state.annotations());
        TopmoduleInfo toplevel = TopmoduleInfo$.MODULE$.apply(state.circuit());
        boolean verbose = state.annotations().contains((Object)SimulatorDebugAnnotation$.MODULE$);
        Seq<String> moduleNames = GetModuleNames$.MODULE$.apply(state.circuit());
        Path compileDir = this.makeCompileDir(targetDir, verbose);
        String verilogHarness = this.generateHarness(compileDir, toplevel, moduleNames);
        this.compileVpiToLib(toplevel.name(), compileDir);
        if (this.majorVersion() >= 11) {
            seq = (Seq)Nil$.MODULE$;
        } else {
            this.logger().warn((Function0 & Serializable)() -> "WARN: Icarus Verilog only supports chisel's assert/assume/cover statements starting with version 11.");
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(84).append("      You are using version ").append(MODULE$.majorVersion()).append(".").append(MODULE$.minorVersion()).append(" and we are going to remove all unsupported statements.").toString());
            seq = new .colon.colon((Object)RunFirrtlTransformAnnotation$.MODULE$.apply(Dependency$.MODULE$.apply(ClassTag$.MODULE$.apply(RemoveVerificationStatements.class))), (List)Nil$.MODULE$);
        }
        Seq passes = seq;
        Compiler$.MODULE$.lowFirrtlToSystemVerilog(state, (Seq<Annotation>)passes);
        Seq simCmd = (Seq)((IterableOps)this.compileSimulation(toplevel.name(), targetDir, verilogHarness).$plus$plus(this.waveformFlags(targetDir, toplevel.name(), (Seq<Annotation>)state.annotations()))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.getSimulatorArgs(state)));
        return new IPCSimulatorContext((Seq<String>)simCmd, toplevel, this, verbose);
    }

    private Path makeCompileDir(Path targetDir, boolean verbose) {
        Path compileDir = targetDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"icarus"}))));
        if (exists$.MODULE$.apply(compileDir)) {
            if (verbose) {
                Predef$.MODULE$.println((Object)new StringBuilder(48).append("Deleting stale Icarus Verilog object directory: ").append(compileDir).toString());
            }
            remove.all$.MODULE$.apply(compileDir);
        }
        makeDir$.MODULE$.apply(compileDir);
        return compileDir;
    }

    private Path compileVpiToLib(String topName, Path compileDir) {
        .colon.colon files = new .colon.colon((Object)"vpi.cpp", (List)new .colon.colon((Object)"vpi_register.cpp", (List)Nil$.MODULE$));
        Seq cmd = (Seq)new .colon.colon((Object)"iverilog-vpi", (List)new .colon.colon((Object)new StringBuilder(7).append("--name=").append(topName).toString(), (List)new .colon.colon((Object)"-D__ICARUS__", (List)Nil$.MODULE$))).$plus$plus((IterableOnce)files);
        proc qual$1 = new proc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.IterableShellable((Iterable)cmd, (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s))}));
        Path x$3 = compileDir;
        boolean x$4 = false;
        Map x$5 = qual$1.call$default$2();
        ProcessInput x$6 = qual$1.call$default$3();
        ProcessOutput x$7 = qual$1.call$default$4();
        ProcessOutput x$8 = qual$1.call$default$5();
        boolean x$9 = qual$1.call$default$6();
        long x$10 = qual$1.call$default$7();
        boolean x$11 = qual$1.call$default$9();
        long x$12 = qual$1.call$default$10();
        boolean x$13 = qual$1.call$default$11();
        CommandResult ret = qual$1.call(x$3, x$5, x$6, x$7, x$8, x$9, x$10, false, x$11, x$12, x$13);
        Path lib = compileDir.$div((PathChunk)new PathChunk.StringPathChunk(new StringBuilder(4).append(topName).append(".vpi").toString()));
        boolean success = ret.exitCode() == 0 && exists$.MODULE$.apply(lib);
        Predef$.MODULE$.assert(success, (Function0 & Serializable)() -> new StringBuilder(64).append("failed to compiler VPI shared library for circuit ").append(topName).append(" in work dir ").append(compileDir).append("\n").append(Utils$.MODULE$.quoteCmdArgs((Seq<String>)cmd)).toString());
        return lib;
    }

    private Seq<String> waveformFlags(Path targetDir, String topName, Seq<Annotation> annos) {
        String ext = Simulator$.MODULE$.getWavformFormat(annos);
        RelPath dumpfile = (RelPath)targetDir.relativeTo(package$.MODULE$.pwd()).$div((PathChunk)new PathChunk.StringPathChunk(new StringBuilder(1).append(topName).append(".").append(ext).toString()));
        if (ext.isEmpty()) {
            return new .colon.colon((Object)"-none", (List)Nil$.MODULE$);
        }
        return new .colon.colon((Object)new StringBuilder(1).append("-").append(ext).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("+dumpfile=").append(dumpfile.toString()).toString(), (List)Nil$.MODULE$));
    }

    private Seq<String> compileSimulation(String topName, Path targetDir, String verilogHarness) {
        boolean x$13;
        long x$12;
        boolean x$11;
        long x$10;
        boolean x$9;
        ProcessOutput x$8;
        ProcessOutput x$7;
        ProcessInput x$6;
        RelPath relTargetDir = targetDir.relativeTo(package$.MODULE$.pwd());
        RelPath vpiFile = (RelPath)((SegmentedPath)relTargetDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"icarus"}))))).$div((PathChunk)new PathChunk.StringPathChunk(new StringBuilder(4).append(topName).append(".vpi").toString()));
        .colon.colon flags = new .colon.colon((Object)new StringBuilder(2).append("-m").append(vpiFile.toString()).toString(), (List)new .colon.colon((Object)"-g2005-sv", (List)new .colon.colon((Object)"-DCLOCK_PERIOD=1", (List)Nil$.MODULE$)));
        RelPath simBinary = (RelPath)((SegmentedPath)relTargetDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"icarus"}))))).$div((PathChunk)new PathChunk.StringPathChunk(topName));
        List cmd = (List)((IterableOps)((IterableOps)((IterableOps)new .colon.colon((Object)"iverilog", (List)Nil$.MODULE$).$plus$plus((IterableOnce)flags)).$plus$plus((IterableOnce)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)simBinary.toString(), (List)Nil$.MODULE$)))).$plus$plus(BlackBox$.MODULE$.fFileFlags(targetDir))).$plus$plus((IterableOnce)new .colon.colon((Object)((RelPath)relTargetDir.$div((PathChunk)new PathChunk.StringPathChunk(new StringBuilder(3).append(topName).append(".sv").toString()))).toString(), (List)new .colon.colon((Object)((RelPath)((SegmentedPath)relTargetDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"icarus"}))))).$div((PathChunk)new PathChunk.StringPathChunk(verilogHarness))).toString(), (List)Nil$.MODULE$)));
        proc qual$1 = new proc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.IterableShellable((Iterable)cmd, (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s))}));
        Path x$3 = package$.MODULE$.pwd();
        boolean x$4 = false;
        Map x$5 = qual$1.call$default$2();
        CommandResult ret = qual$1.call(x$3, x$5, x$6 = qual$1.call$default$3(), x$7 = qual$1.call$default$4(), x$8 = qual$1.call$default$5(), x$9 = qual$1.call$default$6(), x$10 = qual$1.call$default$7(), false, x$11 = qual$1.call$default$9(), x$12 = qual$1.call$default$10(), x$13 = qual$1.call$default$11());
        boolean success = ret.exitCode() == 0 && exists$.MODULE$.apply(package$.MODULE$.pwd().$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(simBinary)));
        Predef$.MODULE$.assert(success, (Function0 & Serializable)() -> new StringBuilder(49).append("iverilog command failed on circuit ").append(topName).append(" in work dir ").append(targetDir).append("\n").append(Utils$.MODULE$.quoteCmdArgs((Seq<String>)cmd)).toString());
        return new .colon.colon((Object)"vvp", (List)new .colon.colon((Object)simBinary.toString(), (List)Nil$.MODULE$));
    }

    private String generateHarness(Path compileDir, TopmoduleInfo toplevel, Seq<String> moduleNames) {
        String topName = toplevel.name();
        CopyVpiFiles$.MODULE$.apply(compileDir);
        String verilogHarnessFileName = new StringBuilder(11).append(topName).append("-harness.sv").toString();
        String emittedStuff = VpiVerilogHarnessGenerator$.MODULE$.codeGen(toplevel, moduleNames, VpiVerilogHarnessGenerator$.MODULE$.codeGen$default$3(), VpiVerilogHarnessGenerator$.MODULE$.codeGen$default$4());
        write.over$.MODULE$.apply(compileDir.$div((PathChunk)new PathChunk.StringPathChunk(verilogHarnessFileName)), (Source)Source$.MODULE$.WritableSource((Object)emittedStuff, (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write.over$.MODULE$.apply$default$3(), write.over$.MODULE$.apply$default$4(), write.over$.MODULE$.apply$default$5(), write.over$.MODULE$.apply$default$6());
        return verilogHarnessFileName;
    }

    private IcarusSimulator$() {
    }
}

