/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.simulator.jna;

import chiseltest.simulator.jna.TesterSharedLibInterface;
import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.io.Serializable;
import java.util.HashMap;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.copy;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class JNAUtils$ {
    public static final JNAUtils$ MODULE$ = new JNAUtils$();
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    private static final Seq<Tuple3<String, String, Seq<Tuple2<String, String>>>> Methods;
    private static int idCounter;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        Methods = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"long", (Object)"step", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cycles"), (Object)"int"), (List)Nil$.MODULE$)), new Tuple3((Object)"void", (Object)"update", (Object)Nil$.MODULE$), new Tuple3((Object)"void", (Object)"finish", (Object)Nil$.MODULE$), new Tuple3((Object)"void", (Object)"resetCoverage", (Object)Nil$.MODULE$), new Tuple3((Object)"void", (Object)"writeCoverage", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), (Object)"String"), (List)Nil$.MODULE$)), new Tuple3((Object)"void", (Object)"poke", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"int"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"long"), (List)Nil$.MODULE$))), new Tuple3((Object)"long", (Object)"peek", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"int"), (List)Nil$.MODULE$)), new Tuple3((Object)"void", (Object)"poke_wide", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"int"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)"int"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"long"), (List)Nil$.MODULE$)))), new Tuple3((Object)"long", (Object)"peek_wide", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"int"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)"int"), (List)Nil$.MODULE$))), new Tuple3((Object)"void", (Object)"set_args", (Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argc"), (Object)"int"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argv"), (Object)"const char**"), (List)Nil$.MODULE$)))}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        idCounter = 123;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    public boolean isWindows() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: JNAUtils.scala: 7");
        }
        return isWindows;
    }

    public String javaHome() {
        String string;
        String string2 = System.getProperty("java.home");
        if (string2 != null && (string = string2).endsWith("/jre")) {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(string), 4);
        }
        if (string2 != null) {
            String string3 = string2;
            return string3;
        }
        throw new MatchError((Object)string2);
    }

    public String osIncludeName() {
        if (this.isWindows()) {
            return "win32";
        }
        String string = System.getProperty("os.name");
        if ("Mac OS X".equals(string)) {
            return "darwin";
        }
        if ("Linux".equals(string)) {
            return "linux";
        }
        if (string != null) {
            String string2 = string;
            return string2;
        }
        throw new MatchError((Object)string);
    }

    public Seq<String> ccFlags() {
        return new .colon.colon((Object)"-fPIC", (List)new .colon.colon((Object)"-shared", (List)new .colon.colon((Object)new StringBuilder(12).append("-I'").append(this.javaHome()).append("/include'").toString(), (List)new .colon.colon((Object)new StringBuilder(13).append("-I'").append(this.javaHome()).append("/include/").append(this.osIncludeName()).append("'").toString(), (List)new .colon.colon((Object)"-fvisibility=hidden", (List)Nil$.MODULE$)))));
    }

    public Seq<String> ldFlags() {
        return new .colon.colon((Object)"-shared", (List)new .colon.colon((Object)"-dynamiclib", (List)new .colon.colon((Object)"-fvisibility=hidden", (List)Nil$.MODULE$)));
    }

    public Seq<Tuple3<String, String, Seq<Tuple2<String, String>>>> Methods() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: JNAUtils.scala: 43");
        }
        return Methods;
    }

    private int idCounter() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: JNAUtils.scala: 56");
        }
        return idCounter;
    }

    private void idCounter_$eq(int x$1) {
        idCounter = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private synchronized int getUniqueId() {
        int id = this.idCounter();
        this.idCounter_$eq(this.idCounter() + 1);
        return id;
    }

    public TesterSharedLibInterface compileAndLoadJNAClass(Path libPath) {
        Path libCopy = libPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())).$div((PathChunk)new PathChunk.StringPathChunk(new StringBuilder(1).append(libPath.last()).append("_").append(this.getUniqueId()).toString()));
        copy.over$.MODULE$.apply(libPath, libCopy, copy.over$.MODULE$.apply$default$3(), copy.over$.MODULE$.apply$default$4(), copy.over$.MODULE$.apply$default$5(), copy.over$.MODULE$.apply$default$6());
        HashMap<String, Integer> opts = new HashMap<String, Integer>();
        opts.put("open-flags", BoxesRunTime.boxToInteger((int)2));
        NativeLibrary so = this.isWindows() ? NativeLibrary.getInstance((String)libCopy.toString()) : NativeLibrary.getInstance((String)libCopy.toString(), opts);
        Function initFoo = so.getFunction("sim_init");
        Pointer sPtr = initFoo.invokePointer((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Object.class)));
        return new TesterSharedLibInterface(so, sPtr);
    }

    private String cType(String tpe) {
        String string = tpe.toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -891985903: {
                if (!"string".equals(string)) break;
                return "const char*";
            }
            case 104431: {
                if (!"int".equals(string)) break;
                return "int32_t";
            }
            case 3327612: {
                if (!"long".equals(string)) break;
                return "int64_t";
            }
            case 3625364: {
                if (!"void".equals(string)) break;
                return "void";
            }
        }
        return string;
    }

    public String genJNACppCode(String simState) {
        String header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("// we only export the symbols that we prefixed with a unique id\n         |#if defined _WIN32 || defined __CYGWIN__ || defined __MINGW32__ || defined __MINGW64__\n         |#define _EXPORT __declspec(dllexport)\n         |#else\n         |#define _EXPORT __attribute__((visibility(\"default\")))\n         |#endif\n         |extern \"C\" {\n         |"));
        String initFoo = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |_EXPORT void* sim_init() {\n         |  // void* ptr = create_sim_state();\n         |  // std::cout << \"native ptr: \" << std::hex << ptr << std::endl;\n         |  // return ptr;\n         |  return (void*) create_sim_state();\n         |}\n         |\n         |"));
        String methods = ((IterableOnceOps)this.Methods().map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String ret = (String)tuple3._1();
                String name = (String)tuple3._2();
                Seq args = (Seq)tuple3._3();
                String argDecl = ((IterableOnceOps)((IterableOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"s"), (Object)"void*"), (List)Nil$.MODULE$).$plus$plus((IterableOnce)args)).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String n = (String)tuple2._1();
                        String t = (String)tuple2._2();
                        return new StringBuilder(1).append(MODULE$.cType(t)).append(" ").append(n).toString();
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(", ");
                String retTpe = MODULE$.cType(ret);
                String decl = new StringBuilder(14).append("_EXPORT ").append(retTpe).append(" ").append(name).append("(").append(argDecl).append(") {\n").toString();
                String string = ret;
                String string2 = "void";
                String callRet = !(string != null ? !string.equals(string2) : string2 != null) ? "" : "return ";
                String call = new StringBuilder(23).append("  ").append(callRet).append("((sim_state*)s)->").append(name).append("(").append(((IterableOnceOps)args.map((Function1 & Serializable)x$1 -> (String)x$1._1())).mkString(", ")).append(");\n").toString();
                return new StringBuilder(2).append(decl).append(call).append("}\n").toString();
            }
            throw new MatchError((Object)tuple3);
        })).mkString("\n");
        String footer = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("} /* extern C */\n         |"));
        return new StringBuilder(0).append(simState).append(header).append(initFoo).append(methods).append(footer).toString();
    }

    private JNAUtils$() {
    }
}

