/*
 * Decompiled with CFR 0.152.
 */
package chiseltest.simulator.jna;

import chiseltest.simulator.PinInfo;
import chiseltest.simulator.TopmoduleInfo;
import chiseltest.simulator.jna.JNAUtils$;
import java.io.Serializable;
import os.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class VerilatorCppJNAHarnessGenerator$ {
    public static final VerilatorCppJNAHarnessGenerator$ MODULE$ = new VerilatorCppJNAHarnessGenerator$();

    public String codeGen(TopmoduleInfo toplevel, Path vcdFilePath, Path targetDir, int majorVersion, int minorVersion, boolean verbose) {
        Seq pokeable = (Seq)toplevel.inputs().zipWithIndex();
        Seq peekable = (Seq)((IterableOps)toplevel.inputs().$plus$plus(toplevel.outputs())).zipWithIndex();
        StringBuilder codeBuffer = new StringBuilder();
        codeBuffer.append("\nstruct sim_state {\n  TOP_CLASS* dut;\n  VERILATED_C* tfp;\n  vluint64_t main_time;\n\n  sim_state() :\n    dut(new TOP_CLASS),\n    tfp(nullptr),\n    main_time(0)\n  {\n    // std::cout << \"Allocating! \" << ((long long) dut) << std::endl;\n  }\n\n  inline int64_t step(int32_t cycles) {\n    for(int32_t i = 0; i < cycles; i++) {\n      const int64_t status = _step(tfp, dut, main_time);\n      if(status > 0) {\n        // early exit on failure\n        return (status << 32) | ((int64_t)(i + 1));\n      }\n    }\n    return (int64_t)cycles;\n  }\n  inline void update() { dut->eval(); }\n  inline void finish() {\n    dut->eval();\n    _finish(tfp, dut);\n  }\n  inline void resetCoverage() { VerilatedCov::zero(); }\n  inline void writeCoverage(const char* filename) {\n    VerilatedCov::write(filename);\n  }\n  inline void poke(int32_t id, int64_t value) {\n    const uint64_t u = value;\n    // std::cout << \"poking: \" << std::hex << u << std::endl;\n    switch(id) {\n");
        ((IterableOnceOps)pokeable.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)VerilatorCppJNAHarnessGenerator$.fitsIn64Bits$1(s)))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PinInfo pinInfo = (PinInfo)tuple2._1();
                int id = tuple2._2$mcI$sp();
                if (pinInfo != null) {
                    String name = pinInfo.name();
                    return codeBuffer.append(new java.lang.StringBuilder(32).append("      case ").append(id).append(" : dut->").append(name).append(" = u; break;\n").toString());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        codeBuffer.append("\n    default:\n      std::cerr << \"Cannot find the object of id = \" << id << std::endl;\n      finish();\n      break;\n    }\n  }\n  inline int64_t peek(int32_t id) {\n    uint64_t value = 0;\n    switch(id) {\n");
        ((IterableOnceOps)peekable.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)VerilatorCppJNAHarnessGenerator$.fitsIn64Bits$1(s)))).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                PinInfo pinInfo = (PinInfo)tuple2._1();
                int id = tuple2._2$mcI$sp();
                if (pinInfo != null) {
                    String name = pinInfo.name();
                    return codeBuffer.append(new java.lang.StringBuilder(36).append("      case ").append(id).append(" : value = dut->").append(name).append("; break;\n").toString());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        codeBuffer.append("\n    default:\n      std::cerr << \"Cannot find the object of id = \" << id << std::endl;\n      finish();\n      return -1;\n    }\n    // std::cout << \"peeking: \" << std::hex << value << std::endl;\n    return value;\n  }\n  inline void poke_wide(int32_t id, int32_t offset, int64_t value) {\n    const uint64_t u = value;\n    WData* data = nullptr;\n    size_t words = 0;\n    switch(id) {\n");
        ((IterableOnceOps)pokeable.filterNot((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)VerilatorCppJNAHarnessGenerator$.fitsIn64Bits$1(s)))).foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                PinInfo pinInfo = (PinInfo)tuple2._1();
                int id = tuple2._2$mcI$sp();
                if (pinInfo != null) {
                    String name = pinInfo.name();
                    int width = pinInfo.width();
                    int numWords = (width - 1) / 32 + 1;
                    return codeBuffer.append(new java.lang.StringBuilder(45).append("      case ").append(id).append(" : data = dut->").append(name).append("; words = ").append(numWords).append("; break;\n").toString());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        codeBuffer.append("\n    default:\n      std::cerr << \"Cannot find the object of id = \" << id << std::endl;\n      finish();\n      break;\n    }\n    const size_t firstWord = offset * 2;\n    const size_t secondWord = firstWord + 1;\n    if(firstWord >= words || firstWord < 0) {\n      std::cerr << \"Out of bounds index for id = \" << id << \" index = \" << offset << std::endl;\n      finish();\n    } else if(secondWord >= words) {\n      data[firstWord] = u;\n    } else {\n      data[firstWord] = u & 0xffffffffu;\n      data[secondWord] = (u >> 32) & 0xffffffffu;\n    }\n  }\n  inline int64_t peek_wide(int32_t id, int32_t offset) {\n    WData* data = nullptr;\n    size_t words = 0;\n    switch(id) {\n");
        ((IterableOnceOps)peekable.filterNot((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)VerilatorCppJNAHarnessGenerator$.fitsIn64Bits$1(s)))).foreach((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                PinInfo pinInfo = (PinInfo)tuple2._1();
                int id = tuple2._2$mcI$sp();
                if (pinInfo != null) {
                    String name = pinInfo.name();
                    int width = pinInfo.width();
                    int numWords = (width - 1) / 32 + 1;
                    return codeBuffer.append(new java.lang.StringBuilder(45).append("      case ").append(id).append(" : data = dut->").append(name).append("; words = ").append(numWords).append("; break;\n").toString());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        codeBuffer.append(new java.lang.StringBuilder(846).append("\n    default:\n      std::cerr << \"Cannot find the object of id = \" << id << std::endl;\n      finish();\n      return -1;\n    }\n    const size_t firstWord = offset * 2;\n    const size_t secondWord = firstWord + 1;\n    if(firstWord >= words || firstWord < 0) {\n      std::cerr << \"Out of bounds index for id = \" << id << \" index = \" << offset << std::endl;\n      finish();\n      return -1;\n    } else if(secondWord >= words) {\n      return (uint64_t)data[firstWord];\n    } else {\n      return (((uint64_t)data[secondWord]) << 32) | ((uint64_t)data[firstWord]);\n    }\n  }\n\n  inline void set_args(int32_t argc, const char** argv) {\n    Verilated::commandArgs(argc, argv);\n  }\n};\n\nstatic sim_state* create_sim_state() {\n  sim_state *s = new sim_state();\n  std::string dumpfile = R\"(").append(vcdFilePath).append(")\";\n  _startCoverageAndDump(&s->tfp, dumpfile, s->dut);\n  return s;\n}\n").toString());
        String jnaCode = JNAUtils$.MODULE$.genJNACppCode(codeBuffer.toString());
        return new java.lang.StringBuilder(0).append(this.commonCodeGen(toplevel, targetDir, majorVersion, minorVersion, verbose)).append(jnaCode).toString();
    }

    private String commonCodeGen(TopmoduleInfo toplevel, Path targetDir, int majorVersion, int minorVersion, boolean verbose) {
        String dutName = toplevel.name();
        String dutVerilatorClassName = new java.lang.StringBuilder(1).append("V").append(dutName).toString();
        toplevel.requireNoMultiClock();
        Option clockName = toplevel.clocks().headOption();
        String clockLow = (String)clockName.map((Function1 & Serializable)x$1 -> new java.lang.StringBuilder(10).append("top->").append((String)x$1).append(" = 0;").toString()).getOrElse((Function0 & Serializable)() -> "");
        String clockHigh = (String)clockName.map((Function1 & Serializable)x$2 -> new java.lang.StringBuilder(10).append("top->").append((String)x$2).append(" = 1;").toString()).getOrElse((Function0 & Serializable)() -> "");
        String coverageInit = majorVersion >= 4 && minorVersion >= 202 ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|#if VM_COVERAGE\n           |    Verilated::defaultContextp()->coveragep()->forcePerInstance(true);\n           |#endif\n           |")) : "";
        String verilatorRunFlushCallback = majorVersion >= 4 && minorVersion >= 38 ? "Verilated::runFlushCallbacks();" : "Verilated::flushCall();";
        StringBuilder codeBuffer = new StringBuilder();
        codeBuffer.append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(3950).append("#include \"").append(dutVerilatorClassName).append(".h\"\n         |#include \"verilated.h\"\n         |\n         |#define TOP_CLASS ").append(dutVerilatorClassName).append("\n         |\n         |#ifndef VM_TRACE_FST\n         |#define VM_TRACE_FST 0\n         |#endif\n         |\n         |static const bool verbose = ").append(verbose).append(";\n         |\n         |#if VM_TRACE\n         |#if VM_TRACE_FST\n         |  #include \"verilated_fst_c.h\"\n         |  #define VERILATED_C VerilatedFstC\n         |#else // !(VM_TRACE_FST)\n         |  #include \"verilated_vcd_c.h\"\n         |  #define VERILATED_C VerilatedVcdC\n         |#endif\n         |#else // !(VM_TRACE)\n         |  #define VERILATED_C VerilatedVcdC\n         |#endif\n         |#include <iostream>\n         |\n         |\n         |// Override Verilator definition so first $finish ends simulation\n         |// Note: VL_USER_FINISH needs to be defined when compiling Verilator code\n         |static bool encounteredFinish = false;\n         |void vl_finish(const char* filename, int linenum, const char* hier) {\n         |  // std::cout << \"finish! (\" << filename << \", \" << linenum << \", \" << hier << \")\" << std::endl;\n         |  ").append(verilatorRunFlushCallback).append("\n         |  encounteredFinish = true;\n         |}\n         |\n         |\n         |static bool encounteredFatal = false;\n         |void vl_fatal(const char* filename, int linenum, const char* hier, const char* msg) {\n         |  std::cerr << \"fatal! (\" << filename << \", \" << linenum << \", \" << hier << \", \" << msg << \")\" << std::endl;\n         |  ").append(verilatorRunFlushCallback).append("\n         |  encounteredFatal = true;\n         |}\n         |\n         |\n         |static bool encounteredStop = false;\n         |void vl_stop(const char* filename, int linenum, const char* hier) {\n         |  // std::cout << \"stop! (\" << filename << \", \" << linenum << \", \" << hier << \")\" << std::endl;\n         |  ").append(verilatorRunFlushCallback).append("\n         |  encounteredStop = true;\n         |}\n         |\n         |\n         |// Global because older versions of verilator do not support contexts\n         |static vluint64_t global_time = 0;\n         |double sc_time_stamp () { return global_time; }\n         |\n         |static void _startCoverageAndDump(VERILATED_C** tfp, const std::string& dumpfile, TOP_CLASS* top) {\n         |").append(coverageInit).append("\n         |#if VM_TRACE || VM_COVERAGE\n         |    Verilated::traceEverOn(true);\n         |#endif\n         |#if VM_TRACE\n         |    if (verbose) VL_PRINTF(\"Enabling waves..\\n\");\n         |    *tfp = new VERILATED_C;\n         |    top->trace(*tfp, 99);\n         |    (*tfp)->open(dumpfile.c_str());\n         |#endif\n         |}\n         |\n         |static int64_t _step(VERILATED_C* tfp, TOP_CLASS* top, vluint64_t& main_time) {\n         |    ").append(clockLow).append("\n         |    global_time = main_time;\n         |    top->eval();\n         |#if VM_TRACE\n         |    if (tfp) tfp->dump(main_time);\n         |#endif\n         |    main_time++;\n         |    ").append(clockHigh).append("\n         |    global_time = main_time;\n         |    top->eval();\n         |#if VM_TRACE\n         |    if (tfp) tfp->dump(main_time);\n         |#endif\n         |    main_time++;\n         |    if(encounteredStop) {\n         |      // vl_stop is called by verilator when an assertion fails or when the fatal command is executed\n         |      encounteredStop = false;\n         |      encounteredFinish = false;\n         |      return 2;\n         |    } else if(encounteredFinish) {\n         |      // vl_finish is called by verilator when a finish command is executed (stop(0))\n         |      encounteredFinish = false;\n         |      return 1;\n         |    } else if(encounteredFatal) {\n         |      encounteredFatal = false;\n         |      return 3;\n         |    }\n         |    return 0;\n         |}\n         |\n         |static void _finish(VERILATED_C* tfp, TOP_CLASS* top) {\n         |#if VM_TRACE\n         |  if (tfp) tfp->close();\n         |  delete tfp;\n         |#endif\n         |#if VM_COVERAGE\n         |  VerilatedCov::write(R\"(").append(targetDir).append("/coverage.dat)\");\n         |#endif\n         |  top->final();\n         |  // TODO: re-enable!\n         |  // delete top;\n         |}\n         |").toString())));
        return codeBuffer.toString();
    }

    private static final boolean fitsIn64Bits$1(Tuple2 s) {
        return ((PinInfo)s._1()).width() <= 64;
    }

    private VerilatorCppJNAHarnessGenerator$() {
    }
}

