/*
 * Decompiled with CFR 0.152.
 */
package treadle2.chronometry;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import treadle2.chronometry.Timer$;
import treadle2.chronometry.TimerEvent;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005q!B\u000b\u0017\u0011\u0003Yb!B\u000f\u0017\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003bB\u0014\u0002\u0005\u0004%\t\u0001\u000b\u0005\u0007Y\u0005\u0001\u000b\u0011B\u0015\u0007\tu1\u0002!\f\u0005\u0006K\u0015!\tA\f\u0005\ba\u0015\u0001\r\u0011\"\u00012\u0011\u001d)T\u00011A\u0005\u0002YBa\u0001P\u0003!B\u0013\u0011\u0004bB\u001f\u0006\u0005\u0004%\tA\u0010\u0005\u0007+\u0016\u0001\u000b\u0011B \t\u000fY+!\u0019!C\u0001/\"1\u0001,\u0002Q\u0001\nICQ!W\u0003\u0005\u0002iCQa\\\u0003\u0005\u0002ADQA]\u0003\u0005\u0002MDQA^\u0003\u0005\u0002]DQ!_\u0003\u0005\u0002iDQ\u0001`\u0003\u0005\u0002uDQA`\u0003\u0005\u0002}\fQ\u0001V5nKJT!a\u0006\r\u0002\u0017\rD'o\u001c8p[\u0016$(/\u001f\u0006\u00023\u0005AAO]3bI2,'g\u0001\u0001\u0011\u0005q\tQ\"\u0001\f\u0003\u000bQKW.\u001a:\u0014\u0005\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027\u0005AA+\u001a8U_f\"\b.F\u0001*!\t\u0001#&\u0003\u0002,C\t1Ai\\;cY\u0016\f\u0011\u0002V3o)>LD\u000f\u001b\u0011\u0014\u0005\u0015yB#A\u0018\u0011\u0005q)\u0011aB3oC\ndW\rZ\u000b\u0002eA\u0011\u0001eM\u0005\u0003i\u0005\u0012qAQ8pY\u0016\fg.A\u0006f]\u0006\u0014G.\u001a3`I\u0015\fHCA\u001c;!\t\u0001\u0003(\u0003\u0002:C\t!QK\\5u\u0011\u001dY\u0004\"!AA\u0002I\n1\u0001\u001f\u00132\u0003!)g.\u00192mK\u0012\u0004\u0013!\u0003;j[&tw\rT8h+\u0005y\u0004\u0003\u0002!F\u000fJk\u0011!\u0011\u0006\u0003\u0005\u000e\u000bq!\\;uC\ndWM\u0003\u0002EC\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\u000b%a\u0002%bg\"l\u0015\r\u001d\t\u0003\u0011>s!!S'\u0011\u0005)\u000bS\"A&\u000b\u00051S\u0012A\u0002\u001fs_>$h(\u0003\u0002OC\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0015\u0005\u0005\u0002\u001d'&\u0011AK\u0006\u0002\u000b)&lWM]#wK:$\u0018A\u0003;j[&tw\rT8hA\u0005QAo\u001c;bY\u00163XM\u001c;\u0016\u0003I\u000b1\u0002^8uC2,e/\u001a8uA\u0005)\u0011\r\u001d9msV\u00111l\u0018\u000b\u000396$\"!\u00185\u0011\u0005y{F\u0002\u0001\u0003\u0006A:\u0011\r!\u0019\u0002\u0002%F\u0011!-\u001a\t\u0003A\rL!\u0001Z\u0011\u0003\u000f9{G\u000f[5oOB\u0011\u0001EZ\u0005\u0003O\u0006\u00121!\u00118z\u0011\u0019Ig\u0002\"a\u0001U\u0006)!\r\\8dWB\u0019\u0001e[/\n\u00051\f#\u0001\u0003\u001fcs:\fW.\u001a \t\u000b9t\u0001\u0019A$\u0002\u0007Q\fw-\u0001\u0005f]R\u0014\u0018PR8s)\t9\u0015\u000fC\u0003o\u001f\u0001\u0007q)A\u0006qe\u0016$H/_#oiJLHCA$u\u0011\u0015)\b\u00031\u0001S\u0003\u0015)g\u000e\u001e:z\u0003E\u0001(/\u001a;us\u0016sGO]=G_J$\u0016m\u001a\u000b\u0003\u000fbDQA\\\tA\u0002\u001d\u000ba\u0002\u001d:fiRLH*Y:u)&lW\r\u0006\u0002Hw\")aN\u0005a\u0001\u000f\u0006)1\r\\3beR\tq'\u0001\u0004sKB|'\u000f\u001e\u000b\u0002\u000f\u0002")
public class Timer {
    private boolean enabled = true;
    private final HashMap<String, TimerEvent> timingLog;
    private final TimerEvent totalEvent;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);

    public static double TenTo9th() {
        return Timer$.MODULE$.TenTo9th();
    }

    public boolean enabled() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: Timer.scala: 19");
        }
        return this.enabled;
    }

    public void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public HashMap<String, TimerEvent> timingLog() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: Timer.scala: 20");
        }
        return this.timingLog;
    }

    public TimerEvent totalEvent() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: Timer.scala: 22");
        }
        return this.totalEvent;
    }

    public <R> R apply(String tag, Function0<R> block) {
        if (this.enabled()) {
            long t0 = System.nanoTime();
            Object result = block.apply();
            long t1 = System.nanoTime();
            TimerEvent timerEvent = (TimerEvent)this.timingLog().getOrElseUpdate((Object)tag, (Function0 & Serializable)() -> new TimerEvent(tag));
            timerEvent.events_$eq(timerEvent.events() + 1L);
            this.totalEvent().events_$eq(this.totalEvent().events() + 1L);
            long delta = t1 - t0;
            timerEvent.nanoseconds_$eq(timerEvent.nanoseconds() + delta);
            timerEvent.lastEventNanoseconds_$eq(delta);
            this.totalEvent().nanoseconds_$eq(this.totalEvent().nanoseconds() + delta);
            this.totalEvent().lastEventNanoseconds_$eq(delta);
            return (R)result;
        }
        return (R)block.apply();
    }

    public String entryFor(String tag) {
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            return new StringBuilder(2).append(entry.events()).append(":").append(entry.nanoseconds()).append(":").append(entry.nanoseconds() / entry.events()).toString();
        }
        return "";
    }

    public String prettyEntry(TimerEvent entry) {
        double total_seconds = (double)entry.nanoseconds() / Timer$.MODULE$.TenTo9th();
        double averageSeconds = (double)entry.nanoseconds() / (double)entry.events() / Timer$.MODULE$.TenTo9th() * 1000000.0;
        return StringOps$.MODULE$.format$extension("%10d events %12.6f total seconds %12.6f average usec", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry.events()), BoxesRunTime.boxToDouble((double)total_seconds), BoxesRunTime.boxToDouble((double)averageSeconds)}));
    }

    public String prettyEntryForTag(String tag) {
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            return this.prettyEntry(entry);
        }
        return "";
    }

    public String prettyLastTime(String tag) {
        Option option = this.timingLog().get((Object)tag);
        if (option instanceof Some) {
            Some some = (Some)option;
            TimerEvent entry = (TimerEvent)some.value();
            double lastEventSeconds = (double)entry.lastEventNanoseconds() / Timer$.MODULE$.TenTo9th();
            return String.valueOf(BoxesRunTime.boxToDouble((double)lastEventSeconds));
        }
        return "";
    }

    public void clear() {
        this.timingLog().clear();
    }

    public String report() {
        Seq sortedTags = (Seq)this.timingLog().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        return new StringBuilder(1).append(((IterableOnceOps)sortedTags.map((Function1 & Serializable)tag -> StringOps$.MODULE$.format$extension("%-20s %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tag, this.prettyEntryForTag((String)tag)})))).mkString("\n")).append("\n").append(StringOps$.MODULE$.format$extension("%-20s %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Total", this.prettyEntry(this.totalEvent())}))).toString();
    }

    public Timer() {
        this.timingLog = new HashMap();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.totalEvent = new TimerEvent("Total");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

