/*
 * Decompiled with CFR 0.152.
 */
package treadle2.executable;

import firrtl2.CircuitState;
import firrtl2.annotations.Annotation;
import firrtl2.annotations.PresetAnnotation;
import firrtl2.annotations.ReferenceTarget;
import firrtl2.ir.Circuit;
import firrtl2.logger.LazyLogging;
import firrtl2.logger.Logger;
import firrtl2.options.OptionsView;
import firrtl2.options.StageOptions;
import firrtl2.options.Viewer$;
import firrtl2.options.package;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import treadle2.AllowCyclesAnnotation$;
import treadle2.BlackBoxFactoriesAnnotation;
import treadle2.PlusArgsAnnotation;
import treadle2.PrefixPrintfWithWallTime$;
import treadle2.SaveFirrtlAtLoadAnnotation$;
import treadle2.ScalaBlackBoxFactory;
import treadle2.ShowFirrtlAtLoadAnnotation$;
import treadle2.TreadleCircuitStateAnnotation;
import treadle2.ValidIfIsRandomAnnotation$;
import treadle2.VerboseAnnotation$;
import treadle2.blackboxes.PlusArg;
import treadle2.blackboxes.PlusArg$;
import treadle2.chronometry.Timer;
import treadle2.chronometry.Timer$;
import treadle2.chronometry.UTC;
import treadle2.executable.DataStore;
import treadle2.executable.DataStore$;
import treadle2.executable.DataStoreAllocator;
import treadle2.executable.ExecutionEngine;
import treadle2.executable.ExpressionCompiler;
import treadle2.executable.Scheduler;
import treadle2.executable.SymbolTable;
import treadle2.executable.SymbolTable$;

public final class ExecutionEngine$
implements LazyLogging {
    public static final ExecutionEngine$ MODULE$ = new ExecutionEngine$();
    private static final String VCDHookName;
    private static Logger logger;
    private static volatile byte bitmap$init$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        VCDHookName = "log-vcd";
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
    }

    public Logger getLogger() {
        return LazyLogging.getLogger$((LazyLogging)this);
    }

    public Logger logger() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 548");
        }
        return logger;
    }

    public void firrtl2$logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    public String VCDHookName() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 550");
        }
        return VCDHookName;
    }

    public ExecutionEngine apply(Seq<Annotation> annotationSeq, UTC wallTime) {
        Timer timer = new Timer();
        long t0 = System.nanoTime();
        StageOptions stageOptions = (StageOptions)Viewer$.MODULE$.view(annotationSeq, (OptionsView)package.StageOptionsView$.MODULE$);
        Circuit circuit = ((CircuitState)annotationSeq.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TreadleCircuitStateAnnotation) {
                    TreadleCircuitStateAnnotation treadleCircuitStateAnnotation = (TreadleCircuitStateAnnotation)A1;
                    CircuitState c = treadleCircuitStateAnnotation.state();
                    return (B1)c;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                return annotation instanceof TreadleCircuitStateAnnotation;
            }
        }).get()).circuit();
        if (annotationSeq.contains((Object)ShowFirrtlAtLoadAnnotation$.MODULE$)) {
            Predef$.MODULE$.println((Object)circuit.serialize());
        }
        if (annotationSeq.contains((Object)SaveFirrtlAtLoadAnnotation$.MODULE$)) {
            String fileName = stageOptions.getBuildFileName(circuit.main(), (Option)new Some((Object)".treadle.lo.fir"));
            PrintWriter writer = new PrintWriter(fileName);
            writer.println(circuit.serialize());
            writer.close();
        }
        Seq blackBoxFactories = (Seq)annotationSeq.flatMap((Function1 & Serializable)x0$1 -> {
            Annotation annotation = x0$1;
            if (annotation instanceof BlackBoxFactoriesAnnotation) {
                BlackBoxFactoriesAnnotation blackBoxFactoriesAnnotation = (BlackBoxFactoriesAnnotation)annotation;
                Seq<ScalaBlackBoxFactory> bbf = blackBoxFactoriesAnnotation.blackBoxFactories();
                return bbf;
            }
            return (Seq)package$.MODULE$.Seq().empty();
        });
        boolean allowCycles = annotationSeq.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$2(x0$2)));
        boolean prefixPrintfWithTime = annotationSeq.exists((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$3(x0$3)));
        Seq plusArgs = (Seq)((IterableOps)annotationSeq.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof PlusArgsAnnotation) {
                    PlusArgsAnnotation plusArgsAnnotation = (PlusArgsAnnotation)A1;
                    Seq<String> seq = plusArgsAnnotation.plusArgs();
                    return (B1)seq;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Annotation x2) {
                Annotation annotation = x2;
                return annotation instanceof PlusArgsAnnotation;
            }
        }).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)s -> PlusArg$.MODULE$.apply((String)s));
        Seq registerPresets = (Seq)annotationSeq.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof PresetAnnotation) {
                    PresetAnnotation presetAnnotation = (PresetAnnotation)A1;
                    ReferenceTarget target = presetAnnotation.target();
                    return (B1)target;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Annotation x3) {
                Annotation annotation = x3;
                return annotation instanceof PresetAnnotation;
            }
        });
        boolean validIfIsRandom = annotationSeq.exists((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$6(x0$4)));
        boolean verbose = annotationSeq.exists((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine$.$anonfun$apply$7(x0$5)));
        SymbolTable symbolTable = (SymbolTable)timer.apply("Build Symbol Table", (Function0 & Serializable)() -> SymbolTable$.MODULE$.apply(circuit, (Seq<ScalaBlackBoxFactory>)blackBoxFactories, allowCycles));
        DataStoreAllocator dataStoreAllocator = new DataStoreAllocator();
        symbolTable.allocateData(dataStoreAllocator);
        DataStore dataStore = DataStore$.MODULE$.apply(dataStoreAllocator);
        if (verbose) {
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("Symbol table:\n").append(symbolTable.render()).toString());
        }
        Scheduler scheduler = new Scheduler(symbolTable);
        ExpressionCompiler compiler = new ExpressionCompiler(symbolTable, dataStore, scheduler, validIfIsRandom, prefixPrintfWithTime, (Seq<ScalaBlackBoxFactory>)blackBoxFactories, (Seq<PlusArg>)plusArgs, (Seq<ReferenceTarget>)registerPresets);
        timer.apply("Build Compiled Expressions", (JFunction0.mcV.sp & Serializable)() -> compiler.compile(circuit));
        scheduler.organizeAssigners();
        ExecutionEngine executionEngine = new ExecutionEngine(circuit, annotationSeq, symbolTable, dataStore, scheduler, wallTime);
        executionEngine.dataStore().setExecutionEngine(executionEngine);
        if (verbose) {
            scheduler.setVerboseAssign(verbose);
        }
        executionEngine.inputsChanged_$eq(true);
        long t1 = System.nanoTime();
        double total_seconds = (double)(t1 - t0) / Timer$.MODULE$.TenTo9th();
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(46).append("file loaded in ").append(total_seconds).append(" seconds, ").append(symbolTable.size()).append(" symbols, ").append(scheduler.combinationalAssigns().size()).append(" statements").toString());
        executionEngine.memoryInitializer().initializeMemoriesFromFiles();
        return executionEngine;
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Annotation x0$2) {
        Annotation annotation = x0$2;
        return AllowCyclesAnnotation$.MODULE$.equals(annotation);
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Annotation x0$3) {
        Annotation annotation = x0$3;
        return PrefixPrintfWithWallTime$.MODULE$.equals(annotation);
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Annotation x0$4) {
        Annotation annotation = x0$4;
        return ValidIfIsRandomAnnotation$.MODULE$.equals(annotation);
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(Annotation x0$5) {
        Annotation annotation = x0$5;
        return VerboseAnnotation$.MODULE$.equals(annotation);
    }

    private ExecutionEngine$() {
    }
}

