/*
 * Decompiled with CFR 0.152.
 */
package treadle2.executable;

import firrtl2.Kind;
import firrtl2.MemKind$;
import firrtl2.PortKind$;
import firrtl2.RegKind$;
import firrtl2.annotations.Annotation;
import firrtl2.annotations.ReferenceTarget;
import firrtl2.annotations.TargetToken;
import firrtl2.ir.Circuit;
import firrtl2.ir.ClockType$;
import firrtl2.ir.Info;
import firrtl2.ir.NoInfo$;
import firrtl2.ir.Type;
import firrtl2.logger.LazyLogging;
import firrtl2.logger.Logger;
import firrtl2.options.OptionsView;
import firrtl2.options.StageOptions;
import firrtl2.options.Viewer$;
import firrtl2.options.package;
import firrtl2.stage.OutputFileAnnotation;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashSet;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import treadle2.DataStorePlugInAnnotation;
import treadle2.RandomSeedAnnotation;
import treadle2.RandomizeAtStartupAnnotation$;
import treadle2.SymbolsToWatchAnnotation;
import treadle2.VerboseAnnotation$;
import treadle2.chronometry.Timer;
import treadle2.chronometry.UTC;
import treadle2.executable.DataStore;
import treadle2.executable.DataStorePlugin;
import treadle2.executable.DataType;
import treadle2.executable.ExecutionEngine$;
import treadle2.executable.GetIntConstant;
import treadle2.executable.MemoryInitializer;
import treadle2.executable.RenderComputations;
import treadle2.executable.ReportAssignments;
import treadle2.executable.Scheduler;
import treadle2.executable.SignedInt$;
import treadle2.executable.StopData;
import treadle2.executable.StopException;
import treadle2.executable.StopOp$;
import treadle2.executable.Symbol;
import treadle2.executable.SymbolTable;
import treadle2.executable.TreadleException;
import treadle2.executable.VcdHook;
import treadle2.executable.VcdMemoryLoggingController;
import treadle2.executable.VcdMemoryLoggingController$;
import treadle2.executable.package;
import treadle2.package$;
import treadle2.utils.NameBasedRandomNumberGenerator;
import treadle2.utils.Render$;
import treadle2.vcd.VCD;
import treadle2.vcd.VCD$;

@ScalaSignature(bytes="\u0006\u0005\r\rh\u0001B6m\u0001ED!\"!\u0001\u0001\u0005\u000b\u0007I\u0011AA\u0002\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u0011Q\u0001\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\r\t\u0015\u0005u\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002@\u0001\u0011)\u0019!C\u0001\u0003\u0003B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tY\u0005\u0001BC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003+\u0002!\u0011!Q\u0001\n\u0005=\u0003BCA,\u0001\t\u0015\r\u0011\"\u0001\u0002Z!Q\u0011q\r\u0001\u0003\u0002\u0003\u0006I!a\u0017\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!I\u00111\u0010\u0001C\u0002\u0013\u0005\u0011Q\u0010\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002\u0000!I\u0011q\u0011\u0001A\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003;\u0003\u0001\u0019!C\u0001\u0003?C\u0001\"a+\u0001A\u0003&\u00111\u0012\u0005\n\u0003[\u0003\u0001\u0019!C\u0001\u0003_C\u0011\"!1\u0001\u0001\u0004%\t!a1\t\u0011\u0005\u001d\u0007\u0001)Q\u0005\u0003cC\u0011\"!3\u0001\u0005\u0004%I!a,\t\u0011\u0005-\u0007\u0001)A\u0005\u0003cC\u0011\"!4\u0001\u0005\u0004%I!a4\t\u0011\u0005u\u0007\u0001)A\u0005\u0003#D\u0011\"a8\u0001\u0005\u0004%\t!a,\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003cC\u0011\"a9\u0001\u0005\u0004%\t!!:\t\u0011\u0005u\b\u0001)A\u0005\u0003OD\u0011\"a@\u0001\u0001\u0004%\tA!\u0001\t\u0013\t%\u0001\u00011A\u0005\u0002\t-\u0001\u0002\u0003B\b\u0001\u0001\u0006KAa\u0001\t\u0013\tE\u0001A1A\u0005\u0002\tM\u0001\u0002\u0003B\u000e\u0001\u0001\u0006IA!\u0006\t\u0013\tu\u0001\u00011A\u0005\u0002\t\u0005\u0001\"\u0003B\u0010\u0001\u0001\u0007I\u0011\u0001B\u0011\u0011!\u0011)\u0003\u0001Q!\n\t\r\u0001\"\u0003B\u0014\u0001\t\u0007I\u0011\u0001B\u0015\u0011!\u0011Y\u0004\u0001Q\u0001\n\t-\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011%\u0011I\u0005AI\u0001\n\u0003\u0011Y\u0005C\u0005\u0003b\u0001\u0011\r\u0011\"\u0001\u0003d!A!1\u000e\u0001!\u0002\u0013\u0011)\u0007C\u0005\u0003n\u0001\u0011\r\u0011\"\u0001\u0003p!A!q\u000f\u0001!\u0002\u0013\u0011\t\bC\u0004\u0003z\u0001!\tAa\u001f\t\u0013\t=\u0005!%A\u0005\u0002\tE\u0005b\u0002BK\u0001\u0011\u0005!q\b\u0005\b\u0005/\u0003A\u0011\u0001B \u0011\u001d\u0011I\n\u0001C\u0001\u00057C\u0011B!)\u0001#\u0003%\tAa)\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003@!9!\u0011\u0016\u0001\u0005\u0002\t-\u0006\"\u0003B^\u0001E\u0005I\u0011\u0001B_\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u0007D\u0011B!6\u0001#\u0003%\tAa\u0013\t\u0013\t]\u0007!%A\u0005\u0002\t-\u0003\"\u0003Bm\u0001E\u0005I\u0011\u0001B_\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005;DqA!:\u0001\t\u0003\u00119\u000fC\u0004\u0003l\u0002!\tA!\u000b\t\u000f\t5\b\u0001\"\u0001\u0003*!9!q\u001e\u0001\u0005\u0002\t%\u0002b\u0002By\u0001\u0011\u0005!1\u001f\u0005\b\u0005o\u0004A\u0011\u0001B}\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005\u007fDqaa\u0002\u0001\t\u0003\u0019I\u0001C\u0004\u0004\u000e\u0001!\taa\u0004\t\u000f\r\r\u0002\u0001\"\u0001\u0003@!91Q\u0005\u0001\u0005\u0002\r\u001d\u0002\"CB\u0017\u0001\t\u0007I\u0011BB\u0018\u0011!\u0019\u0019\u0004\u0001Q\u0001\n\rE\u0002bBB\u001b\u0001\u0011\u00051q\u0007\u0005\n\u0007\u0003\u0002\u0001\u0019!C\u0005\u0007oA\u0011ba\u0011\u0001\u0001\u0004%Ia!\u0012\t\u0011\r%\u0003\u0001)Q\u0005\u0007sAqaa\u0013\u0001\t\u0003\u0011\t\u0001C\u0004\u0004N\u0001!\taa\u0014\t\u0013\rM\u0003\u00011A\u0005\n\rU\u0003\"CB2\u0001\u0001\u0007I\u0011BB3\u0011!\u0019I\u0007\u0001Q!\n\r]\u0003bBB6\u0001\u0011\u00051Q\u000e\u0005\b\u0007c\u0002A\u0011AB:\u0011\u001d\u0019I\b\u0001C\u0001\u0007wBqa! \u0001\t\u0003\u0019y\bC\u0005\u0004\u0006\u0002\t\n\u0011\"\u0001\u0003L!91q\u0011\u0001\u0005\u0002\u0005=\u0006bBBE\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0007\u0017\u0003A\u0011AAX\u0011\u001d\u0019i\t\u0001C\u0001\u0003_Cqaa$\u0001\t\u0003\tyKB\u0005\u0004\u0012\u0002\u0001\n1!\u0001\u0004\u0014\"91QS/\u0005\u0002\t}\u0002bBBL;\u0012\u0005!q\b\u0005\b\u00073kF\u0011\u0001B \r\u0019\u0019Y\n\u0001\u0001\u0004\u001e\"9\u0011\u0011N1\u0005\u0002\r\r\u0006bBBT\u0001\u0011\u00051\u0011\u0016\u0005\b\u0007s\u0003A\u0011AB^\u000f\u001d\u0019y\f\u001cE\u0001\u0007\u00034aa\u001b7\t\u0002\r\r\u0007bBA5M\u0012\u00051Q\u0019\u0005\n\u0007\u000f4'\u0019!C\u0001\u0007\u0013D\u0001b!7gA\u0003%11\u001a\u0005\b\u000774G\u0011ABo\u0005=)\u00050Z2vi&|g.\u00128hS:,'BA7o\u0003))\u00070Z2vi\u0006\u0014G.\u001a\u0006\u0002_\u0006AAO]3bI2,'g\u0001\u0001\u0014\u0007\u0001\u0011\b\u0010\u0005\u0002tm6\tAOC\u0001v\u0003\u0015\u00198-\u00197b\u0013\t9HO\u0001\u0004B]f\u0014VM\u001a\t\u0003szl\u0011A\u001f\u0006\u0003wr\fa\u0001\\8hO\u0016\u0014(\"A?\u0002\u000f\u0019L'O\u001d;me%\u0011qP\u001f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002bgR,\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003}\u0003\tI'/\u0003\u0003\u0002\u0010\u0005%!aB\"je\u000e,\u0018\u000e^\u0001\u0005CN$\b%A\u0007b]:|G/\u0019;j_:\u001cV-]\u000b\u0003\u0003/\u0001B!!\u0007\u0002*9!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011a\u00061AH]8pizJ\u0011!`\u0005\u0004\u0003Oa\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003W\tiCA\u0007B]:|G/\u0019;j_:\u001cV-\u001d\u0006\u0004\u0003Oa\u0018AD1o]>$\u0018\r^5p]N+\u0017\u000fI\u0001\fgfl'm\u001c7UC\ndW-\u0006\u0002\u00026A!\u0011qGA\u001d\u001b\u0005a\u0017bAA\u001eY\nY1+_7c_2$\u0016M\u00197f\u00031\u0019\u00180\u001c2pYR\u000b'\r\\3!\u0003%!\u0017\r^1Ti>\u0014X-\u0006\u0002\u0002DA!\u0011qGA#\u0013\r\t9\u0005\u001c\u0002\n\t\u0006$\u0018m\u0015;pe\u0016\f!\u0002Z1uCN#xN]3!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002PA!\u0011qGA)\u0013\r\t\u0019\u0006\u001c\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003!9\u0018\r\u001c7US6,WCAA.!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1]\u0006Y1\r\u001b:p]>lW\r\u001e:z\u0013\u0011\t)'a\u0018\u0003\u0007U#6)A\u0005xC2dG+[7fA\u00051A(\u001b8jiz\"b\"!\u001c\u0002p\u0005E\u00141OA;\u0003o\nI\bE\u0002\u00028\u0001Aq!!\u0001\u000e\u0001\u0004\t)\u0001C\u0004\u0002\u00145\u0001\r!a\u0006\t\u000f\u0005ER\u00021\u0001\u00026!9\u0011qH\u0007A\u0002\u0005\r\u0003bBA&\u001b\u0001\u0007\u0011q\n\u0005\b\u0003/j\u0001\u0019AA.\u0003I\u0019\u0017p\u00197f)&lW-\u00138de\u0016lWM\u001c;\u0016\u0005\u0005}\u0004cA:\u0002\u0002&\u0019\u00111\u0011;\u0003\u0007%sG/A\nds\u000edW\rV5nK&s7M]3nK:$\b%A\u0005wG\u0012|\u0005\u000f^5p]V\u0011\u00111\u0012\t\u0006g\u00065\u0015\u0011S\u0005\u0004\u0003\u001f#(AB(qi&|g\u000e\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9J\\\u0001\u0004m\u000e$\u0017\u0002BAN\u0003+\u00131AV\"E\u0003518\rZ(qi&|gn\u0018\u0013fcR!\u0011\u0011UAT!\r\u0019\u00181U\u0005\u0004\u0003K#(\u0001B+oSRD\u0011\"!+\u0012\u0003\u0003\u0005\r!a#\u0002\u0007a$\u0013'\u0001\u0006wG\u0012|\u0005\u000f^5p]\u0002\n1B^2e\r&dWMT1nKV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000bYL\u0004\u0003\u00026\u0006]\u0006cAA\u000fi&\u0019\u0011\u0011\u0018;\u0002\rA\u0013X\rZ3g\u0013\u0011\ti,a0\u0003\rM#(/\u001b8h\u0015\r\tI\f^\u0001\u0010m\u000e$g)\u001b7f\u001d\u0006lWm\u0018\u0013fcR!\u0011\u0011UAc\u0011%\tI\u000bFA\u0001\u0002\u0004\t\t,\u0001\u0007wG\u00124\u0015\u000e\\3OC6,\u0007%A\u0004u_Bt\u0015-\\3\u0002\u0011Q|\u0007OT1nK\u0002\nAb\u001d;bO\u0016|\u0005\u000f^5p]N,\"!!5\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6}\u0003\u001dy\u0007\u000f^5p]NLA!a7\u0002V\na1\u000b^1hK>\u0003H/[8og\u0006i1\u000f^1hK>\u0003H/[8og\u0002\n\u0011cZ3oKJ\fG/\u001a3GS2,'k\\8u\u0003I9WM\\3sCR,GMR5mKJ{w\u000e\u001e\u0011\u00027MLXNY8mgB{7.\u001a3TS:\u001cW-\u0012<bYV\fG/[8o+\t\t9\u000f\u0005\u0004\u0002j\u0006M\u0018q_\u0007\u0003\u0003WTA!!<\u0002p\u00069Q.\u001e;bE2,'bAAyi\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00181\u001e\u0002\b\u0011\u0006\u001c\bnU3u!\u0011\t9$!?\n\u0007\u0005mHN\u0001\u0004Ts6\u0014w\u000e\\\u0001\u001dgfl'm\u001c7t!>\\W\rZ*j]\u000e,WI^1mk\u0006$\u0018n\u001c8!\u0003\u001d1XM\u001d2pg\u0016,\"Aa\u0001\u0011\u0007M\u0014)!C\u0002\u0003\bQ\u0014qAQ8pY\u0016\fg.A\u0006wKJ\u0014wn]3`I\u0015\fH\u0003BAQ\u0005\u001bA\u0011\"!+ \u0003\u0003\u0005\rAa\u0001\u0002\u0011Y,'OY8tK\u0002\na\"^:feJ\u000bg\u000eZ8n'\u0016,G-\u0006\u0002\u0003\u0016A\u00191Oa\u0006\n\u0007\teAO\u0001\u0003M_:<\u0017aD;tKJ\u0014\u0016M\u001c3p[N+W\r\u001a\u0011\u0002\u001b%t\u0007/\u001e;t\u0007\"\fgnZ3e\u0003EIg\u000e];ug\u000eC\u0017M\\4fI~#S-\u001d\u000b\u0005\u0003C\u0013\u0019\u0003C\u0005\u0002*\u0012\n\t\u00111\u0001\u0003\u0004\u0005q\u0011N\u001c9viN\u001c\u0005.\u00198hK\u0012\u0004\u0013AD:z[\n|Gn\u001d+p/\u0006$8\r[\u000b\u0003\u0005W\u0001bA!\f\u00036\u0005Ef\u0002\u0002B\u0018\u0005gqA!!\b\u00032%\tQ/C\u0002\u0002(QLAAa\u000e\u0003:\t\u00191+Z9\u000b\u0007\u0005\u001dB/A\bts6\u0014w\u000e\\:U_^\u000bGo\u00195!\u0003-\u0019X\r\u001e'fC:lu\u000eZ3\u0015\u0005\u0005\u0005\u0016AC:fiZ+'OY8tKR!\u0011\u0011\u0015B#\u0011%\u00119%\u000bI\u0001\u0002\u0004\u0011\u0019!A\u0005jgZ+'OY8tK\u0006!2/\u001a;WKJ\u0014wn]3%I\u00164\u0017-\u001e7uIE*\"A!\u0014+\t\t\r!qJ\u0016\u0003\u0005#\u0002BAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&A\u0005v]\u000eDWmY6fI*\u0019!1\f;\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003`\tU#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)A/[7feV\u0011!Q\r\t\u0005\u0003;\u00129'\u0003\u0003\u0003j\u0005}#!\u0002+j[\u0016\u0014\u0018A\u0002;j[\u0016\u0014\b%A\tnK6|'/_%oSRL\u0017\r\\5{KJ,\"A!\u001d\u0011\t\u0005]\"1O\u0005\u0004\u0005kb'!E'f[>\u0014\u00180\u00138ji&\fG.\u001b>fe\u0006\u0011R.Z7pefLe.\u001b;jC2L'0\u001a:!\u00035i\u0017m[3W\u0007\u0012cunZ4feRA\u0011\u0011\u0015B?\u0005\u0003\u0013)\tC\u0004\u0003\u0000=\u0002\r!!-\u0002\u0011\u0019LG.\u001a(b[\u0016DqAa!0\u0001\u0004\u0011\u0019!A\btQ><XK\u001c3feN\u001cwN]3e\u0011%\u00119i\fI\u0001\u0002\u0004\u0011I)\u0001\u0007nK6|'/\u001f'pO\u001e,'\u000f\u0005\u0003\u00028\t-\u0015b\u0001BGY\nQbk\u00193NK6|'/\u001f'pO\u001eLgnZ\"p]R\u0014x\u000e\u001c7fe\u00069R.Y6f-\u000e#Ej\\4hKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005'SCA!#\u0003P\u0005QA-[:bE2,gk\u0011#\u0002\u0011]\u0014\u0018\u000e^3W\u0007\u0012\u000b\u0011B]1oI>l\u0017N_3\u0015\t\u0005\u0005&Q\u0014\u0005\n\u0005?\u001b\u0004\u0013!a\u0001\u0005+\tQ\"\u00193eSR|g.\u00197TK\u0016$\u0017a\u0005:b]\u0012|W.\u001b>fI\u0011,g-Y;mi\u0012\nTC\u0001BSU\u0011\u0011)Ba\u0014\u0002\u0015I,h.Q:tS\u001et7/\u0001\u0005hKR4\u0016\r\\;f)\u0019\u0011iKa-\u00038B!!Q\u0006BX\u0013\u0011\u0011\tL!\u000f\u0003\r\tKw-\u00138u\u0011\u001d\u0011)L\u000ea\u0001\u0003c\u000bAA\\1nK\"I!\u0011\u0018\u001c\u0011\u0002\u0003\u0007\u0011qP\u0001\u0007_\u001a47/\u001a;\u0002%\u001d,GOV1mk\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005\u007fSC!a \u0003P\u0005A1/\u001a;WC2,X\r\u0006\u0007\u0003.\n\u0015'q\u0019Bf\u0005\u001f\u0014\u0019\u000eC\u0004\u00036b\u0002\r!!-\t\u000f\t%\u0007\b1\u0001\u0003.\u0006)a/\u00197vK\"I!Q\u001a\u001d\u0011\u0002\u0003\u0007!1A\u0001\u0006M>\u00148-\u001a\u0005\n\u0005#D\u0004\u0013!a\u0001\u0005\u0007\tAB]3hSN$XM\u001d)pW\u0016D\u0011B!/9!\u0003\u0005\r!a \u0002%M,GOV1mk\u0016$C-\u001a4bk2$HeM\u0001\u0013g\u0016$h+\u00197vK\u0012\"WMZ1vYR$C'\u0001\ntKR4\u0016\r\\;fI\u0011,g-Y;mi\u0012*\u0014aC:fi&sGOV1mk\u0016$b!a \u0003`\n\r\bb\u0002Bqy\u0001\u0007\u0011q_\u0001\u0007gfl'm\u001c7\t\u000f\t%G\b1\u0001\u0002\u0000\u0005Q\u0011n\u001d*fO&\u001cH/\u001a:\u0015\t\t\r!\u0011\u001e\u0005\b\u0005kk\u0004\u0019AAY\u0003A9W\r\u001e*fO&\u001cH/\u001a:OC6,7/A\u0007hKRLe\u000e];u!>\u0014Ho]\u0001\u000fO\u0016$x*\u001e;qkR\u0004vN\u001d;t\u0003-I7/\u00138qkR\u0004vN\u001d;\u0015\t\t\r!Q\u001f\u0005\b\u0005k\u000b\u0005\u0019AAY\u00031I7oT;uaV$\bk\u001c:u)\u0011\u0011\u0019Aa?\t\u000f\tU&\t1\u0001\u00022\u0006Qa/\u00197jI:\u000bW.Z:\u0016\u0005\r\u0005\u0001C\u0002B\u0017\u0007\u0007\t\t,\u0003\u0003\u0004\u0006\te\"\u0001C%uKJ\f'\r\\3\u0002\u000fMLXNY8mgV\u001111\u0002\t\u0007\u0005[\u0019\u0019!a>\u00021I,g-\u001a:f]\u000e,G+\u0019:hKR$vnU=nE>d7\u000f\u0006\u0003\u0004\u0012\rM\u0001C\u0002B\u0017\u0005k\t9\u0010C\u0004\u0004\u0016\u0015\u0003\raa\u0006\u0002\u001fI,g-\u001a:f]\u000e,G+\u0019:hKR\u0004Ba!\u0007\u0004 5\u001111\u0004\u0006\u0004\u0007;a\u0018aC1o]>$\u0018\r^5p]NLAa!\t\u0004\u001c\ty!+\u001a4fe\u0016t7-\u001a+be\u001e,G/A\bfm\u0006dW/\u0019;f\u0007&\u00148-^5u\u0003-\tGM^1oG\u0016$\u0016.\\3\u0015\t\u0005\u00056\u0011\u0006\u0005\b\u0007W9\u0005\u0019\u0001B\u000b\u0003%Ign\u0019:f[\u0016tG/A\u000bti>\u0004\b*\u00199qK:,GmU=nE>dw\n\u001d;\u0016\u0005\rE\u0002#B:\u0002\u000e\u0006]\u0018AF:u_BD\u0015\r\u001d9f]\u0016$7+_7c_2|\u0005\u000f\u001e\u0011\u0002#1\f7\u000f^*u_B,\u0005pY3qi&|g.\u0006\u0002\u0004:A)1/!$\u0004<A!\u0011qGB\u001f\u0013\r\u0019y\u0004\u001c\u0002\u000e'R|\u0007/\u0012=dKB$\u0018n\u001c8\u0002%Ad\u0015m\u001d;Ti>\u0004X\t_2faRLwN\\\u0001\u0017a2\u000b7\u000f^*u_B,\u0005pY3qi&|gn\u0018\u0013fcR!\u0011\u0011UB$\u0011%\tI\u000bTA\u0001\u0002\u0004\u0019I$A\nq\u0019\u0006\u001cHo\u0015;pa\u0016C8-\u001a9uS>t\u0007%A\u0004ti>\u0004\b/\u001a3\u0002\u001d1\f7\u000f^*u_B\u0014Vm];miV\u00111\u0011\u000b\t\u0006g\u00065\u0015qP\u0001\tC2d7\u000b^8qgV\u00111q\u000b\t\u0007\u0005[\u0019If!\u0018\n\t\rm#\u0011\b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00028\r}\u0013bAB1Y\nA1\u000b^8q\t\u0006$\u0018-\u0001\u0007bY2\u001cFo\u001c9t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u000e\u001d\u0004\"CAU#\u0006\u0005\t\u0019AB,\u0003%\tG\u000e\\*u_B\u001c\b%\u0001\u0005hKR\u001cFo\u001c9t+\t\u0019y\u0007\u0005\u0004\u0003.\tU2QL\u0001\re\u0016<\u0017n\u001d;feN#x\u000e\u001d\u000b\u0005\u0003C\u001b)\bC\u0004\u0004xQ\u0003\ra!\u0018\u0002\t\u0011\fG/Y\u0001\u0013M&tG\rV8q\u0019\u00164X\r\\\"m_\u000e\\7\u000f\u0006\u0002\u0004\u0012\u00051a-\u001b8jg\"$B!!)\u0004\u0002\"I11\u0011,\u0011\u0002\u0003\u0007!1A\u0001\u0014oJLG/Z\"pm\u0016\u0014\u0018mZ3SKB|'\u000f^\u0001\u0011M&t\u0017n\u001d5%I\u00164\u0017-\u001e7uIE\nABZ5fY\u0012\u001c\b*Z1eKJ\fa\u0001[3bI\u0016\u0014\u0018!\u00043bi\u0006LenQ8mk6t7/A\u0007hKRLeNZ8TiJLgnZ\u0001\u0010O\u0016$\bK]3uif\u001cFO]5oO\nY1\t\\8dWR{wm\u001a7f'\ti&/\u0001\u0004%S:LG\u000fJ\u0001\u000be\u0006L7/Z\"m_\u000e\\\u0017A\u00037po\u0016\u00148\t\\8dW\nYa*\u001e7m)><w\r\\3s'\u0011\t'oa(\u0011\u0007\r\u0005V,D\u0001\u0001)\t\u0019)\u000bE\u0002\u0004\"\u0006\fQ\"\\1lKV\u0003Hk\\4hY\u0016\u0014H\u0003BBV\u0007o\u0003Ba!,\u00042:!\u0011qGBX\u0013\r\t9\u0003\\\u0005\u0005\u0007g\u001b)L\u0001\u0005BgNLwM\\3s\u0015\r\t9\u0003\u001c\u0005\b\u0005C\u001c\u0007\u0019AA|\u0003=i\u0017m[3E_^tGk\\4hY\u0016\u0014H\u0003BBV\u0007{CqA!9e\u0001\u0004\t90A\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f!\r\t9DZ\n\u0004MJDHCABa\u0003-16\t\u0012%p_.t\u0015-\\3\u0016\u0005\r-\u0007\u0003BBg\u0007/l!aa4\u000b\t\rE71[\u0001\u0005Y\u0006twM\u0003\u0002\u0004V\u0006!!.\u0019<b\u0013\u0011\tila4\u0002\u0019Y\u001bE\tS8pW:\u000bW.\u001a\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u000554q\\Bq\u0011\u001d\t\u0019B\u001ba\u0001\u0003/Aq!a\u0016k\u0001\u0004\tY\u0006")
public class ExecutionEngine
implements LazyLogging {
    private final Circuit ast;
    private final Seq<Annotation> annotationSeq;
    private final SymbolTable symbolTable;
    private final DataStore dataStore;
    private final Scheduler scheduler;
    private final UTC wallTime;
    private final int cycleTimeIncrement;
    private Option<VCD> vcdOption;
    private String vcdFileName;
    private final String topName;
    private final StageOptions stageOptions;
    private final String generatedFileRoot;
    private final HashSet<Symbol> symbolsPokedSinceEvaluation;
    private boolean verbose;
    private final long userRandomSeed;
    private boolean inputsChanged;
    private final Seq<String> symbolsToWatch;
    private final Timer timer;
    private final MemoryInitializer memoryInitializer;
    private final Option<Symbol> stopHappenedSymbolOpt;
    private Option<StopException> pLastStopException;
    private List<StopData> allStops;
    private Logger logger;
    private volatile int bitmap$init$0;

    public static ExecutionEngine apply(Seq<Annotation> annotationSeq, UTC wallTime) {
        return ExecutionEngine$.MODULE$.apply(annotationSeq, wallTime);
    }

    public static String VCDHookName() {
        return ExecutionEngine$.MODULE$.VCDHookName();
    }

    public Logger getLogger() {
        return LazyLogging.getLogger$((LazyLogging)this);
    }

    public Logger logger() {
        if ((this.bitmap$init$0 & 0x10000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 23");
        }
        return this.logger;
    }

    public void firrtl2$logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
        this.bitmap$init$0 |= 0x10000;
    }

    public Circuit ast() {
        return this.ast;
    }

    public Seq<Annotation> annotationSeq() {
        return this.annotationSeq;
    }

    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    public DataStore dataStore() {
        return this.dataStore;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public UTC wallTime() {
        return this.wallTime;
    }

    public int cycleTimeIncrement() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 31");
        }
        return this.cycleTimeIncrement;
    }

    public Option<VCD> vcdOption() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 33");
        }
        return this.vcdOption;
    }

    public void vcdOption_$eq(Option<VCD> x$1) {
        this.vcdOption = x$1;
        this.bitmap$init$0 |= 2;
    }

    public String vcdFileName() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 34");
        }
        return this.vcdFileName;
    }

    public void vcdFileName_$eq(String x$1) {
        this.vcdFileName = x$1;
        this.bitmap$init$0 |= 4;
    }

    private String topName() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 37");
        }
        return this.topName;
    }

    private StageOptions stageOptions() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 38");
        }
        return this.stageOptions;
    }

    public String generatedFileRoot() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 39");
        }
        return this.generatedFileRoot;
    }

    public HashSet<Symbol> symbolsPokedSinceEvaluation() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 43");
        }
        return this.symbolsPokedSinceEvaluation;
    }

    public boolean verbose() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 45");
        }
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
        this.bitmap$init$0 |= 0x80;
    }

    public long userRandomSeed() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 48");
        }
        return this.userRandomSeed;
    }

    public boolean inputsChanged() {
        if ((this.bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 50");
        }
        return this.inputsChanged;
    }

    public void inputsChanged_$eq(boolean x$1) {
        this.inputsChanged = x$1;
        this.bitmap$init$0 |= 0x200;
    }

    public Seq<String> symbolsToWatch() {
        if ((this.bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 60");
        }
        return this.symbolsToWatch;
    }

    public void setLeanMode() {
        boolean canBeLean = !this.verbose() && !this.dataStore().hasEnabledPlugins();
        this.scheduler().setLeanMode(canBeLean);
        this.scheduler().setVerboseAssign(this.verbose());
    }

    public void setVerbose(boolean isVerbose) {
        this.verbose_$eq(isVerbose);
        this.setLeanMode();
        Option option = this.dataStore().plugins().get((Object)"show-assigns");
        if (option instanceof Some) {
            Some some = (Some)option;
            DataStorePlugin plugin = (DataStorePlugin)some.value();
            plugin.setEnabled(this.verbose());
        }
        this.scheduler().setVerboseAssign(isVerbose);
    }

    public boolean setVerbose$default$1() {
        return true;
    }

    public Timer timer() {
        if ((this.bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 95");
        }
        return this.timer;
    }

    public MemoryInitializer memoryInitializer() {
        if ((this.bitmap$init$0 & 0x1000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 111");
        }
        return this.memoryInitializer;
    }

    public void makeVCDLogger(String fileName, boolean showUnderscored, VcdMemoryLoggingController memoryLogger) {
        String x$1 = this.ast().main();
        boolean x$2 = showUnderscored;
        String x$3 = VCD$.MODULE$.apply$default$2();
        String x$4 = VCD$.MODULE$.apply$default$3();
        VCD vcd = VCD$.MODULE$.apply(x$1, x$3, x$4, x$2);
        this.symbolTable().instanceNames().foreach((Function1 & Serializable)name -> {
            ExecutionEngine.$anonfun$makeVCDLogger$1(vcd, name);
            return BoxedUnit.UNIT;
        });
        vcd.timeStamp_$eq(-1L);
        this.symbolTable().symbols().foreach((Function1 & Serializable)symbol -> {
            ExecutionEngine.$anonfun$makeVCDLogger$2(this, vcd, memoryLogger, symbol);
            return BoxedUnit.UNIT;
        });
        vcd.timeStamp_$eq(0L);
        this.vcdOption_$eq((Option<VCD>)new Some((Object)vcd));
        this.vcdFileName_$eq(fileName);
        VcdHook vcdPlugIn = new VcdHook(this, memoryLogger);
        this.dataStore().addPlugin(ExecutionEngine$.MODULE$.VCDHookName(), vcdPlugIn, true);
    }

    public VcdMemoryLoggingController makeVCDLogger$default$3() {
        return new VcdMemoryLoggingController(VcdMemoryLoggingController$.MODULE$.$lessinit$greater$default$1(), VcdMemoryLoggingController$.MODULE$.$lessinit$greater$default$2());
    }

    public void disableVCD() {
        this.writeVCD();
        this.vcdOption_$eq((Option<VCD>)None$.MODULE$);
        this.vcdFileName_$eq("");
        this.dataStore().removePlugin(ExecutionEngine$.MODULE$.VCDHookName());
    }

    public void writeVCD() {
        this.vcdOption().foreach((Function1 & Serializable)vcd -> {
            vcd.write(this.vcdFileName());
            return BoxedUnit.UNIT;
        });
    }

    public void randomize(long additonalSeed) {
        NameBasedRandomNumberGenerator randomGenerator = new NameBasedRandomNumberGenerator();
        Seq symbolsToDo = this.symbolTable().symbols().toSeq();
        symbolsToDo.foreach((Function1 & Serializable)symbol -> {
            Kind kind = symbol.dataKind();
            RegKind$ regKind$ = RegKind$.MODULE$;
            if (!(kind != null ? !kind.equals(regKind$) : regKind$ != null)) {
                BigInt newValue = this.getRandomValue$1(randomGenerator, (Symbol)symbol, additonalSeed);
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(12).append("setting ").append(symbol.name()).append(" <= ").append(newValue).toString());
                return this.setValue(symbol.name(), this.getRandomValue$1(randomGenerator, (Symbol)symbol, additonalSeed), this.setValue$default$3(), this.setValue$default$4(), this.setValue$default$5());
            }
            Kind kind2 = symbol.dataKind();
            MemKind$ memKind$ = MemKind$.MODULE$;
            if (!(kind2 != null ? !kind2.equals(memKind$) : memKind$ != null)) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), symbol.slots()).foreach((Function1 & Serializable)slot -> ExecutionEngine.$anonfun$randomize$3(this, symbol, randomGenerator, additonalSeed, BoxesRunTime.unboxToInt((Object)slot)));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.evaluateCircuit();
    }

    public long randomize$default$1() {
        return 0L;
    }

    private void runAssigns() {
        try {
            this.scheduler().executeCombinationalAssigns();
            Option<StopException> option = this.pLastStopException();
            if (option instanceof Some) {
                Some some = (Some)option;
                StopException exception = (StopException)some.value();
                this.pLastStopException_$eq((Option<StopException>)None$.MODULE$);
                throw exception;
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        catch (Throwable throwable) {
            this.writeVCD();
            throw throwable;
        }
    }

    public BigInt getValue(String name, int offset) {
        Predef$.MODULE$.assert(this.symbolTable().contains(name), (Function0 & Serializable)() -> new StringBuilder(64).append("Error: getValue(\"").append(name).append("\") : argument is not an element of this circuit").toString());
        if (this.inputsChanged()) {
            if (this.verbose()) {
                Render$.MODULE$.headerBar("peeking", 8, Render$.MODULE$.headerBar$default$3());
            }
            this.inputsChanged_$eq(false);
            this.runAssigns();
        }
        Symbol symbol = this.symbolTable().apply(name);
        if (offset == 0) {
            return symbol.normalize(this.dataStore().apply(symbol));
        }
        if (offset - 1 > symbol.slots()) {
            throw new TreadleException(new StringBuilder(36).append("get value from ").append(symbol.name()).append(" offset ").append(offset).append(" > than size ").append(symbol.slots()).toString());
        }
        return symbol.normalize(this.dataStore().getValueAtIndex(symbol.dataSize(), symbol.index() + offset));
    }

    public int getValue$default$2() {
        return 0;
    }

    public BigInt setValue(String name, BigInt value, boolean force, boolean registerPoke, int offset) {
        Growable growable;
        Symbol symbol = this.symbolTable().getOrElse(name, (Function0<Symbol>)(Function0 & Serializable)() -> {
            throw new TreadleException(new StringBuilder(38).append("setValue: Cannot find ").append(name).append(" in symbol table").toString());
        });
        this.inputsChanged_$eq(true);
        if (this.symbolsPokedSinceEvaluation().contains((Object)symbol)) {
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)"updating circuit on second update of same input without clock advance");
            }
            this.symbolsPokedSinceEvaluation().clear();
            this.scheduler().executeCombinationalAssigns();
            growable = BoxedUnit.UNIT;
        } else {
            growable = this.symbolsPokedSinceEvaluation().$plus$eq((Object)symbol);
        }
        if (!force) {
            Kind kind = symbol.dataKind();
            PortKind$ portKind$ = PortKind$.MODULE$;
            Predef$.MODULE$.assert(!(kind != null ? !kind.equals(portKind$) : portKind$ != null), (Function0 & Serializable)() -> new StringBuilder(70).append("Error: setValue(").append(name).append(") not on input, use setValue(").append(name).append(", force=true) to override").toString());
            return package$.MODULE$.Big0();
        }
        BigInt adjustedValue = symbol.valueFrom(value);
        if (offset == 0) {
            if (this.verbose()) {
                if (!this.inputsChanged()) {
                    Render$.MODULE$.headerBar("Poking", Render$.MODULE$.headerBar$default$2(), Render$.MODULE$.headerBar$default$3());
                }
                Predef$.MODULE$.println((Object)new StringBuilder(4).append(symbol.name()).append(" <= ").append(value).toString());
            }
            this.dataStore().update(symbol, adjustedValue);
            this.vcdOption().foreach((Function1 & Serializable)vcd -> BoxesRunTime.boxToBoolean((boolean)vcd.wireChanged(symbol.name(), adjustedValue, symbol.bitWidth())));
        } else {
            if (offset - 1 > symbol.slots()) {
                throw new TreadleException(new StringBuilder(36).append("get value from ").append(symbol.name()).append(" offset ").append(offset).append(" > than size ").append(symbol.slots()).toString());
            }
            if (this.verbose()) {
                if (!this.inputsChanged()) {
                    Render$.MODULE$.headerBar("Poking", Render$.MODULE$.headerBar$default$2(), Render$.MODULE$.headerBar$default$3());
                }
                Predef$.MODULE$.println((Object)new StringBuilder(18).append(symbol.name()).append("(").append(offset).append(") <= ").append(value).append(" from tester").toString());
            }
            this.dataStore().setValueAtIndex(symbol.dataSize(), symbol.index() + offset, value);
        }
        return value;
    }

    public boolean setValue$default$3() {
        return true;
    }

    public boolean setValue$default$4() {
        return false;
    }

    public int setValue$default$5() {
        return 0;
    }

    public int setIntValue(Symbol symbol, int value) {
        Growable growable;
        this.inputsChanged_$eq(true);
        if (this.symbolsPokedSinceEvaluation().contains((Object)symbol)) {
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)"updating circuit on second update of same input without clock advance");
            }
            this.symbolsPokedSinceEvaluation().clear();
            this.scheduler().executeCombinationalAssigns();
            growable = BoxedUnit.UNIT;
        } else {
            growable = this.symbolsPokedSinceEvaluation().$plus$eq((Object)symbol);
        }
        BigInt adjustedValue = symbol.valueFrom(BigInt$.MODULE$.int2bigInt(value));
        if (this.verbose()) {
            if (!this.inputsChanged()) {
                Render$.MODULE$.headerBar("Poking", Render$.MODULE$.headerBar$default$2(), Render$.MODULE$.headerBar$default$3());
            }
            Predef$.MODULE$.println((Object)new StringBuilder(4).append(symbol.name()).append(" <= ").append(value).toString());
        }
        this.dataStore().intData()[symbol.index()] = value;
        this.vcdOption().foreach((Function1 & Serializable)vcd -> BoxesRunTime.boxToBoolean((boolean)vcd.wireChanged(symbol.name(), adjustedValue, symbol.bitWidth())));
        return value;
    }

    public boolean isRegister(String name) {
        return this.symbolTable().registerNames().contains((Object)name);
    }

    public Seq<String> getRegisterNames() {
        return this.symbolTable().registerNames().toSeq();
    }

    public Seq<String> getInputPorts() {
        return this.symbolTable().inputPortsNames().toSeq();
    }

    public Seq<String> getOutputPorts() {
        return this.symbolTable().outputPortsNames().toSeq();
    }

    public boolean isInputPort(String name) {
        return this.symbolTable().inputPortsNames().contains((Object)name);
    }

    public boolean isOutputPort(String name) {
        return this.symbolTable().outputPortsNames().contains((Object)name);
    }

    public Iterable<String> validNames() {
        return this.symbolTable().keys();
    }

    public Iterable<Symbol> symbols() {
        return this.symbolTable().symbols();
    }

    public Seq<Symbol> referenceTargetToSymbols(ReferenceTarget referenceTarget) {
        if (referenceTarget.path().nonEmpty()) {
            String pathName = ((IterableOnceOps)referenceTarget.path().map((Function1 & Serializable)x0$1 -> {
                TargetToken.Instance instance;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null && (instance = (TargetToken.Instance)tuple2._1()) != null) {
                    String name = instance.value();
                    return name;
                }
                throw new MatchError((Object)tuple2);
            })).mkString(".");
            Seq symbols = ((IterableOnceOps)this.symbolTable().instanceNameToModuleName().flatMap((Function1 & Serializable)x0$2 -> {
                String instanceName;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null && (instanceName = (String)tuple2._1()).endsWith(pathName)) {
                    String symbolName = new StringBuilder(1).append(instanceName).append(".").append(referenceTarget.ref()).toString();
                    return this.symbolTable().get(symbolName);
                }
                return None$.MODULE$;
            })).toSeq();
            return symbols;
        }
        String string = referenceTarget.module();
        String string2 = this.ast().main();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Option<Symbol> option = this.symbolTable().get(referenceTarget.ref());
            if (option instanceof Some) {
                Some some = (Some)option;
                Symbol symbol = (Symbol)some.value();
                return new .colon.colon((Object)symbol, (List)Nil$.MODULE$);
            }
            return (Seq)scala.package$.MODULE$.Seq().empty();
        }
        String string3 = referenceTarget.module();
        String string4 = this.ast().main();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            String targetModule = String.valueOf(referenceTarget.module());
            return ((IterableOnceOps)this.symbolTable().instanceNameToModuleName().flatMap((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String moduleName;
                    String instance = (String)tuple2._1();
                    String string = moduleName = (String)tuple2._2();
                    String string2 = targetModule;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String name = new StringBuilder(1).append(instance).append(".").append(referenceTarget.ref()).toString();
                        return this.symbolTable().get(name);
                    }
                }
                return None$.MODULE$;
            })).toSeq();
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public void evaluateCircuit() {
        if (this.inputsChanged()) {
            this.inputsChanged_$eq(false);
            this.symbolsPokedSinceEvaluation().clear();
            if (this.verbose()) {
                Render$.MODULE$.headerBar("combinational evaluate", 8, Render$.MODULE$.headerBar$default$3());
            }
            this.runAssigns();
            if (this.verbose()) {
                Render$.MODULE$.headerBar("done combinational evaluate", 8, Render$.MODULE$.headerBar$default$3());
                return;
            }
            return;
        }
    }

    public void advanceTime(long increment) {
        if (increment > 0L) {
            if (this.inputsChanged()) {
                this.evaluateCircuit();
                return;
            }
            return;
        }
    }

    private Option<Symbol> stopHappenedSymbolOpt() {
        if ((this.bitmap$init$0 & 0x2000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 434");
        }
        return this.stopHappenedSymbolOpt;
    }

    public Option<StopException> lastStopException() {
        return this.pLastStopException();
    }

    private Option<StopException> pLastStopException() {
        if ((this.bitmap$init$0 & 0x4000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 442");
        }
        return this.pLastStopException;
    }

    private void pLastStopException_$eq(Option<StopException> x$1) {
        this.pLastStopException = x$1;
        this.bitmap$init$0 |= 0x4000;
    }

    public boolean stopped() {
        return this.allStops().nonEmpty();
    }

    public Option<Object> lastStopResult() {
        return this.allStops().headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.ret()));
    }

    private List<StopData> allStops() {
        if ((this.bitmap$init$0 & 0x8000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ExecutionEngine.scala: 450");
        }
        return this.allStops;
    }

    private void allStops_$eq(List<StopData> x$1) {
        this.allStops = x$1;
        this.bitmap$init$0 |= 0x8000;
    }

    public Seq<StopData> getStops() {
        return this.allStops();
    }

    public void registerStop(StopData data) {
        StopException stopException;
        Option<StopException> option = this.lastStopException();
        if (option instanceof Some) {
            Some some = (Some)option;
            StopException e = (StopException)some.value();
            stopException = e.copy((Seq<StopData>)((Seq)e.stops().$colon$plus((Object)data)));
        } else if (None$.MODULE$.equals(option)) {
            stopException = new StopException((Seq<StopData>)new .colon.colon((Object)data, (List)Nil$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        StopException except = stopException;
        this.allStops_$eq((List<StopData>)((List)this.allStops().$colon$plus((Object)data)));
        this.pLastStopException_$eq((Option<StopException>)new Some((Object)except));
    }

    public Seq<Symbol> findTopLevelClocks() {
        Iterable inputs = (Iterable)this.symbolTable().symbols().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$findTopLevelClocks$1(this, s)));
        return ((IterableOnceOps)inputs.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$findTopLevelClocks$2(x$2)))).toList();
    }

    public void finish(boolean writeCoverageReport) {
        this.symbols().foreach((Function1 & Serializable)symbol -> {
            ExecutionEngine.$anonfun$finish$1(this, symbol);
            return BoxedUnit.UNIT;
        });
        if (writeCoverageReport && this.symbolTable().verifyOps().nonEmpty()) {
            String text = ((IterableOnceOps)((SeqOps)this.symbolTable().verifyOps().map((Function1 & Serializable)verifyOp -> new StringBuilder(3).append(verifyOp.info().toString().trim()).append(",").append(verifyOp.message().escape()).append(",").append(verifyOp.clockCount()).append(",").append(verifyOp.coverCount()).toString())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
            PrintWriter writer = new PrintWriter(new File(new StringBuilder(13).append(this.generatedFileRoot()).append(".coverage.txt").toString()));
            writer.write(text);
            writer.close();
            return;
        }
    }

    public boolean finish$default$1() {
        return false;
    }

    public String fieldsHeader() {
        return new StringBuilder(4).append("Buf ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])this.symbolTable().keys().toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)name -> {
            String s = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(name), 9);
            return StringOps$.MODULE$.format$extension("%10.10s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s}));
        }, ClassTag$.MODULE$.apply(String.class))).mkString("")).toString();
    }

    public String header() {
        return this.fieldsHeader();
    }

    public String dataInColumns() {
        String[] keys = (String[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])this.symbolTable().keys().toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$);
        return new StringBuilder(2).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), this.fieldsHeader().length())).append("\n").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])keys), (Function1 & Serializable)name -> {
            Symbol symbol = this.symbolTable().apply((String)name);
            BigInt value = symbol.normalize(this.dataStore().apply(this.symbolTable().apply((String)name)));
            return StringOps$.MODULE$.format$extension(" %9.9s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value}));
        }, ClassTag$.MODULE$.apply(String.class))).mkString("")).append("\n").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), this.fieldsHeader().length())).toString();
    }

    public String getInfoString() {
        return "Info";
    }

    public String getPrettyString() {
        return new StringBuilder(1).append(this.header()).append("\n").append(this.dataInColumns()).toString();
    }

    public package.Assigner makeUpToggler(Symbol symbol) {
        GetIntConstant getIntConstant = new GetIntConstant(1);
        DataStore.AssignInt assigner = new DataStore.AssignInt(this.dataStore(), symbol, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> getIntConstant.apply(), (Info)NoInfo$.MODULE$);
        if (this.vcdOption().isDefined()) {
            assigner.setLeanMode(false);
        }
        assigner.setVerbose(this.verbose());
        return assigner;
    }

    public package.Assigner makeDownToggler(Symbol symbol) {
        GetIntConstant getIntConstant = new GetIntConstant(0);
        DataStore.AssignInt assigner = new DataStore.AssignInt(this.dataStore(), symbol, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> getIntConstant.apply(), (Info)NoInfo$.MODULE$);
        if (this.vcdOption().isDefined()) {
            assigner.setLeanMode(false);
        }
        assigner.setVerbose(this.verbose());
        return assigner;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Annotation x0$1) {
        Annotation annotation = x0$1;
        return VerboseAnnotation$.MODULE$.equals(annotation);
    }

    public static final /* synthetic */ void $anonfun$new$2(ExecutionEngine $this, DataStorePlugInAnnotation a) {
        $this.dataStore().addPlugin(a.name(), (DataStorePlugin)a.getPlugin().apply((Object)$this), true);
    }

    public static final /* synthetic */ void $anonfun$makeVCDLogger$1(VCD vcd$1, String name) {
        vcd$1.scopeRoot().addScope(name);
    }

    public static final /* synthetic */ void $anonfun$makeVCDLogger$2(ExecutionEngine $this, VCD vcd$1, VcdMemoryLoggingController memoryLogger$1, Symbol symbol) {
        vcd$1.wireChanged(symbol.name(), $this.dataStore().apply(symbol), symbol.bitWidth());
        Kind kind = symbol.dataKind();
        MemKind$ memKind$ = MemKind$.MODULE$;
        if (!(kind != null ? !kind.equals(memKind$) : memKind$ != null)) {
            memoryLogger$1.getIndexedNames(symbol).foreach((Function1 & Serializable)indexedMemName -> BoxesRunTime.boxToBoolean((boolean)vcd$1.wireChanged(indexedMemName, BigInt$.MODULE$.int2bigInt(0), symbol.bitWidth())));
            return;
        }
    }

    private final BigInt getRandomValue$1(NameBasedRandomNumberGenerator randomGenerator$1, Symbol symbol$2, long additonalSeed$1) {
        BigInt big = randomGenerator$1.nextBigInt(symbol$2.name(), this.userRandomSeed() + additonalSeed$1, symbol$2.bitWidth());
        DataType dataType = symbol$2.dataType();
        SignedInt$ signedInt$ = SignedInt$.MODULE$;
        BigInt newValue = !(dataType != null ? !dataType.equals(signedInt$) : signedInt$ != null) ? symbol$2.makeSInt(big, symbol$2.bitWidth()) : symbol$2.makeUInt(big, symbol$2.bitWidth());
        return newValue;
    }

    public static final /* synthetic */ BigInt $anonfun$randomize$3(ExecutionEngine $this, Symbol symbol$2, NameBasedRandomNumberGenerator randomGenerator$1, long additonalSeed$1, int slot) {
        BigInt newValue = $this.getRandomValue$1(randomGenerator$1, symbol$2, additonalSeed$1);
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(14).append("setting ").append(symbol$2.name()).append("(").append(slot).append(") <= ").append(newValue).toString());
        String x$1 = symbol$2.name();
        BigInt x$2 = $this.getRandomValue$1(randomGenerator$1, symbol$2, additonalSeed$1);
        int x$3 = slot;
        boolean x$4 = $this.setValue$default$3();
        boolean x$5 = $this.setValue$default$4();
        return $this.setValue(x$1, x$2, x$4, x$5, x$3);
    }

    public static final /* synthetic */ boolean $anonfun$findTopLevelClocks$1(ExecutionEngine $this, Symbol s) {
        return $this.symbolTable().isTopLevelInput(s.name());
    }

    public static final /* synthetic */ boolean $anonfun$findTopLevelClocks$2(Symbol x$2) {
        Type type = x$2.firrtlType();
        ClockType$ clockType$ = ClockType$.MODULE$;
        return !(type != null ? !type.equals(clockType$) : clockType$ != null);
    }

    public static final /* synthetic */ void $anonfun$finish$1(ExecutionEngine $this, Symbol symbol) {
        $this.symbolTable().getBlackboxImplementation(symbol).foreach((Function1 & Serializable)blackBox -> {
            blackBox.finish();
            return BoxedUnit.UNIT;
        });
    }

    public ExecutionEngine(Circuit ast, Seq<Annotation> annotationSeq, SymbolTable symbolTable, DataStore dataStore, Scheduler scheduler, UTC wallTime) {
        this.ast = ast;
        this.annotationSeq = annotationSeq;
        this.symbolTable = symbolTable;
        this.dataStore = dataStore;
        this.scheduler = scheduler;
        this.wallTime = wallTime;
        LazyLogging.$init$((LazyLogging)this);
        this.cycleTimeIncrement = 500;
        this.bitmap$init$0 |= 1;
        this.vcdOption = None$.MODULE$;
        this.bitmap$init$0 |= 2;
        this.vcdFileName = "";
        this.bitmap$init$0 |= 4;
        this.topName = (String)annotationSeq.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof OutputFileAnnotation) {
                    OutputFileAnnotation outputFileAnnotation = (OutputFileAnnotation)A1;
                    String ofn = outputFileAnnotation.file();
                    return (B1)ofn;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Annotation x1) {
                Annotation annotation = x1;
                return annotation instanceof OutputFileAnnotation;
            }
        }).getOrElse((Function0 & Serializable)() -> this.ast().main());
        this.bitmap$init$0 |= 8;
        this.stageOptions = (StageOptions)Viewer$.MODULE$.view(annotationSeq, (OptionsView)package.StageOptionsView$.MODULE$);
        this.bitmap$init$0 |= 0x10;
        this.generatedFileRoot = this.stageOptions().getBuildFileName(this.topName(), this.stageOptions().getBuildFileName$default$2());
        this.bitmap$init$0 |= 0x20;
        scheduler.executionEngineOpt_$eq((Option<ExecutionEngine>)new Some((Object)this));
        this.symbolsPokedSinceEvaluation = new HashSet();
        this.bitmap$init$0 |= 0x40;
        this.verbose = false;
        this.bitmap$init$0 |= 0x80;
        this.setVerbose(annotationSeq.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$new$1(x0$1))));
        this.userRandomSeed = BoxesRunTime.unboxToLong((Object)annotationSeq.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof RandomSeedAnnotation) {
                    RandomSeedAnnotation randomSeedAnnotation = (RandomSeedAnnotation)A1;
                    long seed = randomSeedAnnotation.seed();
                    return (B1)BoxesRunTime.boxToLong((long)seed);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Annotation x2) {
                Annotation annotation = x2;
                return annotation instanceof RandomSeedAnnotation;
            }
        }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.bitmap$init$0 |= 0x100;
        this.inputsChanged = false;
        this.bitmap$init$0 |= 0x200;
        dataStore.addPlugin("show-assigns", new ReportAssignments(this), this.verbose());
        this.symbolsToWatch = (Seq)annotationSeq.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof SymbolsToWatchAnnotation) {
                    SymbolsToWatchAnnotation symbolsToWatchAnnotation = (SymbolsToWatchAnnotation)A1;
                    Seq<String> stw = symbolsToWatchAnnotation.symbolNames();
                    return (B1)stw;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Annotation x3) {
                Annotation annotation = x3;
                return annotation instanceof SymbolsToWatchAnnotation;
            }
        }).getOrElse((Function0 & Serializable)() -> (Seq)scala.package$.MODULE$.Seq().empty());
        this.bitmap$init$0 |= 0x400;
        dataStore.addPlugin("show-computation", new RenderComputations(this, this.symbolsToWatch()), this.symbolsToWatch().nonEmpty());
        ((IterableOnceOps)annotationSeq.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Annotation, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                if (A1 instanceof DataStorePlugInAnnotation) {
                    DataStorePlugInAnnotation dataStorePlugInAnnotation = (DataStorePlugInAnnotation)A1;
                    return (B1)dataStorePlugInAnnotation;
                }
                return (B1)function1.apply(x4);
            }

            public final boolean isDefinedAt(Annotation x4) {
                Annotation annotation = x4;
                return annotation instanceof DataStorePlugInAnnotation;
            }
        })).foreach((Function1 & Serializable)a -> {
            ExecutionEngine.$anonfun$new$2(this, a);
            return BoxedUnit.UNIT;
        });
        this.timer = new Timer();
        this.bitmap$init$0 |= 0x800;
        if (this.verbose()) {
            if (scheduler.orphanedAssigns().nonEmpty()) {
                Render$.MODULE$.headerBar("Executing static assignments", 8, Render$.MODULE$.headerBar$default$3());
            } else {
                Render$.MODULE$.headerBar("No static assignments", 8, Render$.MODULE$.headerBar$default$3());
            }
        }
        scheduler.executeOrphanedAssigns();
        if (this.verbose() && scheduler.orphanedAssigns().nonEmpty()) {
            Render$.MODULE$.headerBar("Finished executing static assignments", 8, Render$.MODULE$.headerBar$default$3());
        }
        this.memoryInitializer = new MemoryInitializer(this);
        this.bitmap$init$0 |= 0x1000;
        this.stopHappenedSymbolOpt = symbolTable.get(StopOp$.MODULE$.stopHappenedName());
        this.bitmap$init$0 |= 0x2000;
        this.pLastStopException = None$.MODULE$;
        this.bitmap$init$0 |= 0x4000;
        this.allStops = Nil$.MODULE$;
        this.bitmap$init$0 |= 0x8000;
        if (annotationSeq.contains((Object)RandomizeAtStartupAnnotation$.MODULE$)) {
            this.randomize(this.randomize$default$1());
        }
        Statics.releaseFence();
    }

    public interface ClockToggle {
        default public void raiseClock() {
        }

        default public void lowerClock() {
        }

        public /* synthetic */ ExecutionEngine treadle2$executable$ExecutionEngine$ClockToggle$$$outer();

        public static void $init$(ClockToggle $this) {
        }
    }

    public class NullToggler
    implements ClockToggle {
        @Override
        public void raiseClock() {
            ((ClockToggle)this).raiseClock();
        }

        @Override
        public void lowerClock() {
            ((ClockToggle)this).lowerClock();
        }

        public /* synthetic */ ExecutionEngine treadle2$executable$ExecutionEngine$NullToggler$$$outer() {
            return ExecutionEngine.this;
        }

        @Override
        public /* synthetic */ ExecutionEngine treadle2$executable$ExecutionEngine$ClockToggle$$$outer() {
            return this.treadle2$executable$ExecutionEngine$NullToggler$$$outer();
        }

        public NullToggler() {
            if (ExecutionEngine.this == null) {
                throw null;
            }
            ClockToggle.$init$(this);
        }
    }
}

