/*
 * Decompiled with CFR 0.152.
 */
package treadle2.executable;

import firrtl2.InstanceKind$;
import firrtl2.Kind;
import firrtl2.NodeKind$;
import firrtl2.PortKind$;
import firrtl2.RegKind$;
import firrtl2.WDefInstance$;
import firrtl2.WireKind$;
import firrtl2.graph.CyclicException;
import firrtl2.ir.AsyncResetType$;
import firrtl2.ir.Block;
import firrtl2.ir.Circuit;
import firrtl2.ir.ClockType$;
import firrtl2.ir.Conditionally;
import firrtl2.ir.Connect;
import firrtl2.ir.DefInstance;
import firrtl2.ir.DefMemory;
import firrtl2.ir.DefModule;
import firrtl2.ir.DefNode;
import firrtl2.ir.DefRegister;
import firrtl2.ir.DefWire;
import firrtl2.ir.Direction;
import firrtl2.ir.DoPrim;
import firrtl2.ir.EmptyStmt$;
import firrtl2.ir.Expression;
import firrtl2.ir.ExtModule;
import firrtl2.ir.Formal$;
import firrtl2.ir.Info;
import firrtl2.ir.Input$;
import firrtl2.ir.IntWidth$;
import firrtl2.ir.IsInvalid;
import firrtl2.ir.Module;
import firrtl2.ir.Mux;
import firrtl2.ir.NoInfo$;
import firrtl2.ir.Output$;
import firrtl2.ir.Port;
import firrtl2.ir.Print;
import firrtl2.ir.Reference;
import firrtl2.ir.SIntLiteral;
import firrtl2.ir.Statement;
import firrtl2.ir.Stop;
import firrtl2.ir.SubField;
import firrtl2.ir.SubIndex;
import firrtl2.ir.Type;
import firrtl2.ir.UIntLiteral;
import firrtl2.ir.UIntType;
import firrtl2.ir.ValidIf;
import firrtl2.ir.Verification;
import firrtl2.ir.Width;
import firrtl2.logger.LazyLogging;
import firrtl2.logger.Logger;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import treadle2.ScalaBlackBox;
import treadle2.ScalaBlackBoxFactory;
import treadle2.executable.IntSize$;
import treadle2.executable.Memory$;
import treadle2.executable.PrintInfo;
import treadle2.executable.SensitivityGraphBuilder;
import treadle2.executable.StopInfo;
import treadle2.executable.StopOp$;
import treadle2.executable.Symbol;
import treadle2.executable.Symbol$;
import treadle2.executable.SymbolTable;
import treadle2.executable.TreadleException;
import treadle2.executable.UnsignedInt$;
import treadle2.executable.VerifyInfo;
import treadle2.utils.FindModule$;

public final class SymbolTable$
implements LazyLogging {
    public static final SymbolTable$ MODULE$ = new SymbolTable$();
    private static final String RegisterInputSuffix;
    private static final String LastValueSuffix;
    private static final String PrevSuffix;
    private static Logger logger;
    private static volatile byte bitmap$init$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        RegisterInputSuffix = "/in";
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        LastValueSuffix = "/last";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        PrevSuffix = "/prev";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    public Logger getLogger() {
        return LazyLogging.getLogger$((LazyLogging)this);
    }

    public Logger logger() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: SymbolTable.scala: 141");
        }
        return logger;
    }

    public void firrtl2$logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    public String RegisterInputSuffix() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: SymbolTable.scala: 143");
        }
        return RegisterInputSuffix;
    }

    public String LastValueSuffix() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: SymbolTable.scala: 144");
        }
        return LastValueSuffix;
    }

    public String PrevSuffix() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: SymbolTable.scala: 145");
        }
        return PrevSuffix;
    }

    public String makeRegisterInputName(String name) {
        return new StringBuilder(0).append(name).append(this.RegisterInputSuffix()).toString();
    }

    public String makeRegisterInputName(Symbol symbol) {
        return new StringBuilder(0).append(symbol.name()).append(this.RegisterInputSuffix()).toString();
    }

    public Symbol makeRegisterInputSymbol(Symbol symbol) {
        String x$1 = this.makeRegisterInputName(symbol);
        Type x$2 = symbol.firrtlType();
        RegKind$ x$3 = RegKind$.MODULE$;
        Info x$4 = symbol.info();
        int x$5 = Symbol$.MODULE$.apply$default$4();
        return Symbol$.MODULE$.apply(x$1, x$2, (Kind)x$3, x$5, x$4);
    }

    public String makeLastValueName(String name) {
        return new StringBuilder(0).append(name).append(this.LastValueSuffix()).toString();
    }

    public String makeLastValueName(Symbol symbol) {
        return new StringBuilder(0).append(symbol.name()).append(this.LastValueSuffix()).toString();
    }

    public String makePreviousValue(String name) {
        return new StringBuilder(0).append(name).append(this.PrevSuffix()).toString();
    }

    public String makePreviousValue(Symbol symbol) {
        return new StringBuilder(0).append(symbol.name()).append(this.PrevSuffix()).toString();
    }

    public Symbol makeLastValueSymbol(Symbol symbol) {
        return Symbol$.MODULE$.apply(this.makeLastValueName(symbol), (Type)new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), Symbol$.MODULE$.apply$default$3(), Symbol$.MODULE$.apply$default$4(), Symbol$.MODULE$.apply$default$5());
    }

    public SymbolTable apply(HashMap<String, Symbol> nameToSymbol) {
        return new SymbolTable(nameToSymbol);
    }

    public SymbolTable apply(Circuit circuit, Seq<ScalaBlackBoxFactory> blackBoxFactories, boolean allowCycles) {
        Seq seq;
        HashMap nameToSymbol = new HashMap();
        SensitivityGraphBuilder sensitivityGraphBuilder = new SensitivityGraphBuilder();
        HashSet instanceNames = new HashSet();
        HashSet registerNames = new HashSet();
        HashSet inputPorts = new HashSet();
        HashSet outputPorts = new HashSet();
        HashSet clockSignals = new HashSet();
        HashMap registerToClock = new HashMap();
        HashMap stopToStopInfo = new HashMap();
        HashMap instanceNameToModuleName = new HashMap();
        instanceNameToModuleName.update((Object)"", (Object)circuit.main());
        HashMap lastStopSymbol = new HashMap();
        HashMap printToPrintInfo = new HashMap();
        IntRef printfCardinal = IntRef.create((int)0);
        HashMap lastPrintfInModule = new HashMap();
        HashMap verifyInfo = new HashMap();
        IntRef verifyCardinal = IntRef.create((int)0);
        HashMap lastVerifyInModule = new HashMap();
        HashMap moduleMemoryToMemorySymbol = new HashMap();
        HashMap blackBoxImplementations = new HashMap();
        DefModule defModule = FindModule$.MODULE$.apply(circuit.main(), circuit);
        if (!(defModule instanceof Module)) {
            if (defModule instanceof ExtModule) {
                ExtModule extModule = (ExtModule)defModule;
                throw new TreadleException(new StringBuilder(42).append("Top level module must be a regular module ").append(extModule).toString());
            }
            throw new TreadleException(new StringBuilder(49).append("Top level module is not the right kind of module ").append(defModule).toString());
        }
        Module module = (Module)defModule;
        Module module2 = module;
        this.logger().trace((Function0 & Serializable)() -> "Build SymbolTable pass 1 -- gather starting");
        this.processModule$1("", (DefModule)module2, inputPorts, outputPorts, clockSignals, blackBoxFactories, nameToSymbol, registerNames, instanceNames, instanceNameToModuleName, circuit, blackBoxImplementations, registerToClock, sensitivityGraphBuilder, moduleMemoryToMemorySymbol, stopToStopInfo, lastStopSymbol, printfCardinal, printToPrintInfo, lastPrintfInModule, verifyCardinal, verifyInfo, lastVerifyInModule);
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(59).append("Build SymbolTable pass 1 -- gather complete: ").append(nameToSymbol.size()).append(" entries found").toString());
        SymbolTable symbolTable = this.apply((HashMap<String, Symbol>)nameToSymbol);
        symbolTable.instanceNames().$plus$plus$eq((IterableOnce)instanceNames);
        symbolTable.instanceNameToModuleName().$plus$plus$eq((IterableOnce)instanceNameToModuleName);
        symbolTable.registerNames().$plus$plus$eq((IterableOnce)registerNames);
        symbolTable.inputPortsNames().$plus$plus$eq((IterableOnce)inputPorts);
        symbolTable.outputPortsNames().$plus$plus$eq((IterableOnce)outputPorts);
        symbolTable.treadle2$executable$SymbolTable$$toBlackBoxImplementation().$plus$plus$eq((IterableOnce)blackBoxImplementations);
        symbolTable.registerToClock().$plus$plus$eq((IterableOnce)registerToClock);
        symbolTable.stopToStopInfo().$plus$plus$eq((IterableOnce)stopToStopInfo);
        symbolTable.printToPrintInfo().$plus$plus$eq((IterableOnce)printToPrintInfo);
        symbolTable.verifyInfo().$plus$plus$eq((IterableOnce)verifyInfo);
        symbolTable.parentsOf_$eq(sensitivityGraphBuilder.getParentsOfDiGraph());
        symbolTable.childrenOf_$eq(sensitivityGraphBuilder.getChildrenOfDiGraph());
        symbolTable.moduleMemoryToMemorySymbol().$plus$plus$eq((IterableOnce)moduleMemoryToMemorySymbol);
        try {
            seq = symbolTable.childrenOf().linearize();
        }
        catch (CyclicException e) {
            Symbol badNode = (Symbol)e.node();
            Predef$.MODULE$.println((Object)new StringBuilder(31).append("Combinational loop detected at ").append(badNode).toString());
            if (allowCycles) {
                seq = symbolTable.symbols().toSeq();
            }
            SymbolTable$.showLoop$1(badNode, symbolTable);
            throw e;
        }
        catch (Throwable t) {
            throw t;
        }
        Seq sorted = seq;
        this.logger().trace((Function0 & Serializable)() -> "Build SymbolTable pass 2 -- linearize complete");
        ((IterableOnceOps)sorted.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SymbolTable$.$anonfun$apply$35(x0$1);
            return BoxedUnit.UNIT;
        });
        this.logger().trace((Function0 & Serializable)() -> "Build SymbolTable pass 3 -- sort complete");
        symbolTable.orphans_$eq(sensitivityGraphBuilder.orphans(symbolTable));
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(78).append("Build Symbol table pass 4 -- find sources. ").append(symbolTable.orphans().length()).append(" non-input non-register sinks found").toString());
        this.logger().info((Function0 & Serializable)() -> "SymbolTable is built");
        return symbolTable;
    }

    public Seq<ScalaBlackBoxFactory> apply$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean apply$default$3() {
        return false;
    }

    private static final void addSymbol$1(Symbol symbol, HashMap nameToSymbol$1) {
        if (nameToSymbol$1.contains((Object)symbol.name())) {
            throw new TreadleException(new StringBuilder(41).append("Symbol table attempting to re-add symbol ").append(symbol).toString());
        }
        nameToSymbol$1.update((Object)symbol.name(), (Object)symbol);
    }

    private static final void addDependency$1(Symbol sensitiveSymbol, Set drivingSymbols, SensitivityGraphBuilder sensitivityGraphBuilder$1) {
        drivingSymbols.foreach((Function1 & Serializable)drivingSymbol -> {
            sensitivityGraphBuilder$1.addSensitivity(drivingSymbol, sensitiveSymbol);
            return BoxedUnit.UNIT;
        });
    }

    private static final String expand$1(String name, String modulePrefix$1) {
        if (modulePrefix$1.isEmpty()) {
            return name;
        }
        return new StringBuilder(1).append(modulePrefix$1).append(".").append(name).toString();
    }

    private static final Set expressionToReferences$1(Expression expression, HashMap nameToSymbol$1, String modulePrefix$1) {
        Set set;
        Expression expression2 = expression;
        if (expression2 instanceof Mux) {
            Mux mux = (Mux)expression2;
            Expression condition = mux.cond();
            Expression trueExpression = mux.tval();
            Expression falseExpression = mux.fval();
            set = (Set)SymbolTable$.expressionToReferences$1(condition, nameToSymbol$1, modulePrefix$1).$plus$plus((IterableOnce)SymbolTable$.expressionToReferences$1(trueExpression, nameToSymbol$1, modulePrefix$1)).$plus$plus((IterableOnce)SymbolTable$.expressionToReferences$1(falseExpression, nameToSymbol$1, modulePrefix$1));
        } else if (expression2 instanceof Reference ? true : (expression2 instanceof SubField ? true : expression2 instanceof SubIndex)) {
            String name = SymbolTable$.expand$1(expression.serialize(), modulePrefix$1);
            set = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{(Symbol)nameToSymbol$1.apply((Object)name)}));
        } else if (expression2 instanceof ValidIf) {
            ValidIf validIf = (ValidIf)expression2;
            Expression condition = validIf.cond();
            Expression value = validIf.value();
            set = (Set)SymbolTable$.expressionToReferences$1(condition, nameToSymbol$1, modulePrefix$1).$plus$plus((IterableOnce)SymbolTable$.expressionToReferences$1(value, nameToSymbol$1, modulePrefix$1));
        } else if (expression2 instanceof DoPrim) {
            DoPrim doPrim = (DoPrim)expression2;
            Seq args = doPrim.args();
            set = (Set)args.foldLeft((Object)Set$.MODULE$.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Set accum = (Set)tuple2._1();
                    Expression expr = (Expression)tuple2._2();
                    return (Set)accum.$plus$plus((IterableOnce)SymbolTable$.expressionToReferences$1(expr, nameToSymbol$1, modulePrefix$1));
                }
                throw new MatchError((Object)tuple2);
            });
        } else if (expression2 instanceof UIntLiteral ? true : expression2 instanceof SIntLiteral) {
            set = Set$.MODULE$.empty();
        } else {
            throw new Exception(new StringBuilder(51).append("expressionToReferences:error: unhandled expression ").append(expression).toString());
        }
        Set result = set;
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Symbol symbol) {
        Type type = symbol.firrtlType();
        ClockType$ clockType$ = ClockType$.MODULE$;
        return !(type != null ? !type.equals(clockType$) : clockType$ != null);
    }

    private static final Option getClockSymbol$1(Expression expression, HashMap nameToSymbol$1, String modulePrefix$1) {
        Set references = SymbolTable$.expressionToReferences$1(expression, nameToSymbol$1, modulePrefix$1);
        Set clocks = (Set)references.filter((Function1 & Serializable)symbol -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$3(symbol)));
        return clocks.headOption();
    }

    private final void createPrevClock$1(String clockName, Type tpe, Info info, HashSet clockSignals$1, HashMap nameToSymbol$1) {
        if (!clockSignals$1.contains((Object)clockName)) {
            String prevClockName;
            clockSignals$1.add((Object)clockName);
            String x$1 = prevClockName = this.makePreviousValue(clockName);
            Type x$2 = tpe;
            NodeKind$ x$3 = NodeKind$.MODULE$;
            Info x$4 = info;
            int x$5 = Symbol$.MODULE$.apply$default$4();
            Symbol symbol = Symbol$.MODULE$.apply(x$1, x$2, (Kind)x$3, x$5, x$4);
            SymbolTable$.addSymbol$1(symbol, nameToSymbol$1);
            return;
        }
    }

    private static final Symbol getSymbol$1(String name, HashMap nameToSymbol$1, String instanceName$1, String modulePrefix$1) {
        return (Symbol)nameToSymbol$1.apply((Object)SymbolTable$.expand$1(new StringBuilder(1).append(instanceName$1).append(".").append(name).toString(), modulePrefix$1));
    }

    public static final /* synthetic */ void $anonfun$apply$6(HashMap nameToSymbol$1, String instanceName$1, String modulePrefix$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String dependent = (String)tuple2._1();
            Set driving = (Set)tuple2._2();
            Symbol dependentSymbol = SymbolTable$.getSymbol$1(dependent, nameToSymbol$1, instanceName$1, modulePrefix$1);
            Set drivers = (Set)driving.map((Function1 & Serializable)name -> SymbolTable$.getSymbol$1(name, nameToSymbol$1, instanceName$1, modulePrefix$1));
            SymbolTable$.addDependency$1(dependentSymbol, drivers, sensitivityGraphBuilder$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$apply$9(Symbol portSymbol$1, HashMap nameToSymbol$1, String instanceName$1, String modulePrefix$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, String inputName) {
        Symbol inputSymbol = SymbolTable$.getSymbol$1(inputName, nameToSymbol$1, instanceName$1, modulePrefix$1);
        SymbolTable$.addDependency$1(portSymbol$1, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{inputSymbol})), sensitivityGraphBuilder$1);
    }

    public static final /* synthetic */ void $anonfun$apply$8(SymbolTable$ $this, ScalaBlackBox implementation$1, HashMap nameToSymbol$1, String instanceName$1, Symbol instanceSymbol$1, String modulePrefix$1, HashSet clockSignals$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, Port port) {
        Direction direction = port.direction();
        Output$ output$ = Output$.MODULE$;
        if (!(direction != null ? !direction.equals(output$) : output$ != null)) {
            Symbol portSymbol = SymbolTable$.getSymbol$1(port.name(), nameToSymbol$1, instanceName$1, modulePrefix$1);
            implementation$1.outputDependencies(port.name()).foreach((Function1 & Serializable)inputName -> {
                SymbolTable$.$anonfun$apply$9(portSymbol, nameToSymbol$1, instanceName$1, modulePrefix$1, sensitivityGraphBuilder$1, inputName);
                return BoxedUnit.UNIT;
            });
        }
        Type type = port.tpe();
        ClockType$ clockType$ = ClockType$.MODULE$;
        if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
            Symbol portClock = (Symbol)nameToSymbol$1.apply((Object)SymbolTable$.expand$1(new StringBuilder(1).append(instanceName$1).append(".").append(port.name()).toString(), modulePrefix$1));
            $this.createPrevClock$1(portClock.name(), portClock.firrtlType(), portClock.info(), clockSignals$1, nameToSymbol$1);
            SymbolTable$.addDependency$1(instanceSymbol$1, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{portClock})), sensitivityGraphBuilder$1);
            return;
        }
    }

    private final void processDependencyStatements$1(String modulePrefix, Statement s, Module module, HashMap nameToSymbol$1, HashSet clockSignals$1, HashSet registerNames$1, HashSet instanceNames$1, HashMap instanceNameToModuleName$1, Circuit circuit$1, HashMap blackBoxImplementations$1, HashMap registerToClock$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, HashMap moduleMemoryToMemorySymbol$1, HashMap stopToStopInfo$1, HashMap lastStopSymbol$1, IntRef printfCardinal$1, HashMap printToPrintInfo$1, HashMap lastPrintfInModule$1, IntRef verifyCardinal$1, HashMap verifyInfo$1, HashMap lastVerifyInModule$1, HashSet inputPorts$1, HashSet outputPorts$1, Seq blackBoxFactories$1) {
        DefInstance defInstance;
        Option option;
        Statement statement = s;
        if (statement instanceof Block) {
            Block block = (Block)statement;
            block.stmts().foreach((Function1 & Serializable)subStatement -> {
                this.processDependencyStatements$1(modulePrefix, subStatement, module, nameToSymbol$1, clockSignals$1, registerNames$1, instanceNames$1, instanceNameToModuleName$1, circuit$1, blackBoxImplementations$1, registerToClock$1, sensitivityGraphBuilder$1, moduleMemoryToMemorySymbol$1, stopToStopInfo$1, lastStopSymbol$1, printfCardinal$1, printToPrintInfo$1, lastPrintfInModule$1, verifyCardinal$1, verifyInfo$1, lastVerifyInModule$1, inputPorts$1, outputPorts$1, blackBoxFactories$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (statement instanceof Connect) {
            Connect connect = (Connect)statement;
            Expression expression = connect.loc();
            if (expression instanceof Reference ? true : (expression instanceof SubField ? true : expression instanceof SubIndex)) {
                String name = registerNames$1.contains((Object)SymbolTable$.expand$1(connect.loc().serialize(), modulePrefix)) ? this.makeRegisterInputName(SymbolTable$.expand$1(connect.loc().serialize(), modulePrefix)) : SymbolTable$.expand$1(connect.loc().serialize(), modulePrefix);
                Symbol symbol2 = (Symbol)nameToSymbol$1.apply((Object)name);
                Type type = symbol2.firrtlType();
                ClockType$ clockType$ = ClockType$.MODULE$;
                if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                    this.createPrevClock$1(symbol2.name(), symbol2.firrtlType(), symbol2.info(), clockSignals$1, nameToSymbol$1);
                }
                Set references = SymbolTable$.expressionToReferences$1(connect.expr(), nameToSymbol$1, modulePrefix);
                SymbolTable$.addDependency$1(symbol2, references, sensitivityGraphBuilder$1);
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder(58).append("Warning: connect at ").append(connect.info()).append(", ").append(connect.loc()).append(" is not WRef, WSubField or WSubIndex").toString());
            }
            return;
        }
        if (statement instanceof DefInstance && !(option = WDefInstance$.MODULE$.unapply(defInstance = (DefInstance)statement)).isEmpty()) {
            Info info = (Info)((Tuple4)option.get())._1();
            String instanceName = (String)((Tuple4)option.get())._2();
            String moduleName = (String)((Tuple4)option.get())._3();
            String expandedName = SymbolTable$.expand$1(instanceName, modulePrefix);
            instanceNames$1.$plus$eq((Object)expandedName);
            instanceNameToModuleName$1.update((Object)expandedName, (Object)moduleName);
            Symbol instanceSymbol = new Symbol(expandedName, IntSize$.MODULE$, UnsignedInt$.MODULE$, (Kind)InstanceKind$.MODULE$, 1, 1, (Type)new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
            SymbolTable$.addSymbol$1(instanceSymbol, nameToSymbol$1);
            DefModule subModule = FindModule$.MODULE$.apply(moduleName, circuit$1);
            String newPrefix = modulePrefix.isEmpty() ? instanceName : new StringBuilder(1).append(modulePrefix).append(".").append(instanceName).toString();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("declaration:WDefInstance:").append(instanceName).append(":").append(moduleName).append(" prefix now ").append(newPrefix).toString());
            this.processModule$1(newPrefix, subModule, inputPorts$1, outputPorts$1, clockSignals$1, blackBoxFactories$1, nameToSymbol$1, registerNames$1, instanceNames$1, instanceNameToModuleName$1, circuit$1, blackBoxImplementations$1, registerToClock$1, sensitivityGraphBuilder$1, moduleMemoryToMemorySymbol$1, stopToStopInfo$1, lastStopSymbol$1, printfCardinal$1, printToPrintInfo$1, lastPrintfInModule$1, verifyCardinal$1, verifyInfo$1, lastVerifyInModule$1);
            DefModule defModule = subModule;
            if (defModule instanceof ExtModule) {
                ExtModule extModule = (ExtModule)defModule;
                Option option2 = blackBoxImplementations$1.get((Object)instanceSymbol);
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    ScalaBlackBox implementation = (ScalaBlackBox)some.value();
                    implementation.getDependencies().foreach((Function1 & Serializable)x0$1 -> {
                        SymbolTable$.$anonfun$apply$6(nameToSymbol$1, instanceName, modulePrefix, sensitivityGraphBuilder$1, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    extModule.ports().foreach((Function1 & Serializable)port -> {
                        SymbolTable$.$anonfun$apply$8(this, implementation, nameToSymbol$1, instanceName, instanceSymbol, modulePrefix, clockSignals$1, sensitivityGraphBuilder$1, port);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder(68).append("WARNING: external module \"").append(extModule.defname()).append("\"(").append(modulePrefix).append(":").append(extModule.name()).append(")").append("was not matched with an implementation").toString());
                }
            }
            return;
        }
        if (statement instanceof DefNode) {
            String expandedName;
            DefNode defNode = (DefNode)statement;
            Info info = defNode.info();
            String name = defNode.name();
            Expression expression = defNode.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(22).append("declaration:DefNode:").append(name).append(":").append(expression.serialize()).append(" ").append(SymbolTable$.expressionToReferences$1(expression, nameToSymbol$1, modulePrefix)).toString());
            String x$1 = expandedName = SymbolTable$.expand$1(name, modulePrefix);
            Type x$2 = expression.tpe();
            NodeKind$ x$3 = NodeKind$.MODULE$;
            Info x$4 = info;
            int x$5 = Symbol$.MODULE$.apply$default$4();
            Symbol symbol3 = Symbol$.MODULE$.apply(x$1, x$2, (Kind)x$3, x$5, x$4);
            SymbolTable$.addSymbol$1(symbol3, nameToSymbol$1);
            SymbolTable$.addDependency$1(symbol3, SymbolTable$.expressionToReferences$1(expression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            Type type = expression.tpe();
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                this.createPrevClock$1(symbol3.name(), expression.tpe(), info, clockSignals$1, nameToSymbol$1);
                return;
            }
            return;
        }
        if (statement instanceof DefWire) {
            String expandedName;
            DefWire defWire = (DefWire)statement;
            Info info = defWire.info();
            String name = defWire.name();
            Type tpe = defWire.tpe();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(20).append("declaration:DefWire:").append(name).toString());
            String x$6 = expandedName = SymbolTable$.expand$1(name, modulePrefix);
            Type x$7 = tpe;
            WireKind$ x$8 = WireKind$.MODULE$;
            Info x$9 = info;
            int x$10 = Symbol$.MODULE$.apply$default$4();
            Symbol symbol4 = Symbol$.MODULE$.apply(x$6, x$7, (Kind)x$8, x$10, x$9);
            SymbolTable$.addSymbol$1(symbol4, nameToSymbol$1);
            Type type = tpe;
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                this.createPrevClock$1(symbol4.name(), tpe, info, clockSignals$1, nameToSymbol$1);
                return;
            }
            return;
        }
        if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            Info info = defRegister.info();
            String name = defRegister.name();
            Type tpe = defRegister.tpe();
            Expression clockExpression = defRegister.clock();
            Expression resetExpression = defRegister.reset();
            String expandedName = SymbolTable$.expand$1(name, modulePrefix);
            String x$11 = this.makeRegisterInputName(expandedName);
            Type x$12 = tpe;
            RegKind$ x$13 = RegKind$.MODULE$;
            Info x$14 = info;
            int x$15 = Symbol$.MODULE$.apply$default$4();
            Symbol registerIn = Symbol$.MODULE$.apply(x$11, x$12, (Kind)x$13, x$15, x$14);
            String x$16 = expandedName;
            Type x$17 = tpe;
            RegKind$ x$18 = RegKind$.MODULE$;
            Info x$19 = info;
            int x$20 = Symbol$.MODULE$.apply$default$4();
            Symbol registerOut = Symbol$.MODULE$.apply(x$16, x$17, (Kind)x$18, x$20, x$19);
            registerNames$1.$plus$eq((Object)registerOut.name());
            SymbolTable$.addSymbol$1(registerIn, nameToSymbol$1);
            SymbolTable$.addSymbol$1(registerOut, nameToSymbol$1);
            SymbolTable$.addDependency$1(registerOut, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            SymbolTable$.addDependency$1(registerIn, SymbolTable$.expressionToReferences$1(resetExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            Type type = resetExpression.tpe();
            AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
            if (!(type != null ? !type.equals(asyncResetType$) : asyncResetType$ != null)) {
                SymbolTable$.addDependency$1(registerOut, SymbolTable$.expressionToReferences$1(resetExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            }
            SymbolTable$.addDependency$1(registerIn, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{registerOut})), sensitivityGraphBuilder$1);
            Set clocks = SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix);
            Predef$.MODULE$.assert(clocks.size() == 1, (Function0 & Serializable)() -> new StringBuilder(51).append("Register ").append(name).append(" needs to be clocked by exactly one wire: ").append(clocks).toString());
            Symbol clock = (Symbol)clocks.head();
            this.createPrevClock$1(clock.name(), clock.firrtlType(), clock.info(), clockSignals$1, nameToSymbol$1);
            registerToClock$1.update((Object)registerOut, (Object)clock);
            return;
        }
        if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            String expandedName = SymbolTable$.expand$1(defMemory.name(), modulePrefix);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(31).append("declaration:DefMemory:").append(defMemory.name()).append(" becomes ").append(expandedName).toString());
            Seq<Symbol> memorySymbols = Memory$.MODULE$.buildSymbols(defMemory, expandedName, sensitivityGraphBuilder$1, (HashSet<String>)registerNames$1);
            memorySymbols.foreach((Function1 & Serializable)symbol -> {
                SymbolTable$.addSymbol$1(symbol, nameToSymbol$1);
                return BoxedUnit.UNIT;
            });
            String moduleMemory = new StringBuilder(1).append(module.name()).append(".").append(defMemory.name()).toString();
            HashSet values = (HashSet)moduleMemoryToMemorySymbol$1.getOrElseUpdate((Object)moduleMemory, (Function0 & Serializable)() -> new HashSet());
            values.$plus$eq(memorySymbols.head());
            return;
        }
        if (statement instanceof Stop) {
            Stop stop = (Stop)statement;
            Info info = stop.info();
            Expression clockExpression = stop.clk();
            Expression enableExpression = stop.en();
            Option option3 = SymbolTable$.getClockSymbol$1(clockExpression, nameToSymbol$1, modulePrefix);
            if (option3 instanceof Some) {
                Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(stop.name())), (Function0 & Serializable)() -> "Stop statements require a non-empty name!");
                String stopSymbolName = SymbolTable$.expand$1(stop.name(), modulePrefix);
                Symbol stopSymbol = new Symbol(stopSymbolName, IntSize$.MODULE$, UnsignedInt$.MODULE$, (Kind)WireKind$.MODULE$, 1, 1, (Type)new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
                SymbolTable$.addSymbol$1(stopSymbol, nameToSymbol$1);
                stopToStopInfo$1.update((Object)stopSymbolName, (Object)new StopInfo(stopSymbol));
                SymbolTable$.addDependency$1(stopSymbol, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                SymbolTable$.addDependency$1(stopSymbol, SymbolTable$.expressionToReferences$1(enableExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                Option option4 = lastStopSymbol$1.get((Object)module);
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    Symbol lastSymbol = (Symbol)some.value();
                    SymbolTable$.addDependency$1(stopSymbol, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{lastSymbol})), sensitivityGraphBuilder$1);
                }
                lastStopSymbol$1.update((Object)module, (Object)stopSymbol);
                if (!nameToSymbol$1.contains((Object)StopOp$.MODULE$.stopHappenedName())) {
                    SymbolTable$.addSymbol$1(new Symbol(StopOp$.MODULE$.stopHappenedName(), IntSize$.MODULE$, UnsignedInt$.MODULE$, (Kind)WireKind$.MODULE$, 1, 1, (Type)new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(31))), (Info)NoInfo$.MODULE$), nameToSymbol$1);
                }
            } else {
                throw new TreadleException(new StringBuilder(21).append("Can't find clock for ").append(stop).toString());
            }
            return;
        }
        if (statement instanceof Print) {
            Symbol printSymbol;
            Print print = (Print)statement;
            Info info = print.info();
            Seq args = print.args();
            Expression clockExpression = print.clk();
            Expression enableExpression = print.en();
            Option option5 = SymbolTable$.getClockSymbol$1(clockExpression, nameToSymbol$1, modulePrefix);
            if (option5 instanceof Some) {
                Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(print.name())), (Function0 & Serializable)() -> "Print statements require a non-empty name!");
                String printSymbolName = SymbolTable$.expand$1(print.name(), modulePrefix);
                printSymbol = new Symbol(printSymbolName, IntSize$.MODULE$, UnsignedInt$.MODULE$, (Kind)WireKind$.MODULE$, 1, 1, (Type)new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
                SymbolTable$.addSymbol$1(printSymbol, nameToSymbol$1);
                ++printfCardinal$1.elem;
                printToPrintInfo$1.update((Object)print, (Object)new PrintInfo(printSymbol, printfCardinal$1.elem));
                SymbolTable$.addDependency$1(printSymbol, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                SymbolTable$.addDependency$1(printSymbol, SymbolTable$.expressionToReferences$1(enableExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                args.foreach((Function1 & Serializable)arg -> {
                    SymbolTable$.addDependency$1(printSymbol, SymbolTable$.expressionToReferences$1(arg, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                    return BoxedUnit.UNIT;
                });
                Option option6 = lastPrintfInModule$1.get((Object)module);
                if (option6 instanceof Some) {
                    Some some = (Some)option6;
                    Symbol lastPrintfSymbol = (Symbol)some.value();
                    SymbolTable$.addDependency$1(printSymbol, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{lastPrintfSymbol})), sensitivityGraphBuilder$1);
                }
            } else {
                throw new TreadleException(new StringBuilder(21).append("Can't find clock for ").append(print).toString());
            }
            lastPrintfInModule$1.update((Object)module, (Object)printSymbol);
            return;
        }
        if (statement instanceof Verification) {
            Verification verification = (Verification)statement;
            Enumeration.Value value = verification.op();
            Info info = verification.info();
            Expression clockExpression = verification.clk();
            Expression predicateExpression = verification.pred();
            Expression enableExpression = verification.en();
            Enumeration.Value value2 = Formal$.MODULE$.Cover();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Symbol verifySymbol;
                Option option7 = SymbolTable$.getClockSymbol$1(clockExpression, nameToSymbol$1, modulePrefix);
                if (option7 instanceof Some) {
                    Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(verification.name())), (Function0 & Serializable)() -> "Verification statements require a non-empty name!");
                    String verifySymbolName = SymbolTable$.expand$1(verification.name(), modulePrefix);
                    verifySymbol = new Symbol(verifySymbolName, IntSize$.MODULE$, UnsignedInt$.MODULE$, (Kind)WireKind$.MODULE$, 31, 1, (Type)new UIntType((Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
                    SymbolTable$.addSymbol$1(verifySymbol, nameToSymbol$1);
                    ++verifyCardinal$1.elem;
                    verifyInfo$1.update((Object)verifySymbolName, (Object)new VerifyInfo(verifySymbol, verifyCardinal$1.elem));
                    SymbolTable$.addDependency$1(verifySymbol, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                    SymbolTable$.addDependency$1(verifySymbol, SymbolTable$.expressionToReferences$1(enableExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                    SymbolTable$.addDependency$1(verifySymbol, SymbolTable$.expressionToReferences$1(predicateExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                    Option option8 = lastVerifyInModule$1.get((Object)module);
                    if (option8 instanceof Some) {
                        Some some = (Some)option8;
                        Symbol lastVerifySymbol = (Symbol)some.value();
                        SymbolTable$.addDependency$1(verifySymbol, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbol[]{lastVerifySymbol})), sensitivityGraphBuilder$1);
                    }
                } else {
                    throw new TreadleException(new StringBuilder(21).append("Can't find clock for ").append(verification).toString());
                }
                lastVerifyInModule$1.update((Object)module, (Object)verifySymbol);
                return;
            }
        }
        if (EmptyStmt$.MODULE$.equals(statement)) {
            return;
        }
        if (statement instanceof IsInvalid) {
            IsInvalid isInvalid = (IsInvalid)statement;
            this.logger().debug((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("IsInvalid found for %20s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{isInvalid.expr()})));
            return;
        }
        if (statement instanceof Conditionally) {
            Conditionally conditionally = (Conditionally)statement;
            throw new TreadleException(new StringBuilder(36).append("conditionally unsupported in engine ").append(conditionally).toString());
        }
        Predef$.MODULE$.println((Object)new StringBuilder(38).append("SymbolTable:TODO: Unhandled statement ").append(s).toString());
    }

    private static final String expand$2(String name, String modulePrefix$2) {
        return new StringBuilder(1).append(modulePrefix$2).append(".").append(name).toString();
    }

    public static final /* synthetic */ boolean $anonfun$apply$21(Port outputPort) {
        Direction direction = outputPort.direction();
        Output$ output$ = Output$.MODULE$;
        return !(direction != null ? !direction.equals(output$) : output$ != null);
    }

    public static final /* synthetic */ void $anonfun$apply$23(HashMap nameToSymbol$1, ExtModule extModule$1, Port outputPort$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, String modulePrefix$2, String inputPortName) {
        Symbol drivingSymbol = (Symbol)nameToSymbol$1.getOrElse((Object)SymbolTable$.expand$2(inputPortName, modulePrefix$2), (Function0 & Serializable)() -> {
            throw new TreadleException(new StringBuilder(118).append("external module ").append(extModule$1.name()).append(" claims output ").append(SymbolTable$.expand$2(outputPort$1.name(), modulePrefix$2)).append(" depends on non-existent input ").append(inputPortName).append(",").append(" probably a bad name in override def outputDependencies").toString());
        });
        sensitivityGraphBuilder$1.addSensitivity(drivingSymbol, (Symbol)nameToSymbol$1.apply((Object)SymbolTable$.expand$2(outputPort$1.name(), modulePrefix$2)));
    }

    public static final /* synthetic */ void $anonfun$apply$22(ScalaBlackBox instance$1, HashMap nameToSymbol$1, ExtModule extModule$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, String modulePrefix$2, Port outputPort) {
        instance$1.outputDependencies(outputPort.name()).foreach((Function1 & Serializable)inputPortName -> {
            SymbolTable$.$anonfun$apply$23(nameToSymbol$1, extModule$1, outputPort, sensitivityGraphBuilder$1, modulePrefix$2, inputPortName);
            return BoxedUnit.UNIT;
        });
    }

    private static final void processExternalInstance$1(ExtModule extModule, String modulePrefix, ScalaBlackBox instance, HashMap nameToSymbol$1, HashMap blackBoxImplementations$1, SensitivityGraphBuilder sensitivityGraphBuilder$1) {
        Symbol instanceSymbol = (Symbol)nameToSymbol$1.apply((Object)modulePrefix);
        blackBoxImplementations$1.update((Object)instanceSymbol, (Object)instance);
        extModule.ports().withFilter((Function1 & Serializable)outputPort -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$21(outputPort))).foreach((Function1 & Serializable)outputPort -> {
            SymbolTable$.$anonfun$apply$22(instance, nameToSymbol$1, extModule, sensitivityGraphBuilder$1, modulePrefix, outputPort);
            return BoxedUnit.UNIT;
        });
    }

    private static final String expand$3(String name, String modulePrefix$3) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(modulePrefix$3))) {
            return new StringBuilder(1).append(modulePrefix$3).append(".").append(name).toString();
        }
        return name;
    }

    public static final /* synthetic */ void $anonfun$apply$25(String modulePrefix$3, HashSet inputPorts$1, HashSet outputPorts$1, HashSet clockSignals$1, HashMap nameToSymbol$1, Port port) {
        String expandedName = SymbolTable$.expand$3(port.name(), modulePrefix$3);
        Symbol symbol = Symbol$.MODULE$.apply(expandedName, port.tpe(), (Kind)PortKind$.MODULE$, Symbol$.MODULE$.apply$default$4(), Symbol$.MODULE$.apply$default$5());
        SymbolTable$.addSymbol$1(symbol, nameToSymbol$1);
        if (modulePrefix$3.isEmpty()) {
            Object object;
            Direction direction = port.direction();
            Input$ input$ = Input$.MODULE$;
            if (!(direction != null ? !direction.equals(input$) : input$ != null)) {
                object = inputPorts$1.$plus$eq((Object)symbol.name());
            } else {
                Direction direction2 = port.direction();
                Output$ output$ = Output$.MODULE$;
                object = !(direction2 != null ? !direction2.equals(output$) : output$ != null) ? outputPorts$1.$plus$eq((Object)symbol.name()) : BoxedUnit.UNIT;
            }
            Type type = port.tpe();
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                clockSignals$1.add((Object)symbol.name());
                Symbol prevClockSymbol = Symbol$.MODULE$.apply(MODULE$.makePreviousValue(symbol), (Type)ClockType$.MODULE$, (Kind)PortKind$.MODULE$, Symbol$.MODULE$.apply$default$4(), Symbol$.MODULE$.apply$default$5());
                SymbolTable$.addSymbol$1(prevClockSymbol, nameToSymbol$1);
                return;
            }
            return;
        }
    }

    private static final void processPorts$1(DefModule module, String modulePrefix$3, HashSet inputPorts$1, HashSet outputPorts$1, HashSet clockSignals$1, HashMap nameToSymbol$1) {
        module.ports().foreach((Function1 & Serializable)port -> {
            SymbolTable$.$anonfun$apply$25(modulePrefix$3, inputPorts$1, outputPorts$1, clockSignals$1, nameToSymbol$1, port);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$28(String modulePrefix$3, ExtModule x3$1, HashMap nameToSymbol$1, HashMap blackBoxImplementations$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, ScalaBlackBoxFactory factory) {
        MODULE$.logger().debug((Function0 & Serializable)() -> "Found an existing factory");
        Option<ScalaBlackBox> option = factory.createInstance(modulePrefix$3, x3$1.defname());
        if (option instanceof Some) {
            Some some = (Some)option;
            ScalaBlackBox implementation = (ScalaBlackBox)some.value();
            SymbolTable$.processExternalInstance$1(x3$1, modulePrefix$3, implementation, nameToSymbol$1, blackBoxImplementations$1, sensitivityGraphBuilder$1);
            return true;
        }
        return false;
    }

    private final void processModule$1(String modulePrefix, DefModule myModule, HashSet inputPorts$1, HashSet outputPorts$1, HashSet clockSignals$1, Seq blackBoxFactories$1, HashMap nameToSymbol$1, HashSet registerNames$1, HashSet instanceNames$1, HashMap instanceNameToModuleName$1, Circuit circuit$1, HashMap blackBoxImplementations$1, HashMap registerToClock$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, HashMap moduleMemoryToMemorySymbol$1, HashMap stopToStopInfo$1, HashMap lastStopSymbol$1, IntRef printfCardinal$1, HashMap printToPrintInfo$1, HashMap lastPrintfInModule$1, IntRef verifyCardinal$1, HashMap verifyInfo$1, HashMap lastVerifyInModule$1) {
        DefModule defModule = myModule;
        if (defModule instanceof Module) {
            Module module = (Module)defModule;
            SymbolTable$.processPorts$1((DefModule)module, modulePrefix, inputPorts$1, outputPorts$1, clockSignals$1, nameToSymbol$1);
            this.processDependencyStatements$1(modulePrefix, module.body(), module, nameToSymbol$1, clockSignals$1, registerNames$1, instanceNames$1, instanceNameToModuleName$1, circuit$1, blackBoxImplementations$1, registerToClock$1, sensitivityGraphBuilder$1, moduleMemoryToMemorySymbol$1, stopToStopInfo$1, lastStopSymbol$1, printfCardinal$1, printToPrintInfo$1, lastPrintfInModule$1, verifyCardinal$1, verifyInfo$1, lastVerifyInModule$1, inputPorts$1, outputPorts$1, blackBoxFactories$1);
            return;
        }
        if (defModule instanceof ExtModule) {
            ExtModule extModule = (ExtModule)defModule;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("got external module ").append(extModule.name()).append(" instance ").append(modulePrefix).toString());
            SymbolTable$.processPorts$1((DefModule)extModule, modulePrefix, inputPorts$1, outputPorts$1, clockSignals$1, nameToSymbol$1);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(11).append("Factories: ").append(blackBoxFactories$1.mkString("\n")).toString());
            boolean implementationFound = blackBoxFactories$1.exists((Function1 & Serializable)factory -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$28(modulePrefix, extModule, nameToSymbol$1, blackBoxImplementations$1, sensitivityGraphBuilder$1, factory)));
            if (!implementationFound) {
                Predef$.MODULE$.println((Object)new StringBuilder(68).append("WARNING: external module \"").append(extModule.defname()).append("\"(").append(modulePrefix).append(":").append(extModule.name()).append(")").append("was not matched with an implementation").toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)defModule);
    }

    private static final void show$1(Symbol symbol, String highlightPattern) {
        String line = new StringBuilder(5).append(symbol).append("   : ").append(symbol.info().serialize()).toString();
        String highlighted = line.replace(highlightPattern, new StringBuilder(9).append("\u001b[31m").append(highlightPattern).append("\u001b[0m").toString());
        Predef$.MODULE$.println((Object)highlighted);
    }

    public static final /* synthetic */ void $anonfun$apply$31(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Symbol symbol = (Symbol)tuple2._1();
            Symbol nextSymbol = (Symbol)tuple2._2();
            SymbolTable$.show$1(symbol, nextSymbol.name());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$30(SymbolTable symbolTable$1, Symbol badNode$1, Symbol node) {
        boolean bl;
        try {
            Seq path = (Seq)symbolTable$1.childrenOf().path((Object)node, (Object)badNode$1).$plus$plus((IterableOnce)symbolTable$1.childrenOf().path((Object)badNode$1, (Object)node).tail());
            Predef$.MODULE$.println((Object)new StringBuilder(31).append("Problem path found starting at ").append(node.name()).toString());
            ((IterableOnceOps)((IterableOps)path.reverse()).zip((IterableOnce)((IterableOps)path.reverse()).tail())).foreach((Function1 & Serializable)x0$1 -> {
                SymbolTable$.$anonfun$apply$31(x0$1);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private static final void showLoop$1(Symbol badNode, SymbolTable symbolTable) {
        Set<Symbol> badChildren = symbolTable.getChildren((Seq<Symbol>)new .colon.colon((Object)badNode, (List)Nil$.MODULE$));
        badChildren.exists((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$30(symbolTable, badNode, node)));
    }

    public static final /* synthetic */ void $anonfun$apply$35(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Symbol symbol = (Symbol)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int adjustedIndex = symbol.name().startsWith("/stopped") ? Integer.MAX_VALUE : (symbol.name().startsWith("/stop") ? 0x7FFFFFFE : index);
            symbol.cardinalNumber_$eq(adjustedIndex);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SymbolTable$() {
    }
}

