/*
 * Decompiled with CFR 0.152.
 */
package treadle2.utils;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;
import treadle2.executable.IndicesAndRadix;
import treadle2.executable.TreadleException;

public final class NumberHelpers$ {
    public static final NumberHelpers$ MODULE$ = new NumberHelpers$();
    private static final Regex RadixRangeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^-]+)-([^-]+)"));
    private static volatile boolean bitmap$init$0 = true;

    public Regex RadixRangeRegex() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: NumberHelpers.scala: 11");
        }
        return RadixRangeRegex;
    }

    public Tuple2<BigInt, Object> parseBigIntWithRadix(String numberString) {
        String normalizedNumberString = numberString.replaceAll("[\\s_]+", "");
        if (normalizedNumberString.startsWith("0x")) {
            return NumberHelpers$.parseWithRadix$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(normalizedNumberString), 2), 16);
        }
        if (normalizedNumberString.startsWith("x")) {
            return NumberHelpers$.parseWithRadix$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(normalizedNumberString), 1), 16);
        }
        if (normalizedNumberString.startsWith("h")) {
            return NumberHelpers$.parseWithRadix$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(normalizedNumberString), 1), 16);
        }
        if (normalizedNumberString.startsWith("o")) {
            return NumberHelpers$.parseWithRadix$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(normalizedNumberString), 1), 8);
        }
        if (normalizedNumberString.startsWith("b")) {
            return NumberHelpers$.parseWithRadix$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(normalizedNumberString), 1), 2);
        }
        if (normalizedNumberString.startsWith("d")) {
            return NumberHelpers$.parseWithRadix$1(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(normalizedNumberString), 1), 10);
        }
        return NumberHelpers$.parseWithRadix$1(normalizedNumberString, 10);
    }

    public BigInt parseBigInt(String numberString) {
        return (BigInt)this.parseBigIntWithRadix(numberString)._1();
    }

    public IndicesAndRadix parseIntRangeWithRadix(String rangeString) {
        ObjectRef radix = ObjectRef.create((Object)Option$.MODULE$.empty());
        Set indices = (Set)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])rangeString.split(",")), (Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Option option;
                Set set = (Set)tuple2._1();
                String string = (String)tuple2._2();
                if (string != null && !(option = MODULE$.RadixRangeRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                    String startString = (String)((LinearSeqOps)option.get()).apply(0);
                    String endString = (String)((LinearSeqOps)option.get()).apply(1);
                    Tuple2<BigInt, Object> tuple22 = MODULE$.parseBigIntWithRadix(startString);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    BigInt start = (BigInt)tuple22._1();
                    int radix1 = tuple22._2$mcI$sp();
                    Tuple2 tuple23 = new Tuple2((Object)start, (Object)BoxesRunTime.boxToInteger((int)radix1));
                    BigInt start2 = (BigInt)tuple23._1();
                    int radix12 = tuple23._2$mcI$sp();
                    Tuple2<BigInt, Object> tuple24 = MODULE$.parseBigIntWithRadix(endString);
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    BigInt end = (BigInt)tuple24._1();
                    int radix2 = tuple24._2$mcI$sp();
                    Tuple2 tuple25 = new Tuple2((Object)end, (Object)BoxesRunTime.boxToInteger((int)radix2));
                    BigInt end2 = (BigInt)tuple25._1();
                    int radix22 = tuple25._2$mcI$sp();
                    if (radix12 != radix22) {
                        throw new TreadleException(new StringBuilder(32).append("Radices must match in string \"").append(rangeString).append("\" ").toString());
                    }
                    NumberHelpers$.checkAndSetRadix$1(radix12, radix, rangeString);
                    if (start2.$greater((Object)end2)) {
                        throw new TreadleException(new StringBuilder(18).append(start2).append(" is not <= ").append(end2).append(" in \"").append(rangeString).append("\" ").toString());
                    }
                    return (Set)set.$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(start2.toInt()), end2.toInt()));
                }
            }
            if (tuple2 != null) {
                Set set = (Set)tuple2._1();
                String numberString = (String)tuple2._2();
                Tuple2<BigInt, Object> tuple26 = MODULE$.parseBigIntWithRadix(numberString);
                if (tuple26 == null) {
                    throw new MatchError(tuple26);
                }
                BigInt number = (BigInt)tuple26._1();
                int radix1 = tuple26._2$mcI$sp();
                Tuple2 tuple27 = new Tuple2((Object)number, (Object)BoxesRunTime.boxToInteger((int)radix1));
                BigInt number2 = (BigInt)tuple27._1();
                int radix13 = tuple27._2$mcI$sp();
                NumberHelpers$.checkAndSetRadix$1(radix13, radix, rangeString);
                return (Set)set.$plus((Object)BoxesRunTime.boxToInteger((int)number2.toInt()));
            }
            throw new MatchError((Object)tuple2);
        });
        return new IndicesAndRadix((Set<Object>)indices, BoxesRunTime.unboxToInt((Object)((Option)radix.elem).get()));
    }

    public int radixFromString(String radixCode) {
        block6: {
            block5: {
                String string = radixCode;
                String string2 = "b";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return 2;
                }
                String string3 = radixCode;
                String string4 = "o";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return 8;
                }
                String string5 = radixCode;
                String string6 = "h";
                if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block5;
                String string7 = radixCode;
                String string8 = "x";
                if (string7 != null ? !string7.equals(string8) : string8 != null) break block6;
            }
            return 16;
        }
        return 10;
    }

    private static final Tuple2 parseWithRadix$1(String numString, int radix) {
        return new Tuple2((Object)package$.MODULE$.BigInt().apply(numString, radix), (Object)BoxesRunTime.boxToInteger((int)radix));
    }

    private static final void checkAndSetRadix$1(int foundRadix, ObjectRef radix$1, String rangeString$1) {
        if (((Option)radix$1.elem).isEmpty()) {
            radix$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)foundRadix));
            return;
        }
        if (!((Option)radix$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)foundRadix))) {
            throw new TreadleException(new StringBuilder(36).append("More than one radix specified in \"").append(rangeString$1).append("\" ").toString());
        }
    }

    private NumberHelpers$() {
    }
}

