/*
 * Decompiled with CFR 0.152.
 */
package ch.jodersky.sbt.jni.javah;

import ch.jodersky.sbt.jni.javah.util.Utils;
import java.util.Objects;

public final class ClassName {
    private final String moduleName;
    private final String className;
    private final String simpleName;
    private final String mangledName;

    public static ClassName of(String string, String string2) {
        Objects.requireNonNull(string2, "Class name is null");
        if (string != null && !Utils.FULL_NAME_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("Illegal module name: " + string);
        }
        if (!Utils.FULL_NAME_PATTERN.matcher(string2).matches()) {
            throw new IllegalArgumentException("Illegal class name: " + string);
        }
        return new ClassName(string, string2);
    }

    public static ClassName ofFullName(String string) {
        Objects.requireNonNull(string, "class name is null");
        int n = string.indexOf(47);
        if (n == -1) {
            return ClassName.of(null, string);
        }
        return ClassName.of(string.substring(0, n), string.substring(n + 1));
    }

    public static ClassName ofInternalName(String string) {
        return ClassName.of(null, string.replace('/', '.'));
    }

    private ClassName(String string, String string2) {
        this.moduleName = string;
        this.className = string2;
        this.simpleName = string2.substring(string2.lastIndexOf(46) + 1);
        this.mangledName = Utils.mangleName(string2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassName)) {
            return false;
        }
        ClassName className = (ClassName)object;
        return Objects.equals(this.moduleName, className.moduleName) && this.className.equals(className.className);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.className);
    }

    public String toString() {
        return this.moduleName == null ? this.className : this.moduleName + '/' + this.className;
    }

    public final String moduleName() {
        return this.moduleName;
    }

    public final String className() {
        return this.className;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public final String mangledName() {
        return this.mangledName;
    }

    public final String relativePath() {
        return this.className.replace('.', '/') + ".class";
    }
}

