/*
 * Decompiled with CFR 0.152.
 */
package ch.jodersky.sbt.jni.javah.util;

import ch.jodersky.sbt.jni.javah.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Constant {
    private static final List<Class<?>> TYPES = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Character.class, Float.class, Double.class);
    private final String name;
    private final Object value;
    private final String mangledName;

    public static Constant of(String string, Object object) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(object);
        if (!TYPES.contains(object.getClass())) {
            throw new IllegalArgumentException();
        }
        if (!Utils.SIMPLE_NAME_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a qualified constant name", string));
        }
        return new Constant(string, object);
    }

    private Constant(String string, Object object) {
        this.name = string;
        this.value = object;
        this.mangledName = Utils.mangleName(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Constant)) {
            return false;
        }
        Constant constant = (Constant)object;
        return this.name.equals(constant.name) && this.value.equals(constant.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return String.format("Constant[name=%s, value=%s]", this.name, this.value);
    }

    public String name() {
        return this.name;
    }

    public Object value() {
        return this.value;
    }

    public String mangledName() {
        return this.mangledName;
    }

    public String valueToString() {
        if (this.value instanceof Double) {
            return this.value.toString();
        }
        if (this.value instanceof Float) {
            return this.value + "f";
        }
        if (this.value instanceof Long) {
            return this.value + "i64";
        }
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue() + "L";
        }
        return this.value + "L";
    }
}

