/*
 * Decompiled with CFR 0.152.
 */
package ch.jodersky.sbt.jni.javah.search;

import ch.jodersky.sbt.jni.javah.ClassName;
import ch.jodersky.sbt.jni.javah.search.SearchPath;
import ch.jodersky.sbt.jni.javah.util.Utils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ClassPath
implements SearchPath {
    private final Path path;
    private final List<Path> roots;

    public ClassPath(Path path) {
        Objects.requireNonNull(path);
        this.path = path.toAbsolutePath();
        Path path2 = Utils.classPathRoot(path);
        this.roots = path2 == null ? Collections.emptyList() : SearchPath.multiReleaseRoots(path2);
    }

    @Override
    public Path search(ClassName className) {
        Objects.requireNonNull(className);
        return SearchPath.searchFromRoots(this.roots, className);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassPath classPath = (ClassPath)object;
        return Objects.equals(this.path, classPath.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "ClassPath[" + this.path + "]";
    }
}

