/*
 * Decompiled with CFR 0.152.
 */
package ch.jodersky.sbt.jni.javah.util;

import ch.jodersky.sbt.jni.javah.util.Utils;
import java.util.Objects;
import java.util.regex.Matcher;
import org.objectweb.asm.Type;

public final class NativeMethod {
    private final int access;
    private final String name;
    private final Type type;
    private final String mangledName;
    private final String longMangledName;

    public static NativeMethod of(String string, String string2) {
        return NativeMethod.of(0, string, string2);
    }

    public static NativeMethod of(String string, Type type) {
        return NativeMethod.of(0, string, type);
    }

    public static NativeMethod of(int n, String string, String string2) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        return NativeMethod.of(n, string, Type.getType((String)string2));
    }

    public static NativeMethod of(int n, String string, Type type) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(type);
        if (!Utils.METHOD_NAME_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a qualified method name", string));
        }
        Matcher matcher = Utils.METHOD_TYPE_PATTERN.matcher(type.toString());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a method type", type));
        }
        return new NativeMethod(n, string, type, matcher.group("args"));
    }

    private NativeMethod(int n, String string, Type type, String string2) {
        this.access = n;
        this.name = string;
        this.type = type;
        this.mangledName = Utils.mangleName(string);
        this.longMangledName = this.mangledName + "__" + Utils.mangleName(string2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NativeMethod)) {
            return false;
        }
        NativeMethod nativeMethod = (NativeMethod)object;
        return this.name.equals(nativeMethod.name) && this.type.equals((Object)nativeMethod.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return String.format("NativeMethod[name=%s, type=%s}", this.name, this.type);
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public String mangledName() {
        return this.mangledName;
    }

    public String longMangledName() {
        return this.longMangledName;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }
}

