package xyz.mcxross.ksui.generated

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getcheckpoints.CheckpointConnection

public const val GET_CHECKPOINTS: String =
    "query getCheckpoints(${'$'}first: Int, ${'$'}before: String, ${'$'}last: Int, ${'$'}after: String) {\n    checkpoints(first: ${'$'}first, after: ${'$'}after, last: ${'$'}last, before: ${'$'}before) {\n        pageInfo {\n            startCursor\n            endCursor\n            hasNextPage\n            hasPreviousPage\n        }\n        nodes {\n            ...RPC_Checkpoint_Fields\n        }\n    }\n}\n\nfragment RPC_Checkpoint_Fields on Checkpoint {\n    # checkpointCommitments\n    digest\n    epoch {\n        epochId\n    }\n\n    rollingGasSummary {\n        computationCost\n        storageCost\n        storageRebate\n        nonRefundableStorageFee\n    }\n    networkTotalTransactions\n    previousCheckpointDigest\n    sequenceNumber\n    timestamp\n    validatorSignatures\n    transactionBlocks {\n        pageInfo {\n            hasNextPage\n            endCursor\n        }\n        nodes {\n            digest\n        }\n    }\n    endOfEpoch: transactionBlocks(last: 1, filter: { kind: SYSTEM_TX }) {\n        nodes {\n            kind {\n                __typename\n                ... on EndOfEpochTransaction {\n                    transactions(last: 1) {\n                        nodes {\n                            __typename\n                            ... on ChangeEpochTransaction {\n                                epoch {\n                                    validatorSet {\n                                        activeValidators {\n                                            pageInfo {\n                                                hasNextPage\n                                                endCursor\n                                            }\n                                            nodes {\n                                                credentials {\n                                                    protocolPubKey\n                                                }\n                                                votingPower\n                                            }\n                                        }\n                                    }\n                                    protocolConfigs {\n                                        protocolVersion\n                                    }\n                                    epochId\n                                }\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n}"

@Generated
@Serializable
public class GetCheckpoints(
  override val variables: GetCheckpoints.Variables,
) : GraphQLClientRequest<GetCheckpoints.Result>() {
  @Required
  override val query: String = GET_CHECKPOINTS

  @Required
  override val operationName: String? = "getCheckpoints"

  @Generated
  @Serializable
  public data class Variables(
    public val first: Int? = null,
    public val before: String? = null,
    public val last: Int? = null,
    public val after: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The checkpoints that exist in the network.
     */
    public val checkpoints: CheckpointConnection,
  )
}
