package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.dryruntransactionblock.DryRunResult

public const val DRY_RUN_TRANSACTION_BLOCK: String =
    "query dryRunTransactionBlock(\n    ${'$'}txBytes: String!\n    ${'$'}showBalanceChanges: Boolean = false\n    ${'$'}showEffects: Boolean = false\n    ${'$'}showEvents: Boolean = false\n    ${'$'}showObjectChanges: Boolean = false\n    ${'$'}showRawInput: Boolean = false\n) {\n    dryRunTransactionBlock(txBytes: ${'$'}txBytes) {\n        error\n        transaction {\n            ...RPC_TRANSACTION_FIELDS\n        }\n    }\n}\n\nfragment RPC_TRANSACTION_FIELDS on TransactionBlock {\n    digest\n    rawTransaction: bcs @include(if: ${'$'}showRawInput)\n    sender {\n        address\n    }\n\n    signatures\n\n    effects {\n        bcs @include(if: ${'$'}showEffects)\n        events @include(if: ${'$'}showEvents) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n        }\n        checkpoint {\n            sequenceNumber\n        }\n        timestamp\n        balanceChanges @include(if: ${'$'}showBalanceChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                coinType {\n                    repr\n                }\n                owner {\n                    asObject {\n                        address\n                    }\n                    asAddress {\n                        address\n                    }\n                }\n                amount\n            }\n        }\n\n        objectChanges @include(if: ${'$'}showObjectChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                address\n                inputState {\n                    version\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                }\n                outputState {\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                    asMovePackage {\n                        modules(first: 10) {\n                            nodes {\n                                name\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n}"

@Generated
@Serializable
public class DryRunTransactionBlock(
  override val variables: DryRunTransactionBlock.Variables,
) : GraphQLClientRequest<DryRunTransactionBlock.Result>() {
  @Required
  override val query: String = DRY_RUN_TRANSACTION_BLOCK

  @Required
  override val operationName: String? = "dryRunTransactionBlock"

  @Generated
  @Serializable
  public data class Variables(
    public val txBytes: String,
    public val showBalanceChanges: Boolean? = null,
    public val showEffects: Boolean? = null,
    public val showEvents: Boolean? = null,
    public val showObjectChanges: Boolean? = null,
    public val showRawInput: Boolean? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Simulate running a transaction to inspect its effects without
     * committing to them on-chain.
     *
     * `txBytes` either a `TransactionData` struct or a `TransactionKind`
     * struct, BCS-encoded and then Base64-encoded.  The expected
     * type is controlled by the presence or absence of `txMeta`: If
     * present, `txBytes` is assumed to be a `TransactionKind`, if
     * absent, then `TransactionData`.
     *
     * `txMeta` the data that is missing from a `TransactionKind` to make
     * a `TransactionData` (sender address and gas information).  All
     * its fields are nullable.
     *
     * `skipChecks` optional flag to disable the usual verification
     * checks that prevent access to objects that are owned by
     * addresses other than the sender, and calling non-public,
     * non-entry functions, and some other checks.  Defaults to false.
     */
    public val dryRunTransactionBlock: DryRunResult,
  )
}
