package xyz.mcxross.ksui.generated

import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.executetransactionblock.ExecutionResult

public const val EXECUTE_TRANSACTION_BLOCK: String =
    "mutation executeTransactionBlock(\n    ${'$'}txBytes: String!\n    ${'$'}signatures: [String!]!\n) {\n    executeTransactionBlock(txBytes: ${'$'}txBytes, signatures: ${'$'}signatures) {\n        errors\n        effects {\n            transactionBlock {\n                digest\n\n                sender {\n                    address\n                }\n\n                signatures\n\n                effects {\n                    checkpoint {\n                        sequenceNumber\n                    }\n                    timestamp\n                }\n            }\n        }\n    }\n}"

@Generated
@Serializable
public class ExecuteTransactionBlock(
  override val variables: ExecuteTransactionBlock.Variables,
) : GraphQLClientRequest<ExecuteTransactionBlock.Result>() {
  @Required
  override val query: String = EXECUTE_TRANSACTION_BLOCK

  @Required
  override val operationName: String? = "executeTransactionBlock"

  @Generated
  @Serializable
  public data class Variables(
    public val txBytes: String,
    public val signatures: List<String>,
  )

  /**
   * Mutations are used to write to the Sui network.
   */
  @Generated
  @Serializable
  public data class Result(
    /**
     * Execute a transaction, committing its effects on chain.
     *
     * - `txBytes` is a `TransactionData` struct that has been BCS-encoded and then Base64-encoded.
     * - `signatures` are a list of `flag || signature || pubkey` bytes, Base64-encoded.
     *
     * Waits until the transaction has reached finality on chain to return its transaction digest,
     * or returns the error that prevented finality if that was not possible. A transaction is
     * final when its effects are guaranteed on chain (it cannot be revoked).
     *
     * There may be a delay between transaction finality and when GraphQL requests (including the
     * request that issued the transaction) reflect its effects. As a result, queries that depend
     * on indexing the state of the chain (e.g. contents of output objects, address-level balance
     * information at the time of the transaction), must wait for indexing to catch up by polling
     * for the transaction digest using `Query.transactionBlock`.
     */
    public val executeTransactionBlock: ExecutionResult,
  )
}
