package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getobject.Object

public const val GET_OBJECT: String =
    "query getObject(\n    ${'$'}id: SuiAddress!\n    ${'$'}showBcs: Boolean = false\n    ${'$'}showOwner: Boolean = false\n    ${'$'}showPreviousTransaction: Boolean = false\n    ${'$'}showContent: Boolean = false\n    ${'$'}showDisplay: Boolean = false\n    ${'$'}showType: Boolean = false\n    ${'$'}showStorageRebate: Boolean = false\n) {\n    object(address: ${'$'}id) {\n        ...RPC_OBJECT_FIELDS\n    }\n}\n\nfragment RPC_OBJECT_FIELDS on Object {\n    objectId: address\n    version\n    asMoveObject @include(if: ${'$'}showContent) {\n        hasPublicTransfer\n        contents {\n            data\n            type {\n                repr\n                layout\n                signature\n            }\n        }\n    }\n    owner @include(if: ${'$'}showOwner) {\n        ...RPC_OBJECT_OWNER_FIELDS\n    }\n    previousTransactionBlock @include(if: ${'$'}showPreviousTransaction) {\n        digest\n    }\n\n    storageRebate @include(if: ${'$'}showStorageRebate)\n    digest\n    display @include(if: ${'$'}showDisplay) {\n        key\n        value\n        error\n    }\n}\n\nfragment RPC_OBJECT_OWNER_FIELDS on ObjectOwner {\n    __typename\n    ... on AddressOwner {\n        owner {\n            asObject {\n                address\n            }\n            asAddress {\n                address\n            }\n        }\n    }\n    ... on Parent {\n        parent {\n            address\n        }\n    }\n    ... on Shared {\n        initialSharedVersion\n    }\n}"

@Generated
@Serializable
public class GetObject(
  override val variables: GetObject.Variables,
) : GraphQLClientRequest<GetObject.Result>() {
  @Required
  override val query: String = GET_OBJECT

  @Required
  override val operationName: String? = "getObject"

  @Generated
  @Serializable
  public data class Variables(
    public val id: SuiAddress,
    public val showBcs: Boolean? = null,
    public val showOwner: Boolean? = null,
    public val showPreviousTransaction: Boolean? = null,
    public val showContent: Boolean? = null,
    public val showDisplay: Boolean? = null,
    public val showType: Boolean? = null,
    public val showStorageRebate: Boolean? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The object corresponding to the given address at the (optionally) given version.
     * When no version is given, the latest version is returned.
     */
    public val `object`: Object? = null,
  )
}
