package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getownedobjects.Address
import xyz.mcxross.ksui.generated.inputs.ObjectFilter

public const val GET_OWNED_OBJECTS: String =
    "query getOwnedObjects(\n\t${'$'}owner: SuiAddress!\n\t${'$'}limit: Int\n\t${'$'}cursor: String\n\t${'$'}showBcs: Boolean = false\n\t${'$'}showContent: Boolean = false\n\t${'$'}showDisplay: Boolean = false\n\t${'$'}showOwner: Boolean = false\n\t${'$'}showPreviousTransaction: Boolean = false\n\t${'$'}showStorageRebate: Boolean = false\n\t${'$'}filter: ObjectFilter\n) {\n\taddress(address: ${'$'}owner) {\n\t\tobjects(first: ${'$'}limit, after: ${'$'}cursor, filter: ${'$'}filter) {\n\t\t\tpageInfo {\n\t\t\t\thasNextPage\n\t\t\t\tendCursor\n\t\t\t}\n\t\t\tnodes {\n\t\t\t\t...RPC_MOVE_OBJECT_FIELDS\n\t\t\t}\n\t\t}\n\t}\n}\n\nfragment RPC_MOVE_OBJECT_FIELDS on MoveObject {\n\tobjectId: address\n\tbcs @include(if: ${'$'}showBcs)\n\thasPublicTransfer @include(if: ${'$'}showContent)\n\tcontents @include(if: ${'$'}showBcs) {\n\t\tbcs\n\t\ttype {\n\t\t\trepr\n\t\t}\n\t}\n\n\towner @include(if: ${'$'}showOwner) {\n\t\t...RPC_OBJECT_OWNER_FIELDS\n\t}\n\tpreviousTransactionBlock @include(if: ${'$'}showPreviousTransaction) {\n\t\tdigest\n\t}\n\n\tstorageRebate @include(if: ${'$'}showStorageRebate)\n\tdigest\n\tversion\n\tdisplay @include(if: ${'$'}showDisplay) {\n\t\tkey\n\t\tvalue\n\t\terror\n\t}\n}\n\nfragment RPC_OBJECT_OWNER_FIELDS on ObjectOwner {\n\t__typename\n\t... on AddressOwner {\n\t\towner {\n\t\t\tasObject {\n\t\t\t\taddress\n\t\t\t}\n\t\t\tasAddress {\n\t\t\t\taddress\n\t\t\t}\n\t\t}\n\t}\n\t... on Parent {\n\t\tparent {\n\t\t\taddress\n\t\t}\n\t}\n\t... on Shared {\n\t\tinitialSharedVersion\n\t}\n}"

@Generated
@Serializable
public class GetOwnedObjects(
  override val variables: GetOwnedObjects.Variables,
) : GraphQLClientRequest<GetOwnedObjects.Result>() {
  @Required
  override val query: String = GET_OWNED_OBJECTS

  @Required
  override val operationName: String? = "getOwnedObjects"

  @Generated
  @Serializable
  public data class Variables(
    public val owner: SuiAddress,
    public val limit: Int? = null,
    public val cursor: String? = null,
    public val showBcs: Boolean? = null,
    public val showContent: Boolean? = null,
    public val showDisplay: Boolean? = null,
    public val showOwner: Boolean? = null,
    public val showPreviousTransaction: Boolean? = null,
    public val showStorageRebate: Boolean? = null,
    public val filter: ObjectFilter? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Look-up an Account by its SuiAddress.
     */
    public val address: Address? = null,
  )
}
