package xyz.mcxross.ksui.generated

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getstakes.Address

public const val GET_STAKES: String =
    "query getStakes(${'$'}owner: SuiAddress!, ${'$'}limit: Int, ${'$'}cursor: String) {\n\taddress(address: ${'$'}owner) {\n\t\tstakedSuis(first: ${'$'}limit, after: ${'$'}cursor) {\n\t\t\tpageInfo {\n\t\t\t\thasNextPage\n\t\t\t\tendCursor\n\t\t\t}\n\t\t\tnodes {\n\t\t\t\t...RPC_STAKE_FIELDS\n\t\t\t}\n\t\t}\n\t}\n}\n\nfragment RPC_STAKE_FIELDS on StakedSui {\n\tprincipal\n\tactivatedEpoch {\n\t\tepochId\n\t\treferenceGasPrice\n\t}\n\tstakeStatus\n\trequestedEpoch {\n\t\tepochId\n\t}\n\t# staking pool can be read from contents\n\tcontents {\n\t\tjson\n\t}\n\n\taddress\n\testimatedReward\n\n\t# validatorAddress?\n}"

@Generated
@Serializable
public class GetStakes(
  override val variables: GetStakes.Variables,
) : GraphQLClientRequest<GetStakes.Result>() {
  @Required
  override val query: String = GET_STAKES

  @Required
  override val operationName: String? = "getStakes"

  @Generated
  @Serializable
  public data class Variables(
    public val owner: SuiAddress,
    public val limit: Int? = null,
    public val cursor: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Look-up an Account by its SuiAddress.
     */
    public val address: Address? = null,
  )
}
