package xyz.mcxross.ksui.generated

import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getstakesbyids.ObjectConnection

public const val GET_STAKES_BY_IDS: String =
    "query getStakesByIds(${'$'}ids: [SuiAddress!]!, ${'$'}limit: Int, ${'$'}cursor: String) {\n    objects(first: ${'$'}limit, after: ${'$'}cursor, filter: { objectIds: ${'$'}ids }) {\n        pageInfo {\n            hasNextPage\n            endCursor\n        }\n        nodes {\n            asMoveObject {\n                asStakedSui {\n                    ...RPC_STAKE_FIELDS\n                }\n            }\n        }\n    }\n}\n\nfragment RPC_STAKE_FIELDS on StakedSui {\n    principal\n    activatedEpoch {\n        epochId\n        referenceGasPrice\n    }\n    stakeStatus\n    requestedEpoch {\n        epochId\n    }\n    # staking pool can be read from contents\n    contents {\n        json\n    }\n\n    address\n    estimatedReward\n\n    # validatorAddress?\n}"

@Generated
@Serializable
public class GetStakesByIds(
  override val variables: GetStakesByIds.Variables,
) : GraphQLClientRequest<GetStakesByIds.Result>() {
  @Required
  override val query: String = GET_STAKES_BY_IDS

  @Required
  override val operationName: String? = "getStakesByIds"

  @Generated
  @Serializable
  public data class Variables(
    public val ids: List<SuiAddress>,
    public val limit: Int? = null,
    public val cursor: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The objects that exist in the network.
     */
    public val objects: ObjectConnection,
  )
}
