package xyz.mcxross.ksui.generated

import kotlin.String

/**
 * String containing 32B hex-encoded address, with a leading "0x". Leading zeroes can be omitted on
 * input but will always appear in outputs (SuiAddress in output is guaranteed to be 66 characters
 * long).
 */
public typealias SuiAddress = String

/**
 * String representation of an arbitrary width, possibly signed integer.
 */
public typealias BigInt = String

/**
 * Arbitrary JSON data.
 */
public typealias JSON = String

/**
 * String containing Base64-encoded binary data.
 */
public typealias Base64 = String

/**
 * ISO-8601 Date and Time: RFC3339 in UTC with format: YYYY-MM-DDTHH:MM:SS.mmmZ. Note that the
 * milliseconds part is optional, and it may be omitted if its value is 0.
 */
public typealias DateTime = String

/**
 * The shape of an abstract Move Type (a type that can contain free type parameters, and can
 * optionally be taken by reference), corresponding to the following recursive type:
 *
 * type OpenMoveTypeSignature = {
 * ref: ("&" | "&mut")?,
 * body: OpenMoveTypeSignatureBody,
 * }
 *
 * type OpenMoveTypeSignatureBody =
 * "address"
 * | "bool"
 * | "u8" | "u16" | ... | "u256"
 * | { vector: OpenMoveTypeSignatureBody }
 * | {
 * datatype {
 * package: string,
 * module: string,
 * type: string,
 * typeParameters: [OpenMoveTypeSignatureBody]
 * }
 * }
 * | { typeParameter: number }
 */
public typealias OpenMoveTypeSignature = String

/**
 * The shape of a concrete Move Type (a type with all its type parameters instantiated with concrete
 * types), corresponding to the following recursive type:
 *
 * type MoveTypeLayout =
 * "address"
 * | "bool"
 * | "u8" | "u16" | ... | "u256"
 * | { vector: MoveTypeLayout }
 * | {
 * struct: {
 * type: string,
 * fields: [{ name: string, layout: MoveTypeLayout }],
 * }
 * }
 */
public typealias MoveTypeLayout = String

/**
 * The contents of a Move Value, corresponding to the following recursive type:
 *
 * type MoveData =
 * { Address: SuiAddress }
 * | { UID:     SuiAddress }
 * | { ID:      SuiAddress }
 * | { Bool:    bool }
 * | { Number:  BigInt }
 * | { String:  string }
 * | { Vector:  [MoveData] }
 * | { Option:   MoveData? }
 * | { Struct:  [{ name: string, value: MoveData }] }
 */
public typealias MoveData = String

/**
 * The signature of a concrete Move Type (a type with all its type parameters instantiated with
 * concrete types, that contains no references), corresponding to the following recursive type:
 *
 * type MoveTypeSignature =
 * "address"
 * | "bool"
 * | "u8" | "u16" | ... | "u256"
 * | { vector: MoveTypeSignature }
 * | {
 * datatype: {
 * package: string,
 * module: string,
 * type: string,
 * typeParameters: [MoveTypeSignature],
 * }
 * }
 */
public typealias MoveTypeSignature = String
