package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.paginatemovemodulelists.Object

public const val PAGINATE_MOVE_MODULE_LISTS: String =
    "query paginateMoveModuleLists(\n    ${'$'}packageId: SuiAddress!\n    ${'$'}module: String!\n    ${'$'}hasMoreFriends: Boolean!\n    ${'$'}hasMoreStructs: Boolean!\n    ${'$'}hasMoreFunctions: Boolean!\n    ${'$'}afterFriends: String\n    ${'$'}afterStructs: String\n    ${'$'}afterFunctions: String\n) {\n    object(address: ${'$'}packageId) {\n        asMovePackage {\n            module(name: ${'$'}module) {\n                friends(after: ${'$'}afterFriends) @include(if: ${'$'}hasMoreFriends) {\n                    pageInfo {\n                        hasNextPage\n                        endCursor\n                    }\n                    nodes {\n                        name\n                        package {\n                            address\n                        }\n                    }\n                }\n                structs(after: ${'$'}afterStructs) @include(if: ${'$'}hasMoreStructs) {\n                    pageInfo {\n                        hasNextPage\n                        endCursor\n                    }\n                    nodes {\n                        ...RPC_MOVE_STRUCT_FIELDS\n                    }\n                }\n                functions(after: ${'$'}afterFunctions) @include(if: ${'$'}hasMoreFunctions) {\n                    pageInfo {\n                        hasNextPage\n                        endCursor\n                    }\n                    nodes {\n                        ...RPC_MOVE_FUNCTION_FIELDS\n                    }\n                }\n            }\n        }\n    }\n}\n\nfragment RPC_MOVE_FUNCTION_FIELDS on MoveFunction {\n    name\n    visibility\n    isEntry\n    parameters {\n        signature\n    }\n    typeParameters {\n        constraints\n    }\n    return {\n        repr\n        signature\n    }\n}\n\nfragment RPC_MOVE_STRUCT_FIELDS on MoveStruct {\n    name\n    abilities\n    fields {\n        name\n        type {\n            signature\n        }\n    }\n    typeParameters {\n        isPhantom\n        constraints\n    }\n}"

@Generated
@Serializable
public class PaginateMoveModuleLists(
  override val variables: PaginateMoveModuleLists.Variables,
) : GraphQLClientRequest<PaginateMoveModuleLists.Result>() {
  @Required
  override val query: String = PAGINATE_MOVE_MODULE_LISTS

  @Required
  override val operationName: String? = "paginateMoveModuleLists"

  @Generated
  @Serializable
  public data class Variables(
    public val packageId: SuiAddress,
    public val module: String,
    public val hasMoreFriends: Boolean,
    public val hasMoreStructs: Boolean,
    public val hasMoreFunctions: Boolean,
    public val afterFriends: String? = null,
    public val afterStructs: String? = null,
    public val afterFunctions: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The object corresponding to the given address at the (optionally) given version.
     * When no version is given, the latest version is returned.
     */
    public val `object`: Object? = null,
  )
}
