package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.paginatetransactionblocklists.TransactionBlock

public const val PAGINATE_TRANSACTION_BLOCK_LISTS: String =
    "query paginateTransactionBlockLists(\n    ${'$'}digest: String!\n    ${'$'}hasMoreEvents: Boolean!\n    ${'$'}hasMoreBalanceChanges: Boolean!\n    ${'$'}hasMoreObjectChanges: Boolean!\n    ${'$'}afterEvents: String\n    ${'$'}afterBalanceChanges: String\n    ${'$'}afterObjectChanges: String\n) {\n    transactionBlock(digest: ${'$'}digest) {\n        ...PAGINATE_TRANSACTION_LISTS\n    }\n}\n\nfragment PAGINATE_TRANSACTION_LISTS on TransactionBlock {\n    effects {\n        events(after: ${'$'}afterEvents) @include(if: ${'$'}hasMoreEvents) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                ...RPC_EVENTS_FIELDS\n            }\n        }\n        balanceChanges(after: ${'$'}afterBalanceChanges) @include(if: ${'$'}hasMoreBalanceChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                coinType {\n                    repr\n                }\n                owner {\n                    asObject {\n                        address\n                    }\n                    asAddress {\n                        address\n                    }\n                }\n                amount\n            }\n        }\n        objectChanges(after: ${'$'}afterObjectChanges) @include(if: ${'$'}hasMoreObjectChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                address\n                inputState {\n                    version\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                }\n                outputState {\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                    asMovePackage {\n                        modules(first: 10) {\n                            nodes {\n                                name\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n}\n\nfragment RPC_EVENTS_FIELDS on Event {\n    sendingModule {\n        package {\n            address\n        }\n        name\n    }\n    sender {\n        address\n    }\n    type {\n        repr\n    }\n    json\n    bcs\n    timestamp\n}"

@Generated
@Serializable
public class PaginateTransactionBlockLists(
  override val variables: PaginateTransactionBlockLists.Variables,
) : GraphQLClientRequest<PaginateTransactionBlockLists.Result>() {
  @Required
  override val query: String = PAGINATE_TRANSACTION_BLOCK_LISTS

  @Required
  override val operationName: String? = "paginateTransactionBlockLists"

  @Generated
  @Serializable
  public data class Variables(
    public val digest: String,
    public val hasMoreEvents: Boolean,
    public val hasMoreBalanceChanges: Boolean,
    public val hasMoreObjectChanges: Boolean,
    public val afterEvents: String? = null,
    public val afterBalanceChanges: String? = null,
    public val afterObjectChanges: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Fetch a transaction block by its transaction digest.
     */
    public val transactionBlock: TransactionBlock? = null,
  )
}
