package xyz.mcxross.ksui.generated

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.inputs.EventFilter
import xyz.mcxross.ksui.generated.queryevents.EventConnection

public const val QUERY_EVENTS: String =
    "query queryEvents(\n\t${'$'}filter: EventFilter!\n\t${'$'}before: String\n\t${'$'}after: String\n\t${'$'}first: Int\n\t${'$'}last: Int\n) {\n\tevents(filter: ${'$'}filter, first: ${'$'}first, after: ${'$'}after, last: ${'$'}last, before: ${'$'}before) {\n\t\tpageInfo {\n\t\t\thasNextPage\n\t\t\thasPreviousPage\n\t\t\tendCursor\n\t\t\tstartCursor\n\t\t}\n\t\tnodes {\n\t\t\t...RPC_EVENTS_FIELDS\n\t\t}\n\t}\n}\n\nfragment RPC_EVENTS_FIELDS on Event {\n\tsendingModule {\n\t\tpackage {\n\t\t\taddress\n\t\t}\n\t\tname\n\t}\n\tsender {\n\t\taddress\n\t}\n\ttype {\n\t\trepr\n\t}\n\tjson\n\tbcs\n\ttimestamp\n}"

@Generated
@Serializable
public class QueryEvents(
  override val variables: QueryEvents.Variables,
) : GraphQLClientRequest<QueryEvents.Result>() {
  @Required
  override val query: String = QUERY_EVENTS

  @Required
  override val operationName: String? = "queryEvents"

  @Generated
  @Serializable
  public data class Variables(
    public val filter: EventFilter,
    public val before: String? = null,
    public val after: String? = null,
    public val first: Int? = null,
    public val last: Int? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The events that exist in the network.
     */
    public val events: EventConnection,
  )
}
