package xyz.mcxross.ksui.generated.getcurrentepoch

import kotlin.Int
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.DateTime

/**
 * Operation of the Sui network is temporally partitioned into non-overlapping epochs,
 * and the network aims to keep epochs roughly the same duration as each other.
 * During a particular epoch the following data is fixed:
 *
 * - the protocol version
 * - the reference gas price
 * - the set of participating validators
 */
@Generated
@Serializable
public data class Epoch(
  /**
   * The epoch's id as a sequence number that starts at 0 and is incremented by one at every epoch
   * change.
   */
  public val epochId: Int,
  /**
   * Validator related properties, including the active validators.
   */
  public val validatorSet: ValidatorSet? = null,
  /**
   * The total number of transaction blocks in this epoch.
   */
  public val totalTransactions: Int? = null,
  /**
   * The epoch's corresponding checkpoints.
   */
  public val firstCheckpoint: CheckpointConnection,
  /**
   * The epoch's starting timestamp.
   */
  public val startTimestamp: DateTime,
  /**
   * The epoch's ending timestamp.
   */
  public val endTimestamp: DateTime? = null,
  /**
   * The minimum gas price that a quorum of validators are guaranteed to sign a transaction for.
   */
  public val referenceGasPrice: BigInt? = null,
)
