package xyz.mcxross.ksui.generated.getcurrentepoch

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt

@Generated
@Serializable
public data class Validator(
  /**
   * The number of epochs for which this validator has been below the
   * low stake threshold.
   */
  public val atRisk: Int?,
  /**
   * The fee charged by the validator for staking services.
   */
  public val commissionRate: Int?,
  /**
   * Number of exchange rates in the table.
   */
  public val exchangeRatesSize: Int?,
  /**
   * Validator's description.
   */
  public val description: String?,
  /**
   * The reference gas price for this epoch.
   */
  public val gasPrice: BigInt?,
  /**
   * Validator's url containing their custom image.
   */
  public val imageUrl: String?,
  /**
   * Validator's name.
   */
  public val name: String?,
  /**
   * Validator's set of credentials such as public keys, network addresses and others.
   */
  public val credentials: ValidatorCredentials?,
  /**
   * The validator's gas price quote for the next epoch.
   */
  public val nextEpochGasPrice: BigInt?,
  /**
   * Validator's set of credentials for the next epoch.
   */
  public val nextEpochCredentials: ValidatorCredentials?,
  /**
   * The total number of SUI tokens in this pool plus
   * the pending stake amount for this epoch.
   */
  public val nextEpochStake: BigInt?,
  /**
   * The proposed next epoch fee for the validator's staking services.
   */
  public val nextEpochCommissionRate: Int?,
  /**
   * The validator's current valid `Cap` object. Validators can delegate
   * the operation ability to another address. The address holding this `Cap` object
   * can then update the reference gas price and tallying rule on behalf of the validator.
   */
  public val operationCap: MoveObject?,
  /**
   * Pending pool token withdrawn during the current epoch, emptied at epoch boundaries.
   */
  public val pendingPoolTokenWithdraw: BigInt?,
  /**
   * Pending stake amount for this epoch.
   */
  public val pendingStake: BigInt?,
  /**
   * Pending stake withdrawn during the current epoch, emptied at epoch boundaries.
   */
  public val pendingTotalSuiWithdraw: BigInt?,
  /**
   * Total number of pool tokens issued by the pool.
   */
  public val poolTokenBalance: BigInt?,
  /**
   * Validator's homepage URL.
   */
  public val projectUrl: String?,
  /**
   * The epoch stake rewards will be added here at the end of each epoch.
   */
  public val rewardsPool: BigInt?,
  /**
   * The epoch at which this pool became active.
   */
  public val stakingPoolActivationEpoch: Int?,
  /**
   * The total number of SUI tokens in this pool.
   */
  public val stakingPoolSuiBalance: BigInt?,
  /**
   * The validator's address.
   */
  public val address: Address,
  /**
   * The voting power of this validator in basis points (e.g., 100 = 1% voting power).
   */
  public val votingPower: Int?,
)
