package xyz.mcxross.ksui.generated.getdynamicfields

import kotlin.Int
import kotlin.String
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.JSON
import xyz.mcxross.ksui.generated.SuiAddress

@Generated
@Serializable
public sealed class DynamicFieldValue

@Generated
@Serializable
@SerialName(value = "MoveValue")
public data class MoveValue2(
  /**
   * Representation of a Move value in JSON, where:
   *
   * - Addresses, IDs, and UIDs are represented in canonical form, as JSON strings.
   * - Bools are represented by JSON boolean literals.
   * - u8, u16, and u32 are represented as JSON numbers.
   * - u64, u128, and u256 are represented as JSON strings.
   * - Vectors are represented by JSON arrays.
   * - Structs are represented by JSON objects.
   * - Empty optional values are represented by `null`.
   *
   * This form is offered as a less verbose convenience in cases where the layout of the type is
   * known by the client.
   */
  public val json: JSON,
  /**
   * The value's Move type.
   */
  public val type: MoveType2,
) : DynamicFieldValue()

/**
 * The representation of an object as a Move Object, which exposes additional information
 * (content, module that governs it, version, is transferrable, etc.) about this object.
 */
@Generated
@Serializable
@SerialName(value = "MoveObject")
public data class MoveObject(
  /**
   * Displays the contents of the Move object in a JSON string and through GraphQL types. Also
   * provides the flat representation of the type signature, and the BCS of the corresponding
   * data.
   */
  public val contents: MoveValue3?,
  public val address: SuiAddress,
  /**
   * 32-byte hash that identifies the object's contents, encoded as a Base58 string.
   */
  public val digest: String?,
  public val version: Int,
) : DynamicFieldValue()

/**
 * Fallback DynamicFieldValue implementation that will be used when unknown/unhandled type is
 * encountered.
 *
 * NOTE: This fallback logic has to be manually registered with the instance of
 * GraphQLClientKotlinxSerializer. See documentation for details.
 */
@Generated
@Serializable
public class DefaultDynamicFieldValueImplementation() : DynamicFieldValue()
