package xyz.mcxross.ksui.generated.getlatestsuisystemstate

import kotlin.Int
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.DateTime

/**
 * Operation of the Sui network is temporally partitioned into non-overlapping epochs,
 * and the network aims to keep epochs roughly the same duration as each other.
 * During a particular epoch the following data is fixed:
 *
 * - the protocol version
 * - the reference gas price
 * - the set of participating validators
 */
@Generated
@Serializable
public data class Epoch(
  /**
   * The epoch's id as a sequence number that starts at 0 and is incremented by one at every epoch
   * change.
   */
  public val epochId: Int,
  /**
   * The epoch's starting timestamp.
   */
  public val startTimestamp: DateTime,
  /**
   * The epoch's ending timestamp.
   */
  public val endTimestamp: DateTime? = null,
  /**
   * The minimum gas price that a quorum of validators are guaranteed to sign a transaction for.
   */
  public val referenceGasPrice: BigInt? = null,
  /**
   * Information about whether this epoch was started in safe mode, which happens if the full epoch
   * change logic fails for some reason.
   */
  public val safeMode: SafeMode? = null,
  /**
   * Parameters related to the subsidy that supplements staking rewards
   */
  public val systemStakeSubsidy: StakeSubsidy? = null,
  /**
   * SUI set aside to account for objects stored on-chain, at the start of the epoch.
   * This is also used for storage rebates.
   */
  public val storageFund: StorageFund? = null,
  /**
   * The value of the `version` field of `0x5`, the `0x3::sui::SuiSystemState` object.  This
   * version changes whenever the fields contained in the system state object (held in a dynamic
   * field attached to `0x5`) change.
   */
  public val systemStateVersion: Int? = null,
  /**
   * Details of the system that are decided during genesis.
   */
  public val systemParameters: SystemParameters? = null,
  /**
   * The epoch's corresponding protocol configuration, including the feature flags and the
   * configuration options.
   */
  public val protocolConfigs: ProtocolConfigs,
  /**
   * Validator related properties, including the active validators.
   */
  public val validatorSet: ValidatorSet? = null,
)
