package xyz.mcxross.ksui.generated.getlatestsuisystemstate

import kotlin.Int
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt

/**
 * Parameters that control the distribution of the stake subsidy.
 */
@Generated
@Serializable
public data class StakeSubsidy(
  /**
   * SUI set aside for stake subsidies -- reduces over time as stake subsidies are paid out over
   * time.
   */
  public val balance: BigInt? = null,
  /**
   * Amount of stake subsidy deducted from the balance per distribution -- decays over time.
   */
  public val currentDistributionAmount: BigInt? = null,
  /**
   * Percentage of the current distribution amount to deduct at the end of the current subsidy
   * period, expressed in basis points.
   */
  public val decreaseRate: Int? = null,
  /**
   * Number of times stake subsidies have been distributed subsidies are distributed with other
   * staking rewards, at the end of the epoch.
   */
  public val distributionCounter: Int? = null,
  /**
   * Maximum number of stake subsidy distributions that occur with the same distribution amount
   * (before the amount is reduced).
   */
  public val periodLength: Int? = null,
)
