package xyz.mcxross.ksui.generated.getlatestsuisystemstate

import kotlin.Int
import kotlin.collections.List
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.SuiAddress

/**
 * Representation of `0x3::validator_set::ValidatorSet`.
 */
@Generated
@Serializable
public data class ValidatorSet(
  /**
   * The current set of active validators.
   */
  public val activeValidators: ValidatorConnection,
  /**
   * Size of the inactive pools `Table`.
   */
  public val inactivePoolsSize: Int? = null,
  /**
   * Size of the pending active validators table.
   */
  public val pendingActiveValidatorsSize: Int? = null,
  /**
   * Size of the stake pool mappings `Table`.
   */
  public val stakingPoolMappingsSize: Int? = null,
  /**
   * Size of the validator candidates `Table`.
   */
  public val validatorCandidatesSize: Int? = null,
  /**
   * Validators that are pending removal from the active validator set, expressed as indices in
   * to `activeValidators`.
   */
  public val pendingRemovals: List<Int>? = null,
  /**
   * Total amount of stake for all active validators at the beginning of the epoch.
   */
  public val totalStake: BigInt? = null,
  /**
   * Object ID of the `Table` storing the mapping from staking pool ids to the addresses
   * of the corresponding validators. This is needed because a validator's address
   * can potentially change but the object ID of its pool will not.
   */
  public val stakingPoolMappingsId: SuiAddress? = null,
  /**
   * Object ID of the wrapped object `TableVec` storing the pending active validators.
   */
  public val pendingActiveValidatorsId: SuiAddress? = null,
  /**
   * Object ID of the `Table` storing the validator candidates.
   */
  public val validatorCandidatesId: SuiAddress? = null,
  /**
   * Object ID of the `Table` storing the inactive staking pools.
   */
  public val inactivePoolsId: SuiAddress? = null,
)
