package xyz.mcxross.ksui.generated.getprotocolconfig

import kotlin.Int
import kotlin.collections.List
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated

/**
 * Constants that control how the chain operates.
 *
 * These can only change during protocol upgrades which happen on epoch boundaries.
 */
@Generated
@Serializable
public data class ProtocolConfigs(
  /**
   * The protocol is not required to change on every epoch boundary, so the protocol version
   * tracks which change to the protocol these configs are from.
   */
  public val protocolVersion: Int,
  /**
   * List all available configurations and their values.  These configurations can take any value
   * (but they will all be represented in string form), and do not include feature flags.
   */
  public val configs: List<ProtocolConfigAttr>,
  /**
   * List all available feature flags and their values.  Feature flags are a form of boolean
   * configuration that are usually used to gate features while they are in development.  Once a
   * flag has been enabled, it is rare for it to be disabled.
   */
  public val featureFlags: List<ProtocolConfigFeatureFlag>,
)
