package xyz.mcxross.ksui.generated.getreferencegasprice

import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt

/**
 * Operation of the Sui network is temporally partitioned into non-overlapping epochs,
 * and the network aims to keep epochs roughly the same duration as each other.
 * During a particular epoch the following data is fixed:
 *
 * - the protocol version
 * - the reference gas price
 * - the set of participating validators
 */
@Generated
@Serializable
public data class Epoch(
  /**
   * The minimum gas price that a quorum of validators are guaranteed to sign a transaction for.
   */
  public val referenceGasPrice: BigInt? = null,
)
