package xyz.mcxross.ksui.generated.getstakesbyids

import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.SuiAddress
import xyz.mcxross.ksui.generated.enums.StakeStatus

/**
 * Represents a `0x3::staking_pool::StakedSui` Move object on-chain.
 */
@Generated
@Serializable
public data class StakedSui(
  /**
   * The SUI that was initially staked.
   */
  public val principal: BigInt?,
  /**
   * The epoch at which this stake became active.
   */
  public val activatedEpoch: Epoch?,
  /**
   * A stake can be pending, active, or unstaked
   */
  public val stakeStatus: StakeStatus,
  /**
   * The epoch at which this object was requested to join a stake pool.
   */
  public val requestedEpoch: Epoch2?,
  /**
   * Displays the contents of the Move object in a JSON string and through GraphQL types. Also
   * provides the flat representation of the type signature, and the BCS of the corresponding
   * data.
   */
  public val contents: MoveValue?,
  public val address: SuiAddress,
  /**
   * The estimated reward for this stake object, calculated as:
   *
   * principal * (initial_stake_rate / current_stake_rate - 1.0)
   *
   * Or 0, if this value is negative, where:
   *
   * - `initial_stake_rate` is the stake rate at the epoch this stake was activated at.
   * - `current_stake_rate` is the stake rate in the current epoch.
   *
   * This value is only available if the stake is active.
   */
  public val estimatedReward: BigInt?,
)
