package xyz.mcxross.ksui.generated.multigetobjects

import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.SuiAddress

/**
 * An object in Sui is a package (set of Move bytecode modules) or object (typed data structure
 * with fields) with additional metadata detailing its id, version, transaction digest, owner
 * field indicating how this object can be accessed.
 */
@Generated
@Serializable
public data class Object(
  public val objectId: SuiAddress,
  public val version: Int,
  /**
   * Attempts to convert the object into a MoveObject
   */
  public val asMoveObject: MoveObject?,
  /**
   * The owner type of this object: Immutable, Shared, Parent, Address
   * Immutable and Shared Objects do not have owners.
   */
  public val owner: ObjectOwner?,
  /**
   * The transaction block that created this version of the object.
   */
  public val previousTransactionBlock: TransactionBlock?,
  /**
   * The amount of SUI we would rebate if this object gets deleted or mutated. This number is
   * recalculated based on the present storage gas price.
   */
  public val storageRebate: BigInt?,
  /**
   * 32-byte hash that identifies the object's current contents, encoded as a Base58 string.
   */
  public val digest: String?,
  /**
   * The set of named templates defined on-chain for the type of this object, to be handled
   * off-chain. The server substitutes data from the object into these templates to generate a
   * display string per template.
   */
  public val display: List<DisplayEntry>?,
)
