package xyz.mcxross.ksui.generated.paginatetransactionblocklists

import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.Base64
import xyz.mcxross.ksui.generated.DateTime
import xyz.mcxross.ksui.generated.JSON

@Generated
@Serializable
public data class Event(
  /**
   * The Move module containing some function that when called by
   * a programmable transaction block (PTB) emitted this event.
   * For example, if a PTB invokes A::m1::foo, which internally
   * calls A::m2::emit_event to emit an event,
   * the sending module would be A::m1.
   */
  public val sendingModule: MoveModule?,
  /**
   * Address of the sender of the event
   */
  public val sender: Address?,
  /**
   * The value's Move type.
   */
  public val type: MoveType,
  /**
   * Representation of a Move value in JSON, where:
   *
   * - Addresses, IDs, and UIDs are represented in canonical form, as JSON strings.
   * - Bools are represented by JSON boolean literals.
   * - u8, u16, and u32 are represented as JSON numbers.
   * - u64, u128, and u256 are represented as JSON strings.
   * - Vectors are represented by JSON arrays.
   * - Structs are represented by JSON objects.
   * - Empty optional values are represented by `null`.
   *
   * This form is offered as a less verbose convenience in cases where the layout of the type is
   * known by the client.
   */
  public val json: JSON,
  /**
   * The BCS representation of this value, Base64 encoded.
   */
  public val bcs: Base64,
  /**
   * UTC timestamp in milliseconds since epoch (1/1/1970)
   */
  public val timestamp: DateTime?,
)
