package xyz.mcxross.ksui.generated

import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getcheckpoint.Checkpoint
import xyz.mcxross.ksui.generated.inputs.CheckpointId

public const val GET_CHECKPOINT: String =
    "query getCheckpoint(${'$'}id: CheckpointId) {\n    checkpoint(id: ${'$'}id) {\n        ...RPC_Checkpoint_Fields\n    }\n}\n\nfragment RPC_Checkpoint_Fields on Checkpoint {\n    # checkpointCommitments\n    digest\n    epoch {\n        epochId\n    }\n\n    rollingGasSummary {\n        computationCost\n        storageCost\n        storageRebate\n        nonRefundableStorageFee\n    }\n    networkTotalTransactions\n    previousCheckpointDigest\n    sequenceNumber\n    timestamp\n    validatorSignatures\n    transactionBlocks {\n        pageInfo {\n            hasNextPage\n            endCursor\n        }\n        nodes {\n            digest\n        }\n    }\n    endOfEpoch: transactionBlocks(last: 1, filter: { kind: SYSTEM_TX }) {\n        nodes {\n            kind {\n                __typename\n                ... on EndOfEpochTransaction {\n                    transactions(last: 1) {\n                        nodes {\n                            __typename\n                            ... on ChangeEpochTransaction {\n                                epoch {\n                                    validatorSet {\n                                        activeValidators {\n                                            pageInfo {\n                                                hasNextPage\n                                                endCursor\n                                            }\n                                            nodes {\n                                                credentials {\n                                                    protocolPubKey\n                                                }\n                                                votingPower\n                                            }\n                                        }\n                                    }\n                                    protocolConfigs {\n                                        protocolVersion\n                                    }\n                                    epochId\n                                }\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n}"

@Generated
@Serializable
public class GetCheckpoint(
  override val variables: GetCheckpoint.Variables,
) : GraphQLClientRequest<GetCheckpoint.Result>() {
  @Required
  override val query: String = GET_CHECKPOINT

  @Required
  override val operationName: String? = "getCheckpoint"

  @Generated
  @Serializable
  public data class Variables(
    public val id: CheckpointId? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Fetch checkpoint information by sequence number or digest (defaults to the latest available
     * checkpoint).
     */
    public val checkpoint: Checkpoint? = null,
  )
}
