package xyz.mcxross.ksui.generated

import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getbalance.Address

public const val GET_BALANCE: String =
    "query getBalance(${'$'}owner: SuiAddress!, ${'$'}type: String = \"0x2::sui::SUI\") {\n\taddress(address: ${'$'}owner) {\n\t\tbalance(type: ${'$'}type) {\n\t\t\tcoinType {\n\t\t\t\trepr\n\t\t\t}\n\t\t\tcoinObjectCount\n\t\t\ttotalBalance\n\t\t}\n\t}\n}"

@Generated
@Serializable
public class GetBalance(
  override val variables: GetBalance.Variables,
) : GraphQLClientRequest<GetBalance.Result>() {
  @Required
  override val query: String = GET_BALANCE

  @Required
  override val operationName: String? = "getBalance"

  @Generated
  @Serializable
  public data class Variables(
    public val owner: SuiAddress,
    public val type: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Look-up an Account by its SuiAddress.
     */
    public val address: Address? = null,
  )
}
