package xyz.mcxross.ksui.generated

import kotlin.Any
import kotlin.String
import kotlinx.serialization.Contextual
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.getlatestsuisystemstate.Epoch

public const val GET_LATEST_SUI_SYSTEM_STATE: String =
    "query getLatestSuiSystemState {\n\tepoch {\n\t\tepochId\n\t\tstartTimestamp\n\t\tendTimestamp\n\t\treferenceGasPrice\n\t\tsafeMode {\n\t\t\tenabled\n\t\t\tgasSummary {\n\t\t\t\tcomputationCost\n\t\t\t\tnonRefundableStorageFee\n\t\t\t\tstorageCost\n\t\t\t\tstorageRebate\n\t\t\t}\n\t\t}\n\n\t\tsystemStakeSubsidy {\n\t\t\tbalance\n\t\t\tcurrentDistributionAmount\n\t\t\tdecreaseRate\n\t\t\tdistributionCounter\n\t\t\tperiodLength\n\t\t}\n\n\t\tstorageFund {\n\t\t\tnonRefundableBalance\n\t\t\ttotalObjectStorageRebates\n\t\t}\n\t\tsystemStateVersion\n\t\tsystemParameters {\n\t\t\tminValidatorCount\n\t\t\tmaxValidatorCount\n\t\t\tminValidatorJoiningStake\n\t\t\tdurationMs\n\t\t\tvalidatorLowStakeThreshold\n\t\t\tvalidatorLowStakeGracePeriod\n\t\t\tvalidatorVeryLowStakeThreshold\n\t\t\tstakeSubsidyStartEpoch\n\t\t}\n\t\tprotocolConfigs {\n\t\t\tprotocolVersion\n\t\t}\n\t\tvalidatorSet {\n\t\t\tactiveValidators {\n\t\t\t\tpageInfo {\n\t\t\t\t\thasNextPage\n\t\t\t\t\tendCursor\n\t\t\t\t}\n\t\t\t\tnodes {\n\t\t\t\t\t...RPC_VALIDATOR_FIELDS\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tinactivePoolsSize\n\t\t\tpendingActiveValidatorsSize\n\t\t\tstakingPoolMappingsSize\n\t\t\tvalidatorCandidatesSize\n\t\t\tpendingRemovals\n\t\t\ttotalStake\n\t\t\tstakingPoolMappingsId\n\t\t\tpendingActiveValidatorsId\n\t\t\tvalidatorCandidatesId\n\t\t\tinactivePoolsId\n\t\t}\n\t}\n}\n\nfragment RPC_VALIDATOR_FIELDS on Validator {\n\tatRisk\n\tcommissionRate\n\texchangeRatesSize\n\tdescription\n\tgasPrice\n\timageUrl\n\tname\n\tcredentials {\n\t\t...RPC_CREDENTIAL_FIELDS\n\t}\n\tnextEpochGasPrice\n\tnextEpochCredentials {\n\t\t...RPC_CREDENTIAL_FIELDS\n\t}\n\tnextEpochStake\n\tnextEpochCommissionRate\n\toperationCap {\n\t\taddress\n\t}\n\tpendingPoolTokenWithdraw\n\tpendingStake\n\tpendingTotalSuiWithdraw\n\tpoolTokenBalance\n\tprojectUrl\n\trewardsPool\n\tstakingPoolActivationEpoch\n\tstakingPoolSuiBalance\n\taddress {\n\t\taddress\n\t}\n\tvotingPower\n}\n\nfragment RPC_CREDENTIAL_FIELDS on ValidatorCredentials {\n\tnetAddress\n\tnetworkPubKey\n\tp2PAddress\n\tprimaryAddress\n\tworkerPubKey\n\tworkerAddress\n\tproofOfPossession\n\tprotocolPubKey\n}"

@Generated
@Serializable
public class GetLatestSuiSystemState : GraphQLClientRequest<GetLatestSuiSystemState.Result>() {
  @Required
  override val query: String = GET_LATEST_SUI_SYSTEM_STATE

  @Required
  override val operationName: String? = "getLatestSuiSystemState"

  @Contextual
  override val variables: Any? = null

  @Generated
  @Serializable
  public data class Result(
    /**
     * Fetch epoch information by ID (defaults to the latest epoch).
     */
    public val epoch: Epoch? = null,
  )
}
