package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.multigetobjects.ObjectConnection

public const val MULTI_GET_OBJECTS: String =
    "query multiGetObjects(\n    ${'$'}ids: [SuiAddress!]!\n    ${'$'}limit: Int\n    ${'$'}cursor: String\n    ${'$'}showBcs: Boolean = false\n    ${'$'}showContent: Boolean = false\n    ${'$'}showDisplay: Boolean = false\n    ${'$'}showType: Boolean = false\n    ${'$'}showOwner: Boolean = false\n    ${'$'}showPreviousTransaction: Boolean = false\n    ${'$'}showStorageRebate: Boolean = false\n) {\n    objects(first: ${'$'}limit, after: ${'$'}cursor, filter: { objectIds: ${'$'}ids }) {\n        pageInfo {\n            hasNextPage\n            endCursor\n        }\n        nodes {\n            ...RPC_OBJECT_FIELDS\n        }\n    }\n}\n\nfragment RPC_OBJECT_FIELDS on Object {\n    objectId: address\n    version\n    asMoveObject @include(if: ${'$'}showBcs) {\n        hasPublicTransfer\n        contents {\n            bcs\n            type {\n                repr\n            }\n        }\n    }\n    owner @include(if: ${'$'}showOwner) {\n        ...RPC_OBJECT_OWNER_FIELDS\n    }\n    previousTransactionBlock @include(if: ${'$'}showPreviousTransaction) {\n        digest\n    }\n\n    storageRebate @include(if: ${'$'}showStorageRebate)\n    digest\n    display @include(if: ${'$'}showDisplay) {\n        key\n        value\n        error\n    }\n}\n\nfragment RPC_OBJECT_OWNER_FIELDS on ObjectOwner {\n    __typename\n    ... on AddressOwner {\n        owner {\n            asObject {\n                address\n            }\n            asAddress {\n                address\n            }\n        }\n    }\n    ... on Parent {\n        parent {\n            address\n        }\n    }\n    ... on Shared {\n        initialSharedVersion\n    }\n}"

@Generated
@Serializable
public class MultiGetObjects(
  override val variables: MultiGetObjects.Variables,
) : GraphQLClientRequest<MultiGetObjects.Result>() {
  @Required
  override val query: String = MULTI_GET_OBJECTS

  @Required
  override val operationName: String? = "multiGetObjects"

  @Generated
  @Serializable
  public data class Variables(
    public val ids: List<SuiAddress>,
    public val limit: Int? = null,
    public val cursor: String? = null,
    public val showBcs: Boolean? = null,
    public val showContent: Boolean? = null,
    public val showDisplay: Boolean? = null,
    public val showType: Boolean? = null,
    public val showOwner: Boolean? = null,
    public val showPreviousTransaction: Boolean? = null,
    public val showStorageRebate: Boolean? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The objects that exist in the network.
     */
    public val objects: ObjectConnection,
  )
}
