package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.multigettransactionblocks.TransactionBlockConnection

public const val MULTI_GET_TRANSACTION_BLOCKS: String =
    "query multiGetTransactionBlocks(\n    ${'$'}digests: [String!]!\n    ${'$'}limit: Int\n    ${'$'}cursor: String\n    ${'$'}showBalanceChanges: Boolean = false\n    ${'$'}showEffects: Boolean = false\n    ${'$'}showRawEffects: Boolean = false\n    ${'$'}showEvents: Boolean = false\n    ${'$'}showInput: Boolean = false\n    ${'$'}showObjectChanges: Boolean = false\n    ${'$'}showRawInput: Boolean = false\n) {\n    transactionBlocks(first: ${'$'}limit, after: ${'$'}cursor, filter: { transactionIds: ${'$'}digests }) {\n        pageInfo {\n            hasNextPage\n            hasPreviousPage\n            startCursor\n            endCursor\n        }\n        nodes {\n            ...RPC_TRANSACTION_FIELDS\n        }\n    }\n}\n\nfragment RPC_TRANSACTION_FIELDS on TransactionBlock {\n    digest\n    rawTransaction: bcs @include(if: ${'$'}showRawInput)\n    sender {\n        address\n    }\n\n    signatures\n\n    effects {\n        bcs @include(if: ${'$'}showRawEffects)\n        events @include(if: ${'$'}showEvents) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                ...RPC_EVENTS_FIELDS\n            }\n        }\n        checkpoint {\n            sequenceNumber\n        }\n        timestamp\n        balanceChanges @include(if: ${'$'}showBalanceChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                coinType {\n                    repr\n                }\n                owner {\n                    asObject {\n                        address\n                    }\n                    asAddress {\n                        address\n                    }\n                }\n                amount\n            }\n        }\n\n        objectChanges @include(if: ${'$'}showObjectChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                address\n                inputState {\n                    version\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                }\n                outputState {\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                    asMovePackage {\n                        modules(first: 10) {\n                            nodes {\n                                name\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n}\n\nfragment RPC_EVENTS_FIELDS on Event {\n    sendingModule {\n        package {\n            address\n        }\n        name\n    }\n    sender {\n        address\n    }\n    type {\n        repr\n    }\n    json\n    bcs\n    timestamp\n}"

@Generated
@Serializable
public class MultiGetTransactionBlocks(
  override val variables: MultiGetTransactionBlocks.Variables,
) : GraphQLClientRequest<MultiGetTransactionBlocks.Result>() {
  @Required
  override val query: String = MULTI_GET_TRANSACTION_BLOCKS

  @Required
  override val operationName: String? = "multiGetTransactionBlocks"

  @Generated
  @Serializable
  public data class Variables(
    public val digests: List<String>,
    public val limit: Int? = null,
    public val cursor: String? = null,
    public val showBalanceChanges: Boolean? = null,
    public val showEffects: Boolean? = null,
    public val showRawEffects: Boolean? = null,
    public val showEvents: Boolean? = null,
    public val showInput: Boolean? = null,
    public val showObjectChanges: Boolean? = null,
    public val showRawInput: Boolean? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * The transaction blocks that exist in the network.
     */
    public val transactionBlocks: TransactionBlockConnection,
  )
}
